/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.misc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import jp.crestmuse.cmx.misc.QueueReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueWrapper<E> {
    private Queue<E> queue;
    private ArrayList<E> list;
    private int size;

    public QueueWrapper(Queue<E> queue, int n) {
        this.queue = queue;
        this.size = n;
        this.list = new ArrayList();
    }

    public QueueReader createReader() {
        return new QueueReaderImpl();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueueReaderImpl
    implements QueueReader<E> {
        private int next = 0;

        private QueueReaderImpl() {
        }

        @Override
        public E take() throws InterruptedException {
            if (this.next < QueueWrapper.this.list.size()) {
                return QueueWrapper.this.list.get(this.next++);
            }
            Object e = QueueWrapper.this.queue instanceof BlockingQueue ? ((BlockingQueue)QueueWrapper.this.queue).take() : QueueWrapper.this.queue.poll();
            QueueWrapper.this.list.add(e);
            ++this.next;
            return e;
        }

        @Override
        public E get(int n) {
            if (n < this.next) {
                return QueueWrapper.this.list.get(n);
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public boolean isAvailable(int n) {
            return n < this.next;
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator(){

                @Override
                public boolean hasNext() {
                    return QueueReaderImpl.this.next < QueueWrapper.this.size;
                }

                @Override
                public E next() {
                    try {
                        return QueueReaderImpl.this.take();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new RuntimeException();
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

