/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.filewrappers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.crestmuse.cmx.filewrappers.DeviationInstanceWrapper;
import jp.crestmuse.cmx.filewrappers.MusicXMLWrapper;
import jp.crestmuse.cmx.misc.Ordered;
import jp.crestmuse.cmx.misc.TreeView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviationDataSet {
    private DeviationInstanceWrapper wrapper;
    private TreeView<Control> nonPartwise;
    private Map<String, TreeView<Control>> partwise;
    private List<NotewiseDeviation> notewise;
    private Map<String, TreeView<ExtraNote>> extraNotes;
    private Control last = null;
    private double initSil = 0.0;
    private static final String[] pitchList = new String[]{"C", "C", "D", "D", "E", "F", "F", "G", "G", "A", "A", "B"};
    private static final int[] pitchAlterList = new int[]{0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0};
    private int currentMeasure = Integer.MIN_VALUE;

    DeviationDataSet(DeviationInstanceWrapper deviationInstanceWrapper) {
        this.wrapper = deviationInstanceWrapper;
        this.nonPartwise = new TreeView();
        this.partwise = new HashMap<String, TreeView<Control>>();
        this.notewise = new ArrayList<NotewiseDeviation>();
        this.extraNotes = new HashMap<String, TreeView<ExtraNote>>();
    }

    public DeviationInstanceWrapper getTargetWrapper() {
        return this.wrapper;
    }

    public void setInitialSilence(double d) {
        this.initSil = d;
    }

    public void addNonPartwiseControl(int n, double d, String string, double d2) {
        Control control = new Control();
        control.measure = n;
        control.beat = d;
        control.type = string;
        control.value = d2;
        this.nonPartwise.add(control, "");
        this.last = control;
    }

    public void addNonPartwiseControl(int n, double d, String string) {
        this.addNonPartwiseControl(n, d, string, Double.NaN);
    }

    public void addPartwiseControl(String string, int n, double d, String string2, double d2) {
        Control control = new Control();
        control.measure = n;
        control.beat = d;
        control.type = string2;
        control.value = d2;
        if (this.partwise.containsKey(string)) {
            this.partwise.get(string).add(control, "");
        } else {
            TreeView<Control> treeView = new TreeView<Control>();
            treeView.add(control, "");
            this.partwise.put(string, treeView);
        }
        this.last = control;
    }

    public void addPartwiseControl(String string, int n, double d, String string2) {
        this.addPartwiseControl(string, n, d, string2, Double.NaN);
    }

    public void setAttribute(String string, String string2) {
        if (this.last.attr == null) {
            this.last.attr = new HashMap();
        }
        this.last.attr.put(string, string2);
    }

    public void setAttribute(String string, int n) {
        this.setAttribute(string, String.valueOf(n));
    }

    public void setAttribute(String string, double d) {
        this.setAttribute(string, String.valueOf(d));
    }

    public void addNoteDeviation(MusicXMLWrapper.Note note, double d, double d2, double d3, double d4) {
        NoteDeviation noteDeviation = new NoteDeviation();
        noteDeviation.note = note;
        noteDeviation.attack = d;
        noteDeviation.release = d2;
        noteDeviation.dynamics = d3;
        noteDeviation.endDynamics = d4;
        noteDeviation.name = "note-deviation";
        this.notewise.add(noteDeviation);
    }

    public void addChordDeviation(MusicXMLWrapper.Note note, double d, double d2, double d3, double d4) {
        NoteDeviation noteDeviation = new NoteDeviation();
        noteDeviation.note = note;
        noteDeviation.attack = d;
        noteDeviation.release = d2;
        noteDeviation.dynamics = d3;
        noteDeviation.endDynamics = d4;
        noteDeviation.name = "chord-deviation";
        this.notewise.add(noteDeviation);
    }

    public void addMissNote(MusicXMLWrapper.Note note) {
        MissNote missNote = new MissNote();
        missNote.note = note;
        this.notewise.add(missNote);
    }

    public void addExtraNote(String string, int n, double d, String string2, int n2, int n3, double d2, double d3, double d4) {
        ExtraNote extraNote = new ExtraNote();
        extraNote.measure = n;
        extraNote.beat = d;
        extraNote.pitchStep = string2;
        extraNote.pitchAlter = n2;
        extraNote.pitchOctave = n3;
        extraNote.duration = d2;
        extraNote.dynamics = d3;
        extraNote.endDynamics = d4;
        if (this.extraNotes.containsKey(string)) {
            this.extraNotes.get(string).add(extraNote, "");
        } else {
            TreeView<ExtraNote> treeView = new TreeView<ExtraNote>();
            treeView.add(extraNote, "");
            this.extraNotes.put(string, treeView);
        }
    }

    public void addExtraNote(String string, int n, double d, int n2, double d2, double d3, double d4) {
        this.addExtraNote(string, n, d, pitchList[n2 % 12], pitchAlterList[n2 % 12], n2 / 12 - 1, d2, d3, d4);
    }

    private void controlToWrapper(Control control) {
        if (control != null) {
            if (control.measure > this.currentMeasure) {
                if (this.currentMeasure >= 0) {
                    this.wrapper.returnToParent();
                }
                this.wrapper.addChild("measure");
                this.wrapper.setAttribute("number", control.measure);
                this.currentMeasure = control.measure;
            }
            this.wrapper.addChild("control");
            this.wrapper.setAttribute("beat", control.beat);
            this.wrapper.addChild(control.type);
            if (control.attr != null) {
                Set set = control.attr.entrySet();
                for (Map.Entry entry : set) {
                    this.wrapper.setAttribute((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (!Double.isNaN(control.value)) {
                this.wrapper.addText(control.value);
            }
            this.wrapper.returnToParent();
            this.wrapper.returnToParent();
        }
    }

    private void addControlViewToWrapper(TreeView<Control> treeView) {
        if (!treeView.isempty()) {
            this.controlToWrapper(treeView.getRoot());
            this.currentMeasure = Integer.MIN_VALUE;
            while (treeView.hasElementsAtNextTime()) {
                this.controlToWrapper(treeView.getFirstElementAtNextTime());
                while (treeView.hasMoreElementsAtSameTime()) {
                    this.controlToWrapper(treeView.getNextElementAtSameTime());
                }
            }
            this.wrapper.returnToParent();
        }
    }

    private void extraNoteToWrapper(ExtraNote extraNote) {
        if (extraNote != null) {
            if (extraNote.measure > this.currentMeasure) {
                if (this.currentMeasure >= 0) {
                    this.wrapper.returnToParent();
                }
                this.wrapper.addChild("measure");
                this.wrapper.setAttribute("number", extraNote.measure);
                this.currentMeasure = extraNote.measure;
            }
            this.wrapper.addChild("extra-note");
            this.wrapper.setAttribute("beat", extraNote.beat);
            this.wrapper.addChild("pitch");
            this.wrapper.addChildAndText("step", extraNote.pitchStep);
            this.wrapper.addChildAndText("alter", extraNote.pitchAlter);
            this.wrapper.addChildAndText("octave", extraNote.pitchOctave);
            this.wrapper.returnToParent();
            this.wrapper.addChildAndText("duration", extraNote.duration);
            this.wrapper.addChildAndText("dynamics", extraNote.dynamics);
            this.wrapper.addChildAndText("end-dynamics", extraNote.endDynamics);
            this.wrapper.returnToParent();
        }
    }

    private void addExtraNotesToWrapper(TreeView<ExtraNote> treeView) {
        if (!treeView.isempty()) {
            this.extraNoteToWrapper(treeView.getRoot());
            this.currentMeasure = Integer.MIN_VALUE;
            while (treeView.hasElementsAtNextTime()) {
                this.extraNoteToWrapper(treeView.getFirstElementAtNextTime());
                while (treeView.hasMoreElementsAtSameTime()) {
                    this.extraNoteToWrapper(treeView.getNextElementAtSameTime());
                }
            }
            this.wrapper.returnToParent();
        }
    }

    public void addElementsToWrapper() {
        this.wrapper.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xlink", "http://www.w3.org/1999/xlink");
        this.wrapper.setAttribute("init-silence", this.initSil);
        this.wrapper.addChild("non-partwise");
        this.addControlViewToWrapper(this.nonPartwise);
        this.wrapper.returnToParent();
        this.wrapper.addChild("partwise");
        Set<String> set = this.partwise.keySet();
        for (String object : set) {
            this.wrapper.addChild("part");
            this.wrapper.setAttribute("id", object);
            this.addControlViewToWrapper(this.partwise.get(object));
            this.wrapper.returnToParent();
        }
        this.wrapper.returnToParent();
        this.wrapper.addChild("notewise");
        for (NotewiseDeviation notewiseDeviation : this.notewise) {
            notewiseDeviation.addToWrapper(this.wrapper);
        }
        this.wrapper.returnToParent();
        this.wrapper.addChild("extra-notes");
        set = this.extraNotes.keySet();
        for (String string : set) {
            this.wrapper.addChild("part");
            this.wrapper.setAttribute("id", string);
            this.addExtraNotesToWrapper(this.extraNotes.get(string));
            this.wrapper.returnToParent();
        }
    }

    private class MissNote
    extends NotewiseDeviation {
        private MissNote() {
        }

        void addToWrapper(DeviationInstanceWrapper deviationInstanceWrapper) {
            deviationInstanceWrapper.addChild("miss-note");
            deviationInstanceWrapper.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "#xpointer(" + this.note.getXPathExpression() + ")");
            deviationInstanceWrapper.returnToParent();
        }
    }

    private class NoteDeviation
    extends NotewiseDeviation {
        private String name;
        private double attack;
        private double release;
        private double dynamics;
        private double endDynamics;

        private NoteDeviation() {
        }

        void addToWrapper(DeviationInstanceWrapper deviationInstanceWrapper) {
            deviationInstanceWrapper.addChild(this.name);
            deviationInstanceWrapper.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "#xpointer(" + this.note.getXPathExpression() + ")");
            deviationInstanceWrapper.addChildAndText("attack", this.attack);
            deviationInstanceWrapper.addChildAndText("release", this.release);
            deviationInstanceWrapper.addChildAndText("dynamics", this.dynamics);
            deviationInstanceWrapper.addChildAndText("end-dynamics", this.endDynamics);
            deviationInstanceWrapper.returnToParent();
        }
    }

    private abstract class NotewiseDeviation {
        MusicXMLWrapper.Note note;

        private NotewiseDeviation() {
        }

        abstract void addToWrapper(DeviationInstanceWrapper var1);
    }

    private class ExtraNote
    implements Ordered {
        private int measure;
        private double beat;
        private String pitchStep;
        private int pitchAlter = 0;
        private int pitchOctave;
        private double duration;
        private double dynamics = 1.0;
        private double endDynamics = 1.0;

        private ExtraNote() {
        }

        public final int ordinal() {
            return this.measure;
        }

        public final int subordinal() {
            return (int)(1920.0 * this.beat);
        }
    }

    private class Control
    implements Ordered {
        private int measure;
        private double beat;
        private String type;
        private double value = Double.NaN;
        private HashMap<String, String> attr = null;

        private Control() {
        }

        public final int ordinal() {
            return this.measure;
        }

        public final int subordinal() {
            return (int)(1920.0 * this.beat);
        }
    }
}

