/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.misc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.filewrappers.DeviationDataSet;
import jp.crestmuse.cmx.filewrappers.DeviationInstanceWrapper;
import jp.crestmuse.cmx.filewrappers.MIDIXMLWrapper;
import jp.crestmuse.cmx.filewrappers.MusicXMLWrapper;
import jp.crestmuse.cmx.filewrappers.SCCXMLWrapper;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformanceMatcher3 {
    private static int baseTempo = 120;
    private static final double BASE_DYNAMICS = 100.0;
    private MusicXMLWrapper musicxml;
    private MIDIXMLWrapper midixml;
    private SCCXMLWrapper scoreSCC;
    private SCCXMLWrapper pfmSCC;
    private int scoreTicksPerBeat;
    private int pfmTicksPerBeat;

    public PerformanceMatcher3(MusicXMLWrapper musicXMLWrapper, MIDIXMLWrapper mIDIXMLWrapper) throws ParserConfigurationException, SAXException, IOException, TransformerException {
        this(musicXMLWrapper, mIDIXMLWrapper, mIDIXMLWrapper.ticksPerBeat());
    }

    public PerformanceMatcher3(MusicXMLWrapper musicXMLWrapper, MIDIXMLWrapper mIDIXMLWrapper, int n) throws ParserConfigurationException, SAXException, IOException, TransformerException {
        this.musicxml = musicXMLWrapper;
        this.midixml = mIDIXMLWrapper;
        this.scoreSCC = musicXMLWrapper.makeDeadpanSCCXML(n);
        this.pfmSCC = mIDIXMLWrapper.toSCCXML();
        this.scoreTicksPerBeat = this.scoreSCC.getDivision();
        this.pfmTicksPerBeat = this.pfmSCC.getDivision();
        SCCXMLWrapper.HeaderElement[] headerElementArray = this.pfmSCC.getHeaderElementList();
        if (headerElementArray.length >= 1 && headerElementArray[0].name().equals("TEMPO")) {
            baseTempo = Integer.parseInt(headerElementArray[0].content());
        }
    }

    public DeviationInstanceWrapper extractDeviation() throws ParserConfigurationException, SAXException, IOException, TransformerException {
        DeviationInstanceWrapper deviationInstanceWrapper = DeviationInstanceWrapper.createDeviationInstanceFor(this.musicxml);
        DeviationDataSet deviationDataSet = deviationInstanceWrapper.createDeviationDataSet();
        SCCXMLWrapper.Note[] noteArray = this.scoreSCC.getPartList()[0].getSortedNoteOnlyList(1);
        SCCXMLWrapper.Note[] noteArray2 = this.pfmSCC.getPartList()[0].getSortedNoteOnlyList(100);
        int[] nArray = PerformanceMatcher3.getPath(PerformanceMatcher3.dtw(noteArray, noteArray2, 500));
        int[] nArray2 = new int[nArray.length];
        ArrayList<SCCXMLWrapper.Note> arrayList = new ArrayList<SCCXMLWrapper.Note>();
        PerformanceMatcher3.alignNotes(noteArray, noteArray2, nArray, nArray2, arrayList);
        ArrayList<TempoAndTime> arrayList2 = this.alignBeats(noteArray, noteArray2, nArray2);
        this.interpolateBeatTime(arrayList2);
        double d = PerformanceMatcher3.calcTempo(arrayList2);
        double d2 = arrayList2.get(1).timeInSec;
        deviationDataSet.setInitialSilence(d2);
        String string = this.musicxml.getPartList()[0].id();
        MusicXMLWrapper.Measure[] measureArray = this.musicxml.getPartList()[0].getMeasureList();
        this.setMeasureNumbers(measureArray, arrayList2);
        int n = measureArray[0].number();
        deviationDataSet.addNonPartwiseControl(n, 1.0, "tempo", d);
        PerformanceMatcher3.addTempoDeviations(deviationDataSet, arrayList2, d);
        this.setNotewiseDeviations(deviationDataSet, noteArray, noteArray2, nArray2, arrayList, string, arrayList2);
        deviationDataSet.addElementsToWrapper();
        return deviationInstanceWrapper;
    }

    public static DeviationInstanceWrapper extractDeviation(MusicXMLWrapper musicXMLWrapper, MIDIXMLWrapper mIDIXMLWrapper) throws ParserConfigurationException, SAXException, IOException, TransformerException {
        PerformanceMatcher3 performanceMatcher3 = new PerformanceMatcher3(musicXMLWrapper, mIDIXMLWrapper);
        return performanceMatcher3.extractDeviation();
    }

    public static DeviationInstanceWrapper extractDeviation(MusicXMLWrapper musicXMLWrapper, MIDIXMLWrapper mIDIXMLWrapper, int n) throws ParserConfigurationException, SAXException, IOException, TransformerException {
        PerformanceMatcher3 performanceMatcher3 = new PerformanceMatcher3(musicXMLWrapper, mIDIXMLWrapper, n);
        return performanceMatcher3.extractDeviation();
    }

    private static int[] getPath(DTWMatrix dTWMatrix) {
        int n = dTWMatrix.nrows;
        int n2 = dTWMatrix.ncols;
        int[] nArray = new int[n];
        int n3 = n - 1;
        int n4 = n2 - 1;
        do {
            nArray[n3] = n4;
            DTWMatrix.DTWMatrixElement dTWMatrixElement = dTWMatrix.get(n3, n4);
            n3 = dTWMatrixElement.targetX;
            n4 = dTWMatrixElement.targetY;
        } while (n3 >= 0 || n4 >= 0);
        return nArray;
    }

    private static DTWMatrix dtw(SCCXMLWrapper.Note[] noteArray, SCCXMLWrapper.Note[] noteArray2, int n) {
        int n2 = noteArray.length;
        int n3 = noteArray2.length;
        int n4 = noteArray[n2 - 1].offset();
        int n5 = noteArray2[n3 - 1].offset();
        n = n3;
        DTWMatrix dTWMatrix = new DTWMatrix(n2, n3);
        dTWMatrix.set(-1, -1, 0.0, -1, -1);
        int n6 = 1;
        for (int i = 0; i < n2; ++i) {
            int n7 = 1;
            for (int j = Math.max(0, i - n); j <= Math.min(i + n, n3 - 1); ++j) {
                double d;
                SCCXMLWrapper.Note note = noteArray[i];
                SCCXMLWrapper.Note note2 = noteArray2[j];
                double d2 = PerformanceMatcher3.dist(note, note2, n4, n5);
                double d3 = dTWMatrix.getValue(i - 1, j) + d2 + (double)n6;
                double d4 = dTWMatrix.getValue(i - 1, j - 1) + 2.0 * d2;
                double d5 = Math.min(d4, Math.min(d3, d = dTWMatrix.getValue(i, j - 1) + d2 + (double)n7));
                if (d5 == d4) {
                    dTWMatrix.set(i, j, d5, i - 1, j - 1);
                    n6 = 1;
                    n7 = 1;
                    continue;
                }
                if (d5 == d) {
                    dTWMatrix.set(i, j, d5, i, j - 1);
                    ++n7;
                    continue;
                }
                dTWMatrix.set(i, j, d5, i - 1, j);
                ++n6;
            }
        }
        return dTWMatrix;
    }

    private static double dist(SCCXMLWrapper.Note note, SCCXMLWrapper.Note note2, int n, int n2) {
        int n3 = Math.abs(note.notenum() - note2.notenum());
        double d = Math.abs((double)note.onset() / (double)n - (double)note2.onset() / (double)n2);
        if (n3 == 0) {
            return d;
        }
        if (Math.abs(note.notenum() - note2.notenum()) % 12 == 0) {
            return 10.0 + d;
        }
        return 100.0;
    }

    private static void alignNotes(SCCXMLWrapper.Note[] noteArray, SCCXMLWrapper.Note[] noteArray2, int[] nArray, int[] nArray2, List<SCCXMLWrapper.Note> list) {
        int n;
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = -1;
        }
        boolean[] blArray = new boolean[noteArray2.length];
        for (n = 0; n < blArray.length; ++n) {
            blArray[n] = false;
        }
        n = 0;
        int n2 = 0;
        while (n < nArray2.length - 1) {
            if (nArray2[n] == -1 && !blArray[n2] && noteArray[n].notenum() == noteArray2[n2].notenum()) {
                nArray2[n] = n2;
                blArray[n2] = true;
                if (nArray[n + 1] == n2) {
                    ++n;
                    continue;
                }
                if (nArray[n + 1] - n2 > 1) {
                    ++n2;
                    continue;
                }
                ++n;
                ++n2;
                continue;
            }
            if (nArray[n + 1] == n2) {
                ++n;
                continue;
            }
            if (nArray[n + 1] - n2 > 1) {
                if (!blArray[n2]) {
                    list.add(noteArray2[n2]);
                    blArray[n2] = true;
                }
                ++n2;
                continue;
            }
            if (!blArray[n2]) {
                list.add(noteArray2[n2]);
                blArray[n2] = true;
            }
            ++n;
            ++n2;
        }
        if (nArray2[n] == -1 && !blArray[n2] && noteArray[n].notenum() == noteArray2[n2].notenum()) {
            nArray2[n] = n2;
        } else {
            list.add(noteArray2[n2]);
        }
    }

    private void setNotewiseDeviations(DeviationDataSet deviationDataSet, SCCXMLWrapper.Note[] noteArray, SCCXMLWrapper.Note[] noteArray2, int[] nArray, List<SCCXMLWrapper.Note> list, String string, ArrayList<TempoAndTime> arrayList) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= 0) {
                this.addNoteDeviation(deviationDataSet, noteArray[i], noteArray2[nArray[i]], arrayList);
                continue;
            }
            PerformanceMatcher3.addMissNote(deviationDataSet, noteArray[i]);
        }
        for (SCCXMLWrapper.Note note : list) {
            this.addExtraNote(deviationDataSet, note, string, arrayList);
        }
    }

    private TempoAndTime searchTnT(double d, int n, ArrayList<TempoAndTime> arrayList) {
        int n2 = arrayList.size();
        while (n >= n2 || arrayList.get(n).tickInPfm > d && n > 0) {
            --n;
        }
        while (n < 0 || arrayList.get(n + 1).tickInPfm <= d && n < n2 - 2) {
            ++n;
        }
        return arrayList.get(n);
    }

    private void addNoteDeviation(DeviationDataSet deviationDataSet, SCCXMLWrapper.Note note, SCCXMLWrapper.Note note2, ArrayList<TempoAndTime> arrayList) {
        double d;
        double d2;
        double d3;
        double d4;
        int n = (int)arrayList.get(0).tickInPfm;
        TempoAndTime tempoAndTime = this.searchTnT(note2.onset(), note.onset() / this.scoreTicksPerBeat, arrayList);
        if (tempoAndTime.measure >= 0) {
            d4 = (double)note2.onset() - tempoAndTime.tickInPfm;
            d3 = note.onset() - tempoAndTime.tickInScore;
        } else {
            d4 = (double)note2.onset() - arrayList.get(1).tickInPfm;
            d3 = note.onset() - arrayList.get(1).tickInScore;
        }
        double d5 = d4 * tempoAndTime.tempo / (double)(this.pfmTicksPerBeat * baseTempo) - d3 / (double)this.scoreTicksPerBeat;
        tempoAndTime = this.searchTnT(note2.offset(), note.offset() / this.scoreTicksPerBeat, arrayList);
        if (tempoAndTime.measure >= 0) {
            d2 = (double)note2.offset() - tempoAndTime.tickInPfm;
            d = note.offset() - tempoAndTime.tickInScore;
        } else {
            d2 = (double)note2.offset() - arrayList.get(1).tickInPfm;
            d = note.offset() - arrayList.get(1).tickInScore;
        }
        double d6 = d2 * tempoAndTime.tempo / (double)(this.pfmTicksPerBeat * baseTempo) - d / (double)this.scoreTicksPerBeat;
        double d7 = (double)note2.velocity() / 100.0;
        deviationDataSet.addNoteDeviation(note.getMusicXMLWrapperNote(), d5, d6, d7, d7);
    }

    private static void addMissNote(DeviationDataSet deviationDataSet, SCCXMLWrapper.Note note) {
        deviationDataSet.addMissNote(note.getMusicXMLWrapperNote());
    }

    private void addExtraNote(DeviationDataSet deviationDataSet, SCCXMLWrapper.Note note, String string, ArrayList<TempoAndTime> arrayList) {
        TempoAndTime tempoAndTime;
        int n;
        TempoAndTime tempoAndTime2;
        int n2;
        int n3 = arrayList.size();
        for (n2 = 0; !(n2 >= n3 || (tempoAndTime2 = arrayList.get(n2)).measure == -1 && tempoAndTime2.beat == -1 || tempoAndTime2.tickInPfm > (double)note.onset()); ++n2) {
        }
        tempoAndTime2 = arrayList.get(n2 - 1);
        double d = ((double)note.onset() - tempoAndTime2.tickInPfm) / tempoAndTime2.beatLength();
        for (n = n2 - 1; !(n >= n3 || (tempoAndTime = arrayList.get(n)).measure == -1 && tempoAndTime.beat == -1 || tempoAndTime.tickInPfm > (double)note.offset()); ++n) {
        }
        tempoAndTime = arrayList.get(n - 1);
        double d2 = ((double)note.offset() - tempoAndTime.tickInPfm) / tempoAndTime.beatLength();
        deviationDataSet.addExtraNote(string, tempoAndTime2.measure, (double)tempoAndTime2.beat + d, note.notenum(), (double)(n - n2) + d2 - d, (double)note.velocity() / 100.0, (double)note.velocity() / 100.0);
    }

    private static boolean tickcmp(int n, int n2, int n3) {
        return n >= n2 - n3 && n <= n2 + n3;
    }

    private TempoAndTime getZerothTempoAndTime() {
        TempoAndTime tempoAndTime = new TempoAndTime(0);
        tempoAndTime.tempo = 120.0;
        tempoAndTime.tickInPfm = 0.0;
        tempoAndTime.timeInSec = 0.0;
        tempoAndTime.measure = -1;
        tempoAndTime.beat = 1;
        return tempoAndTime;
    }

    private ArrayList<TempoAndTime> alignBeats(SCCXMLWrapper.Note[] noteArray, SCCXMLWrapper.Note[] noteArray2, int[] nArray) {
        ArrayList<TempoAndTime> arrayList = new ArrayList<TempoAndTime>();
        arrayList.add(this.getZerothTempoAndTime());
        int n = 0;
        double d = Double.NEGATIVE_INFINITY;
        int n2 = 0;
        int n3 = 0;
        while (n3 < noteArray.length) {
            if (noteArray[n3].offset() > n2) {
                n2 = noteArray[n3].offset();
            }
            if (nArray[n3] == -1) {
                ++n3;
                continue;
            }
            if (PerformanceMatcher3.tickcmp(noteArray[n3].onset(), n, 5)) {
                int n4 = 0;
                int n5 = 0;
                int n6 = n3;
                while (true) {
                    block10: {
                        try {
                            if (!PerformanceMatcher3.tickcmp(noteArray[n6].onset(), n, 5)) break;
                            if (nArray[n6] == -1) break block10;
                            n5 += noteArray2[nArray[n6]].onset();
                            ++n4;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            break;
                        }
                    }
                    ++n6;
                }
                TempoAndTime tempoAndTime = new TempoAndTime(n);
                double d2 = (double)n5 / (double)n4;
                if (d2 > d) {
                    tempoAndTime.setTickInPfm(d2);
                    d = d2;
                }
                arrayList.add(tempoAndTime);
                n3 = n6;
                n += this.scoreTicksPerBeat;
                continue;
            }
            if (noteArray[n3].onset() > n) {
                arrayList.add(new TempoAndTime(n));
                ++n3;
                n += this.scoreTicksPerBeat;
                continue;
            }
            ++n3;
        }
        while (n <= n2) {
            arrayList.add(new TempoAndTime(n));
            n += this.scoreTicksPerBeat;
        }
        return arrayList;
    }

    private void interpolateBeatTime(ArrayList<TempoAndTime> arrayList) {
        TempoAndTime tempoAndTime = arrayList.get(1);
        if (Double.isNaN(tempoAndTime.tickInPfm)) {
            System.err.println("first note in MusicXML is not at t=0");
            tempoAndTime.setTickInPfm(0.0);
        }
        int n = arrayList.size();
        int n2 = 1;
        double d = tempoAndTime.tickInPfm;
        int n3 = -1;
        double d2 = 0.0;
        try {
            for (int i = 2; i < n - 1; ++i) {
                TempoAndTime tempoAndTime2 = arrayList.get(i);
                if (Double.isNaN(tempoAndTime2.tickInPfm)) {
                    if (i >= n3) {
                        n3 = i;
                        while (Double.isNaN(d2 = arrayList.get(n3).tickInPfm)) {
                            ++n3;
                        }
                    }
                    tempoAndTime2.setTickInPfm((d * (double)(n3 - i) + d2 * (double)(i - n2)) / (double)(n3 - n2));
                    continue;
                }
                n2 = i;
                d = tempoAndTime2.tickInPfm;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private static double calcTempo(ArrayList<TempoAndTime> arrayList) {
        int n = arrayList.size();
        double d = 0.0;
        double d2 = 0.0;
        int n2 = 0;
        TempoAndTime tempoAndTime = arrayList.get(1);
        for (int i = 2; i < n; ++i) {
            TempoAndTime tempoAndTime2 = arrayList.get(i);
            if (Double.isNaN(tempoAndTime2.timeInSec)) {
                tempoAndTime.tempo = d;
                tempoAndTime2.setTimeInSec(tempoAndTime.timeInSec + 60.0 / d);
            } else {
                tempoAndTime.tempo = 60.0 / (tempoAndTime2.timeInSec - tempoAndTime.timeInSec);
                d = tempoAndTime.tempo;
            }
            d2 += tempoAndTime.tempo;
            ++n2;
            tempoAndTime = tempoAndTime2;
        }
        arrayList.get(n - 1).tempo = d;
        return d2 / (double)n2;
    }

    private void setMeasureNumbers(MusicXMLWrapper.Measure[] measureArray, List<TempoAndTime> list) {
        int n = -1;
        int n2 = -1;
        Iterator<TempoAndTime> iterator = list.iterator();
        iterator.next();
        try {
            for (MusicXMLWrapper.Measure measure : measureArray) {
                int n3 = measure.cumulativeTicks(this.scoreTicksPerBeat);
                int n4 = measure.duration(1);
                for (int i = 1; i <= n4; ++i) {
                    TempoAndTime tempoAndTime = iterator.next();
                    System.err.println(i + ": " + tempoAndTime.tickInScore + " " + measure.duration(480) + " " + measure.number() + " " + measure.cumulativeTicks(this.scoreTicksPerBeat));
                    if (i == 1 && !PerformanceMatcher3.tickcmp(tempoAndTime.tickInScore, n3, 2)) {
                        System.err.println("*** tick-in-score mismatch***");
                    }
                    n = tempoAndTime.measure = measure.number();
                    n2 = tempoAndTime.beat = i;
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            while (iterator.hasNext()) {
                TempoAndTime tempoAndTime = iterator.next();
                tempoAndTime.measure = n;
                tempoAndTime.beat = ++n2;
            }
        }
    }

    private static void addTempoDeviations(DeviationDataSet deviationDataSet, ArrayList<TempoAndTime> arrayList, double d) {
        int n = arrayList.size();
        for (int i = 1; i < n - 1; ++i) {
            TempoAndTime tempoAndTime = arrayList.get(i);
            deviationDataSet.addNonPartwiseControl(tempoAndTime.measure, tempoAndTime.beat, "tempo-deviation", tempoAndTime.tempo / d);
        }
    }

    private class TempoAndTime {
        private double tempo = Double.NaN;
        private int tickInScore;
        private double tickInPfm = Double.NaN;
        private double timeInSec = Double.NaN;
        private int measure = -1;
        private int beat = -1;

        private TempoAndTime(int n) {
            this.tickInScore = n;
        }

        private void setTickInPfm(double d) {
            this.tickInPfm = d;
            this.timeInSec = d * 60.0 / (double)(PerformanceMatcher3.this.pfmTicksPerBeat * baseTempo);
        }

        private void setTimeInSec(double d) {
            this.timeInSec = d;
            this.tickInPfm = d * (double)PerformanceMatcher3.this.pfmTicksPerBeat * (double)baseTempo / 60.0;
        }

        private double beatLength() {
            return (double)(PerformanceMatcher3.this.pfmTicksPerBeat * baseTempo) / this.tempo;
        }
    }

    private static class DTWMatrix {
        private HashMap<IntPair, DTWMatrixElement> values;
        private int nrows;
        private int ncols;
        private final DTWMatrixElement DEFAULT_MATRIX_ELEMENT = new DTWMatrixElement(1.073741823E9, -1, -1);

        private DTWMatrix(int n, int n2) {
            this.nrows = n;
            this.ncols = n2;
            this.values = new HashMap(Math.max(n, n2));
        }

        private void set(int n, int n2, double d, int n3, int n4) {
            this.values.put(new IntPair(n, n2), new DTWMatrixElement(d, n3, n4));
        }

        private DTWMatrixElement get(int n, int n2) {
            if (n >= this.nrows || n2 >= this.ncols || n < -1 || n2 < -1) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (this.values.containsKey(new IntPair(n, n2))) {
                return this.values.get(new IntPair(n, n2));
            }
            return this.DEFAULT_MATRIX_ELEMENT;
        }

        private double getValue(int n, int n2) {
            return this.get(n, n2).value;
        }

        private class DTWMatrixElement {
            private int targetX;
            private int targetY;
            private double value;

            private DTWMatrixElement(double d, int n, int n2) {
                this.value = d;
                this.targetX = n;
                this.targetY = n2;
            }
        }

        private class IntPair {
            private int i;
            private int j;

            private IntPair(int n, int n2) {
                this.i = n;
                this.j = n2;
            }

            public boolean equals(Object object) {
                IntPair intPair = (IntPair)object;
                return this.i == intPair.i && this.j == intPair.j;
            }

            public int hashCode() {
                return this.i * DTWMatrix.this.nrows + this.j;
            }
        }
    }
}

