/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.filewrappers;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.filewrappers.NodeInterface;
import jp.crestmuse.cmx.math.DoubleArray;
import jp.crestmuse.cmx.math.DoubleArrayFactory;
import jp.crestmuse.cmx.math.DoubleMatrix;
import jp.crestmuse.cmx.math.DoubleMatrixFactory;
import jp.crestmuse.cmx.math.Utils;
import jp.crestmuse.cmx.misc.QueueReader;
import jp.crestmuse.cmx.misc.QueueWrapper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MPEG7Wrapper
extends CMXFileWrapper {
    private static final DoubleArrayFactory factory = DoubleArrayFactory.getFactory();
    private static final DoubleMatrixFactory mfactory = DoubleMatrixFactory.getFactory();
    private static final String MPEG7_NAMESPACE_URI = "urn:mpeg:mpeg7:schema:2001";
    private static final String XSI_NAMESPACE_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private Description[] dlist = null;
    private static final Pattern HOP_SIZE_PATTERN = Pattern.compile("PT(\\d+)N(\\d+)F");

    private static String getNodeType(Node node) {
        return ((Element)node).getAttributeNS(XSI_NAMESPACE_URI, "type");
    }

    public Description[] getDescriptionList() {
        if (this.dlist == null) {
            this.setNamespaceContext();
            NodeList nodeList = this.selectNodeList("/mpeg7:Mpeg7/mpeg7:Description");
            int n = nodeList.getLength();
            this.dlist = new Description[n];
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                String string = MPEG7Wrapper.getNodeType(node);
                this.dlist[i] = string.equals("ContentEntityType") ? new ContentEntity(node) : (string.equals("ModelDescriptionType") ? new ModelDescription(node) : new Description(node));
            }
        }
        return this.dlist;
    }

    public class GaussianDistribution
    extends ContinuousDistribution {
        private GaussianDistribution(Node node) {
            super(node);
        }

        DoubleArray mean() {
            return Utils.parseArray(this.getChildText("Mean"));
        }

        DoubleMatrix covarianceInverse() {
            return Utils.parseMatrix(this.getChildText("CovarianceInverse"));
        }
    }

    public class ContinuousDistribution
    extends Model {
        private ContinuousDistribution(Node node) {
            super(node);
        }

        protected String getSupportedNodeName() {
            return "ObservationDistribution";
        }
    }

    public class State
    extends Model {
        private State(Node node) {
            super(node);
        }

        protected String getSupportedNodeName() {
            return "State";
        }
    }

    public class SoundModel
    extends Model {
        private State[] states;
        private ContinuousDistribution[] dists;

        private SoundModel(Node node) {
            super(node);
            this.states = null;
            this.dists = null;
        }

        public DoubleArray initial() {
            return Utils.parseArray(this.getChildText("Initial"));
        }

        public DoubleMatrix transitions() {
            return Utils.parseMatrix(this.getChildText("Transitions"));
        }

        public State[] getStateList() {
            if (this.states == null) {
                NodeList nodeList = MPEG7Wrapper.this.selectNodeList(this.node(), "mpeg7:State");
                int n = nodeList.getLength();
                this.states = new State[n];
                for (int i = 0; i < n; ++i) {
                    this.states[i] = new State(nodeList.item(i));
                }
            }
            return this.states;
        }

        public ContinuousDistribution[] getObservationDistributionList() {
            if (this.dists == null) {
                NodeList nodeList = MPEG7Wrapper.this.selectNodeList(this.node(), "mpeg7:ObservationDistribution");
                int n = nodeList.getLength();
                this.dists = new ContinuousDistribution[n];
                for (int i = 0; i < n; ++i) {
                    Node node = nodeList.item(i);
                    String string = MPEG7Wrapper.getNodeType(node);
                    this.dists[i] = string.equals("GaussianDistributionType") ? new GaussianDistribution(node) : new ContinuousDistribution(node);
                }
            }
            return this.dists;
        }

        public String soundClassLabel() {
            return SoundModel.getText(MPEG7Wrapper.this.selectSingleNode(this.node(), "mpeg7:SoundClassLabel/mpeg7:Name"));
        }
    }

    public class Model
    extends MPEG7NodeInterface {
        private Model(Node node) {
            super(node);
        }

        protected String getSupportedNodeName() {
            return "Model";
        }
    }

    public class ModelDescription
    extends Description {
        Model[] modellist;

        private ModelDescription(Node node) {
            super(node);
            this.modellist = null;
        }

        public Model[] getModelList() {
            if (this.modellist == null) {
                NodeList nodeList = MPEG7Wrapper.this.selectNodeList(this.node(), "mpeg7:Model");
                int n = nodeList.getLength();
                this.modellist = new Model[n];
                for (int i = 0; i < n; ++i) {
                    Node node = nodeList.item(i);
                    String string = MPEG7Wrapper.getNodeType(node);
                    this.modellist[i] = string.equals("SoundModelType") ? new SoundModel(nodeList.item(i)) : new Model(nodeList.item(i));
                }
            }
            return this.modellist;
        }
    }

    private class MyVectorTimeSeries
    extends MyTimeSeries {
        private MyVectorTimeSeries(String string, int n, int n2, int n3, MPEG7NodeInterface mPEG7NodeInterface) {
            super(string, n, n2, n3, mPEG7NodeInterface);
            String[] stringArray = string.split("\n");
            if (stringArray.length != n2) {
                throw new IllegalStateException("inconsistent data size");
            }
            for (int i = 0; i < this.nFrames; ++i) {
                DoubleArray doubleArray = Utils.parseArray(stringArray[i], " ");
                if (doubleArray.length() != n) {
                    throw new IllegalStateException("inconsistent data size");
                }
                this.queue.add(doubleArray);
            }
        }
    }

    private class MyScalarTimeSeries
    extends MyTimeSeries {
        private MyScalarTimeSeries(String string, int n, int n2, MPEG7NodeInterface mPEG7NodeInterface) {
            super(string, 1, n, n2, mPEG7NodeInterface);
            String[] stringArray = string.trim().split(" ");
            if (stringArray.length != n) {
                throw new IllegalStateException("inconsistent data size");
            }
            for (int i = 0; i < this.nFrames; ++i) {
                DoubleArray doubleArray = factory.createArray(this.dim);
                doubleArray.set(0, Double.parseDouble(stringArray[i]));
                this.queue.add(doubleArray);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class MyTimeSeries
    implements TimeSeriesCompatible<DoubleArray> {
        int dim;
        int nFrames;
        private int timeunit;
        Queue<DoubleArray> queue;
        private MPEG7NodeInterface parent;
        private QueueWrapper<DoubleArray> qwrap;

        private MyTimeSeries(String string, int n, int n2, int n3, MPEG7NodeInterface mPEG7NodeInterface) {
            this.dim = n;
            this.nFrames = n2;
            this.timeunit = n3;
            this.queue = new LinkedList<DoubleArray>();
            this.qwrap = new QueueWrapper<DoubleArray>(this.queue, this.nFrames);
            this.parent = mPEG7NodeInterface;
        }

        @Override
        public QueueReader<DoubleArray> getQueueReader() {
            return this.qwrap.createReader();
        }

        @Override
        public int dim() {
            return this.dim;
        }

        @Override
        public int frames() {
            return this.nFrames;
        }

        @Override
        public int timeunit() {
            return this.timeunit;
        }

        @Override
        public int bytesize() {
            return 4 * this.dim();
        }

        @Override
        public void add(DoubleArray doubleArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAttribute(String string, String string2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAttribute(String string, int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAttribute(String string, double d) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAttribute(String string) {
            return this.parent.getAttribute(string);
        }

        @Override
        public int getAttributeInt(String string) {
            return this.parent.getAttributeInt(string);
        }

        @Override
        public double getAttributeDouble(String string) {
            return this.parent.getAttributeDouble(string);
        }

        @Override
        public Iterator<Map.Entry<String, String>> getAttributeIterator() {
            throw new UnsupportedOperationException();
        }
    }

    public class SeriesOfScalar
    extends ScalableSeries {
        private SeriesOfScalar(Node node, MPEG7NodeInterface mPEG7NodeInterface) {
            super(node, mPEG7NodeInterface);
        }

        protected String getSupportedNodeName() {
            return "SeriesOfScalar";
        }

        public TimeSeriesCompatible getTimeSeries(String string) {
            String string2 = SeriesOfScalar.getText(this.getChildByTagNameNS(string, MPEG7Wrapper.MPEG7_NAMESPACE_URI));
            return new MyScalarTimeSeries(string2, this.totalNumOfSamples(), this.timeunitMS(), this.parent);
        }

        public TimeSeriesCompatible[] getTimeSeriesList() {
            NodeList nodeList = this.getChildNodes();
            int n = nodeList.getLength();
            TimeSeriesCompatible[] timeSeriesCompatibleArray = new TimeSeriesCompatible[n];
            for (int i = 0; i < n; ++i) {
                timeSeriesCompatibleArray[i] = new MyScalarTimeSeries(SeriesOfScalar.getText(nodeList.item(i)), this.totalNumOfSamples(), this.timeunitMS(), this.parent);
            }
            return timeSeriesCompatibleArray;
        }
    }

    public abstract class ScalableSeries
    extends MPEG7NodeInterface {
        private int timeunitMS;
        MPEG7NodeInterface parent;

        private ScalableSeries(Node node, MPEG7NodeInterface mPEG7NodeInterface) {
            super(node);
            this.timeunitMS = -1;
            this.parent = mPEG7NodeInterface;
        }

        public int totalNumOfSamples() {
            return this.getAttributeInt("totalNumOfSamples");
        }

        public String hopSize() {
            return this.getAttribute("hopSize");
        }

        public int timeunitMS() {
            if (this.timeunitMS == -1) {
                Matcher matcher = HOP_SIZE_PATTERN.matcher(this.hopSize());
                if (matcher.matches()) {
                    this.timeunitMS = 1000 * Integer.parseInt(matcher.group(1)) / Integer.parseInt(matcher.group(2));
                } else {
                    throw new IllegalStateException("hopSize error");
                }
            }
            return this.timeunitMS;
        }

        public abstract TimeSeriesCompatible getTimeSeries(String var1);

        public abstract TimeSeriesCompatible[] getTimeSeriesList();
    }

    public class SeriesOfVector
    extends ScalableSeries {
        private SeriesOfVector(Node node, MPEG7NodeInterface mPEG7NodeInterface) {
            super(node, mPEG7NodeInterface);
        }

        protected String getSupportedNodeName() {
            return "SeriesOfVector";
        }

        public int vectorSize() {
            return this.getAttributeInt("vectorSize");
        }

        public TimeSeriesCompatible getTimeSeries(String string) {
            String string2 = SeriesOfVector.getText(this.getChildByTagName(string));
            int n = this.vectorSize();
            int n2 = this.totalNumOfSamples() / n;
            return new MyVectorTimeSeries(string2, n, n2, this.timeunitMS(), this.parent);
        }

        public TimeSeriesCompatible[] getTimeSeriesList() {
            NodeList nodeList = this.getChildNodes();
            int n = nodeList.getLength();
            TimeSeriesCompatible[] timeSeriesCompatibleArray = new TimeSeriesCompatible[n];
            for (int i = 0; i < n; ++i) {
                String string = SeriesOfVector.getText(nodeList.item(i));
                int n2 = this.vectorSize();
                int n3 = this.totalNumOfSamples() / n2;
                timeSeriesCompatibleArray[i] = new MyVectorTimeSeries(string, n2, n3, this.timeunitMS(), this.parent);
            }
            return timeSeriesCompatibleArray;
        }
    }

    public class AudioLLD
    extends AudioD {
        private ScalableSeries series;

        private AudioLLD(Node node) {
            super(node);
            this.series = null;
        }

        public double scalar() throws NullPointerException {
            return this.getChildTextDouble("Scalar");
        }

        public ScalableSeries series() {
            if (this.series == null) {
                Node node = this.getFirstChild();
                String string = node.getNodeName();
                if (string.equals("SeriesOfScalar")) {
                    this.series = new SeriesOfScalar(node, this);
                } else if (string.equals("SeriesOfVector")) {
                    this.series = new SeriesOfVector(node, this);
                }
            }
            return this.series;
        }
    }

    public class AudioSignalQuality
    extends AudioD {
        private AudioSignalQuality(Node node) {
            super(node);
        }
    }

    public class AudioHarmonicity
    extends AudioD {
        private AudioLLD harmonicRatio;
        private AudioLLD upperLimitOfHarmonicity;

        private AudioHarmonicity(Node node) {
            super(node);
            this.harmonicRatio = new AudioLLD(MPEG7Wrapper.this.selectSingleNode(this.node(), "mpeg7:HarmonicRatio")){

                protected String getSupportedNodeName() {
                    return "HarmonicRatio";
                }
            };
            this.upperLimitOfHarmonicity = new AudioLLD(MPEG7Wrapper.this.selectSingleNode(this.node(), "mpeg7:UpperLimitOfHarmonicity")){

                protected String getSupportedNodeName() {
                    return "UpperLimitOfHarmonicity";
                }
            };
        }

        public AudioLLD harmonicRatio() {
            return this.harmonicRatio;
        }

        public AudioLLD upperLimitOfHarmonicity() {
            return this.upperLimitOfHarmonicity;
        }
    }

    public abstract class AudioD
    extends MPEG7NodeInterface {
        private AudioD(Node node) {
            super(node);
        }

        protected String getSupportedNodeName() {
            return "AudioDescriptor";
        }
    }

    public class AudioSignature
    extends AudioDS {
        private AudioLLD flatness;

        private AudioSignature(Node node) {
            super(node);
            this.flatness = new AudioLLD(MPEG7Wrapper.this.selectSingleNode(this.node(), "mpeg7:Flatness")){

                protected String getSupportedNodeName() {
                    return "Flatness";
                }
            };
        }
    }

    public class InstrumentTimbre
    extends AudioDS {
        private AudioLLD[] lldlist;

        private InstrumentTimbre(Node node) {
            super(node);
            this.lldlist = null;
        }

        public AudioLLD[] getAudioLLDList() {
            if (this.lldlist == null) {
                NodeList nodeList = this.getChildNodes();
                int n = nodeList.getLength();
                this.lldlist = new AudioLLD[n];
                for (int i = 0; i < n; ++i) {
                    Node node = nodeList.item(i);
                    final String string = node.getNodeName();
                    this.lldlist[i] = new AudioLLD(node){

                        protected String getSupportedNodeName() {
                            return string;
                        }
                    };
                }
            }
            return this.lldlist;
        }
    }

    public class AudioDS
    extends MPEG7NodeInterface {
        private AudioDS(Node node) {
            super(node);
        }

        protected String getSupportedNodeName() {
            return "AudioDescriptionScheme";
        }
    }

    public class Audio
    extends MPEG7NodeInterface {
        AudioD[] audioD;
        AudioDS[] audioDS;

        private Audio(Node node) {
            super(node);
            this.audioD = null;
            this.audioDS = null;
        }

        protected String getSupportedNodeName() {
            return "Audio";
        }

        public AudioD[] getAudioDList() {
            if (this.audioD == null) {
                NodeList nodeList = MPEG7Wrapper.this.selectNodeList(this.node(), "mpeg7:AudioDescriptor");
                int n = nodeList.getLength();
                this.audioD = new AudioD[n];
                for (int i = 0; i < n; ++i) {
                    Node node = nodeList.item(i);
                    String string = MPEG7Wrapper.getNodeType(node);
                    this.audioD[i] = string.equals("AudioHarmonicityType") ? new AudioHarmonicity(node) : (string.equals("AudioSignalQuality") ? new AudioSignalQuality(node) : new AudioLLD(node));
                }
            }
            return this.audioD;
        }

        public AudioDS[] getAudioDSList() {
            if (this.audioDS == null) {
                NodeList nodeList = MPEG7Wrapper.this.selectNodeList(this.node(), "mpeg7:AudioDescriptionScheme");
                int n = nodeList.getLength();
                this.audioDS = new AudioDS[n];
                for (int i = 0; i < n; ++i) {
                    Node node = nodeList.item(i);
                    String string = MPEG7Wrapper.getNodeType(node);
                    this.audioDS[i] = string.contains("Timbre") ? new InstrumentTimbre(node) : (string.contains("AudioSignature") ? new AudioSignature(node) : new AudioDS(node));
                }
            }
            return this.audioDS;
        }
    }

    public class MultimediaContent
    extends MPEG7NodeInterface {
        private Audio audio;

        private MultimediaContent(Node node) {
            super(node);
            this.audio = null;
        }

        protected String getSupportedNodeName() {
            return "MultimediaContent";
        }

        public Audio getAudio() {
            if (this.audio == null) {
                this.audio = new Audio(MPEG7Wrapper.this.selectSingleNode(this.node(), "mpeg7:Audio"));
            }
            return this.audio;
        }
    }

    public class ContentEntity
    extends Description {
        private MultimediaContent[] contentlist;

        private ContentEntity(Node node) {
            super(node);
            this.contentlist = null;
        }

        public MultimediaContent[] getMultimediaContentList() {
            if (this.contentlist == null) {
                NodeList nodeList = MPEG7Wrapper.this.selectNodeList(this.node(), "mpeg7:MultimediaContent");
                int n = nodeList.getLength();
                this.contentlist = new MultimediaContent[n];
                for (int i = 0; i < n; ++i) {
                    this.contentlist[i] = new MultimediaContent(nodeList.item(i));
                }
            }
            return this.contentlist;
        }
    }

    public class Description
    extends MPEG7NodeInterface {
        private Description(Node node) {
            super(node);
        }

        protected String getSupportedNodeName() {
            return "Description";
        }
    }

    private abstract class MPEG7NodeInterface
    extends NodeInterface {
        private MPEG7NodeInterface(Node node) {
            super(node);
        }

        public String type() {
            return this.getAttributeNS("type", MPEG7Wrapper.XSI_NAMESPACE_URI);
        }
    }
}

