/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.filewrappers;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import jp.crestmuse.cmx.amusaj.filewrappers.AttrIterator;
import jp.crestmuse.cmx.amusaj.filewrappers.Base64;
import jp.crestmuse.cmx.amusaj.filewrappers.PeakSet;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.filewrappers.NodeInterface;
import jp.crestmuse.cmx.math.DoubleArrayFactory;
import jp.crestmuse.cmx.misc.QueueReader;
import jp.crestmuse.cmx.misc.QueueWrapper;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Peaks
extends NodeInterface
implements TimeSeriesCompatible<PeakSet> {
    private int nFrames;
    private int timeunit;
    private int bytesize;
    private Queue<PeakSet> queue;
    private QueueWrapper qwrap;
    private DoubleArrayFactory factory = DoubleArrayFactory.getFactory();

    Peaks(Node node) {
        super(node);
        this.nFrames = this.getAttributeInt("frames");
        this.timeunit = this.getAttributeInt("timeunit");
        ByteBuffer byteBuffer = ByteBuffer.wrap(Base64.decode(this.getText()));
        this.queue = new LinkedList<PeakSet>();
        this.bytesize = 0;
        for (int i = 0; i < this.nFrames; ++i) {
            int n = byteBuffer.getInt();
            PeakSet peakSet = new PeakSet(n);
            this.bytesize += 4 + 4 * n;
            for (int j = 0; j < n; ++j) {
                peakSet.setPeak(j, byteBuffer.getFloat(), byteBuffer.getFloat(), byteBuffer.getFloat(), byteBuffer.getFloat(), byteBuffer.getFloat());
            }
            this.queue.add(peakSet);
        }
        this.qwrap = new QueueWrapper<PeakSet>(this.queue, this.nFrames);
    }

    @Override
    protected String getSupportedNodeName() {
        return "peaks";
    }

    @Override
    public QueueReader<PeakSet> getQueueReader() {
        return this.qwrap.createReader();
    }

    @Override
    public int frames() {
        return this.nFrames;
    }

    @Override
    public int bytesize() {
        return this.bytesize;
    }

    @Override
    public int timeunit() {
        return this.timeunit;
    }

    @Override
    public int dim() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(PeakSet peakSet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAttribute(String string, String string2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAttribute(String string, int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAttribute(String string, double d) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Map.Entry<String, String>> getAttributeIterator() {
        return new AttrIterator(this.node().getAttributes());
    }

    public static void addPeaksToWrapper(TimeSeriesCompatible<PeakSet> timeSeriesCompatible, String string, CMXFileWrapper cMXFileWrapper) {
        Object object;
        ByteBuffer byteBuffer = ByteBuffer.allocate(timeSeriesCompatible.bytesize());
        QueueReader<PeakSet> queueReader = timeSeriesCompatible.getQueueReader();
        int n = timeSeriesCompatible.frames();
        try {
            for (int i = 0; i < n; ++i) {
                object = queueReader.take();
                int n2 = ((PeakSet)object).nPeaks();
                byteBuffer.putInt(n2);
                for (int j = 0; j < n2; ++j) {
                    byteBuffer.putFloat((float)((PeakSet)object).freq(j));
                    byteBuffer.putFloat((float)((PeakSet)object).power(j));
                    byteBuffer.putFloat((float)((PeakSet)object).phase(j));
                    byteBuffer.putFloat((float)((PeakSet)object).iid(j));
                    byteBuffer.putFloat((float)((PeakSet)object).ipd(j));
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        cMXFileWrapper.addChild(string);
        Iterator<Map.Entry<String, String>> iterator = timeSeriesCompatible.getAttributeIterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            cMXFileWrapper.setAttribute((String)object.getKey(), (String)object.getValue());
        }
        cMXFileWrapper.setAttribute("bytesize", timeSeriesCompatible.bytesize());
        cMXFileWrapper.setAttribute("frames", timeSeriesCompatible.frames());
        cMXFileWrapper.setAttribute("timeunit", timeSeriesCompatible.timeunit());
        cMXFileWrapper.addText(Base64.encode(byteBuffer.array()));
        cMXFileWrapper.returnToParent();
    }
}

