/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.filewrappers;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import jp.crestmuse.cmx.amusaj.filewrappers.AttrIterator;
import jp.crestmuse.cmx.amusaj.filewrappers.Base64;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.filewrappers.NodeInterface;
import jp.crestmuse.cmx.math.DoubleArray;
import jp.crestmuse.cmx.math.DoubleArrayFactory;
import jp.crestmuse.cmx.misc.QueueReader;
import jp.crestmuse.cmx.misc.QueueWrapper;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TimeSeriesNodeInterface
extends NodeInterface
implements TimeSeriesCompatible<DoubleArray> {
    private int dim = this.getAttributeInt("dim");
    private int nFrames = this.getAttributeInt("frames");
    private int timeunit;
    private Queue<DoubleArray> queue;
    private QueueWrapper<DoubleArray> qwrap;
    private static final DoubleArrayFactory factory = DoubleArrayFactory.getFactory();

    protected TimeSeriesNodeInterface(Node node) {
        super(node);
        if (this.hasAttribute("timeunit")) {
            this.timeunit = this.getAttributeInt("timeunit");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(Base64.decode(this.getText()));
        this.queue = new LinkedList<DoubleArray>();
        this.qwrap = new QueueWrapper<DoubleArray>(this.queue, this.nFrames);
        for (int i = 0; i < this.nFrames; ++i) {
            DoubleArray doubleArray = factory.createArray(this.dim);
            for (int j = 0; j < this.dim; ++j) {
                doubleArray.set(j, byteBuffer.getFloat());
            }
            this.queue.add(doubleArray);
        }
    }

    @Override
    public QueueReader<DoubleArray> getQueueReader() {
        return this.qwrap.createReader();
    }

    @Override
    public int dim() {
        return this.dim;
    }

    @Override
    public int frames() {
        return this.nFrames;
    }

    @Override
    public int timeunit() {
        return this.timeunit;
    }

    @Override
    public int bytesize() {
        return 4 * this.dim;
    }

    @Override
    public void add(DoubleArray doubleArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAttribute(String string, String string2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAttribute(String string, int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAttribute(String string, double d) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Map.Entry<String, String>> getAttributeIterator() {
        return new AttrIterator(this.node().getAttributes());
    }

    public static void addTimeSeriesToWrapper(TimeSeriesCompatible timeSeriesCompatible, String string, CMXFileWrapper cMXFileWrapper) {
        Object object;
        int n = timeSeriesCompatible.dim();
        int n2 = timeSeriesCompatible.frames();
        QueueReader queueReader = timeSeriesCompatible.getQueueReader();
        ByteBuffer byteBuffer = ByteBuffer.allocate(n * n2 * 4);
        try {
            for (int i = 0; i < n2; ++i) {
                object = (DoubleArray)queueReader.take();
                for (int j = 0; j < n; ++j) {
                    byteBuffer.putFloat((float)object.get(j));
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String string2 = Base64.encode(byteBuffer.array());
        cMXFileWrapper.addChild(string);
        object = timeSeriesCompatible.getAttributeIterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            cMXFileWrapper.setAttribute((String)entry.getKey(), (String)entry.getValue());
        }
        cMXFileWrapper.setAttribute("dim", n);
        cMXFileWrapper.setAttribute("frames", n2);
        cMXFileWrapper.setAttribute("timeunit", timeSeriesCompatible.timeunit());
        cMXFileWrapper.addText(string2);
        cMXFileWrapper.returnToParent();
    }
}

