/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import java.util.List;
import java.util.Map;
import jp.crestmuse.cmx.amusaj.filewrappers.MutableDoubleArrayTimeSeries;
import jp.crestmuse.cmx.amusaj.filewrappers.PeakSet;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.sp.F0PDFCalculator;
import jp.crestmuse.cmx.amusaj.sp.F0PDFCalculatorFactory;
import jp.crestmuse.cmx.amusaj.sp.ProducerConsumerCompatible;
import jp.crestmuse.cmx.commands.CMXCommand;
import jp.crestmuse.cmx.filewrappers.ConfigXMLWrapper;
import jp.crestmuse.cmx.math.DoubleArray;
import jp.crestmuse.cmx.misc.QueueReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class F0PDFCalculatorModule
implements ProducerConsumerCompatible<PeakSet, DoubleArray> {
    private F0PDFCalculatorFactory factory = F0PDFCalculatorFactory.getFactory();
    private F0PDFCalculator f0calc;
    private Map<String, Object> params;
    private boolean paramSet = false;
    private double nnFrom;
    private double nnThru;
    private double step;

    @Override
    public void setParams(Map<String, Object> map) {
        this.params = map;
        this.paramSet = false;
    }

    private void setParams() {
        ConfigXMLWrapper configXMLWrapper = CMXCommand.getConfigXMLWrapper();
        if (this.params.containsKey("NOTENUMBER_FROM")) {
            this.nnFrom = (Double)this.params.get("NOTENUMBER_FROM");
        } else {
            this.nnFrom = configXMLWrapper.getParamDouble("param", "f0pdf", "NOTENUMBER_FROM");
            this.params.put("NOTENUMBER_FROM", this.nnFrom);
        }
        if (this.params.containsKey("NOTENUMBER_THRU")) {
            this.nnThru = (Double)this.params.get("NOTENUMBER_THRU");
        } else {
            this.nnThru = configXMLWrapper.getParamDouble("param", "f0pdf", "NOTENUMBER_THRU");
            this.params.put("NOTENUMBER_THRU", this.nnThru);
        }
        if (this.params.containsKey("STEP")) {
            this.step = (Double)this.params.get("STEP");
        } else {
            this.step = configXMLWrapper.getParamDouble("param", "f0pdf", "STEP");
            this.params.put("STEP", this.step);
        }
        this.f0calc = this.factory.createCalculator(this.nnFrom, this.nnThru, this.step);
    }

    @Override
    public void execute(List<QueueReader<PeakSet>> list, List<TimeSeriesCompatible<DoubleArray>> list2) throws InterruptedException {
        if (!this.paramSet) {
            this.setParams();
        }
        PeakSet peakSet = list.get(0).take();
        list2.get(0).add(this.f0calc.calcWeights(peakSet));
    }

    @Override
    public int getInputChannels() {
        return 1;
    }

    @Override
    public int getOutputChannels() {
        return 1;
    }

    @Override
    public TimeSeriesCompatible createOutputInstance(int n, int n2) {
        return new MutableDoubleArrayTimeSeries(n, n2);
    }
}

