/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.InputStream;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.filewrappers.DeviationInstanceWrapper;
import jp.crestmuse.cmx.filewrappers.InvalidFileTypeException;
import jp.crestmuse.cmx.filewrappers.MIDIXMLWrapper;
import jp.crestmuse.cmx.gui.PianoRollPanel;
import jp.crestmuse.cmx.gui.VelocityPanel;
import jp.crestmuse.cmx.gui.sound.MIDIController;
import jp.crestmuse.cmx.misc.PianoRollCompatible;

public class CMXMusicDataFrame
extends JFrame
implements ActionListener,
ChangeListener {
    private static final String WINDOW_TITLE = "CMXMusicData Viewer";
    private static final String CMD_OPEN = "open";
    private static final String CMD_EXIT = "exit";
    private static final String EMPTY_FILENAME = "";
    private static final String CMD_PLAY = "play";
    private static final String CMD_STOP = "stop";
    private int frameHeight = 340;
    int frameWidth = 780;
    private int ticksPerBeat;
    private String midiDeviceName;
    private PianoRollCompatible filewrapper = null;
    private InputStream instream = null;
    private String lastSelectedPath = ".";
    private String selectedFileName;
    private PianoRollPanel pianoroll;
    private VelocityPanel velocityPanel;
    private MIDIController synthe;
    private JButton startButton;
    private JButton stopButton;
    private JTextField widthText;
    private JSlider widthbar;
    private JSplitPane splitPane;
    private JTextField musicLengh;

    public static void notifyStopPlaying() {
        throw new UnsupportedOperationException();
    }

    public CMXMusicDataFrame(int n) {
        super(WINDOW_TITLE);
        this.ticksPerBeat = n;
        JFrame.setDefaultLookAndFeelDecorated(false);
        this.setDefaultCloseOperation(3);
        this.setLayout(new BorderLayout());
        this.setJMenuBar(this.createMenubar());
        this.add((Component)this.createNaviButton(), "North");
        this.pianoroll = new PianoRollPanel(320, 240);
        this.velocityPanel = new VelocityPanel(this.frameWidth);
        this.splitPane = new JSplitPane(0, this.pianoroll, this.velocityPanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerLocation(this.frameHeight);
        this.splitPane.setPreferredSize(new Dimension(this.frameWidth, this.frameHeight + 130));
        this.add((Component)this.splitPane, "Center");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CMD_OPEN)) {
            this.setFile(this.getInputFileFromDialog());
            this.startButton.setEnabled(true);
            this.repaint();
        } else if (string.equals(CMD_PLAY)) {
            try {
                this.instream = this.filewrapper.getMIDIInputStream();
                this.synthe.startPlaying(this.instream);
                this.startButton.setEnabled(false);
                this.stopButton.setEnabled(true);
            }
            catch (Exception exception) {
                this.showErrorMessage(exception);
            }
        } else if (string.equals(CMD_STOP)) {
            this.synthe.stopPlaying();
            this.startButton.setEnabled(true);
            this.stopButton.setEnabled(false);
        } else if (string.equals(CMD_EXIT)) {
            System.exit(1);
        }
    }

    public void setMIDIDeviceName(String string) {
        this.midiDeviceName = string;
        this.synthe = new MIDIController(string);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.widthbar) {
            this.widthText.setText(String.valueOf(this.widthbar.getValue()));
            Dimension dimension = new Dimension(this.frameWidth + this.widthbar.getValue() * 5, this.frameHeight);
            this.pianoroll.getPianoroll().setPreferredSize(dimension);
            this.pianoroll.revalidate();
            System.out.println(dimension);
        }
        this.repaint();
    }

    void setFile(String string) {
        if (string != null) {
            this.selectedFileName = string;
            this.readXMLFile(string);
            if (this.filewrapper != null) {
                try {
                    this.pianoroll.setMusicData(this.filewrapper, this.ticksPerBeat);
                    this.velocityPanel.setMusicData(this.filewrapper, this.ticksPerBeat, this.pianoroll);
                }
                catch (Exception exception) {
                    this.showErrorMessage(exception);
                }
            }
        }
    }

    private JButton createButton(JComponent jComponent, String string, String string2, boolean bl, ActionListener actionListener) {
        JButton jButton = new JButton(string);
        jButton.setVerticalTextPosition(0);
        jButton.setHorizontalTextPosition(10);
        jButton.setEnabled(bl);
        jButton.addActionListener(actionListener);
        jButton.setActionCommand(string2);
        jComponent.add(jButton);
        return jButton;
    }

    private JMenuBar createMenubar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic('F');
        this.createMenuItem(this, jMenu, "Open File...", CMD_OPEN, 79);
        jMenu.addSeparator();
        this.createMenuItem(this, jMenu, "Exit", CMD_EXIT, 81);
        jMenuBar.add(jMenu);
        return jMenuBar;
    }

    private void createMenuItem(ActionListener actionListener, JMenu jMenu, String string, String string2, int n) {
        this.createMenuItem(actionListener, jMenu, string, string2, n, 2);
    }

    private void createMenuItem(ActionListener actionListener, JMenu jMenu, String string, String string2, int n, int n2) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setMnemonic(n);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n, n2));
        jMenuItem.setActionCommand(string2);
        jMenuItem.addActionListener(actionListener);
        jMenu.add(jMenuItem);
    }

    private JPanel createNaviButton() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        this.startButton = this.createButton(jPanel, "Play", CMD_PLAY, false, this);
        this.stopButton = this.createButton(jPanel, "Stop", CMD_STOP, false, this);
        this.widthbar = new JSlider(0, 10, 100, 30);
        this.widthbar.addChangeListener(this);
        this.widthText = new JTextField(3);
        this.widthText.setText(String.valueOf(this.widthbar.getValue()));
        this.musicLengh = new JTextField(6);
        jPanel.add(this.startButton);
        jPanel.add(this.stopButton);
        jPanel.add(this.widthbar);
        jPanel.add(this.widthText);
        jPanel.add(new JLabel("music length:"));
        jPanel.add(this.musicLengh);
        return jPanel;
    }

    private String getInputFileFromDialog() {
        JFileChooser jFileChooser = new JFileChooser(this.lastSelectedPath);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        if (jFileChooser.showOpenDialog(this) != 0) {
            return EMPTY_FILENAME;
        }
        File file = jFileChooser.getSelectedFile();
        String string = file.getAbsolutePath();
        this.lastSelectedPath = file.getParent();
        return string;
    }

    private void readXMLFile(String string) {
        block5: {
            try {
                if (string.endsWith(".mid")) {
                    this.filewrapper = MIDIXMLWrapper.readSMF(string);
                    break block5;
                }
                CMXFileWrapper cMXFileWrapper = CMXFileWrapper.readfile(string);
                if (cMXFileWrapper instanceof PianoRollCompatible) {
                    this.filewrapper = (PianoRollCompatible)((Object)cMXFileWrapper);
                    break block5;
                }
                if (cMXFileWrapper instanceof DeviationInstanceWrapper) {
                    this.filewrapper = ((DeviationInstanceWrapper)cMXFileWrapper).toSCCXML(this.ticksPerBeat);
                    break block5;
                }
                throw new InvalidFileTypeException();
            }
            catch (Exception exception) {
                this.showErrorMessage(exception);
            }
        }
    }

    private void showErrorMessage(Exception exception) {
        exception.printStackTrace();
        JOptionPane.showMessageDialog(this, exception.toString());
    }
}

