/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.misc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.filewrappers.MusicXMLWrapper;
import jp.crestmuse.cmx.handlers.CommonNoteHandler;
import jp.crestmuse.cmx.misc.NoteCompatible;
import jp.crestmuse.cmx.misc.PianoRollCompatible;
import org.xml.sax.SAXException;

public class TimeFreqRepresentation {
    private List<TimeFreqElement> tflist;
    private int nbands;
    private static final int N_BANDS = 128;

    private TimeFreqRepresentation(int n) {
        this.nbands = n;
        this.tflist = new ArrayList<TimeFreqElement>();
    }

    private void add(double d, byte[] byArray, NoteCompatible[] noteCompatibleArray) {
        if (noteCompatibleArray.length != this.nbands) {
            throw new IllegalStateException();
        }
        this.tflist.add(new TimeFreqElement(d, byArray, noteCompatibleArray));
    }

    private void addTime(double d) {
        this.add(d, new byte[this.nbands], new NoteCompatible[this.nbands]);
    }

    public TimeFreqElement get(int n) {
        return this.tflist.get(n);
    }

    private void set(int n, int n2, byte by) {
        ((TimeFreqElement)this.tflist.get((int)n)).values[n2] = by;
    }

    private void set(int n, int n2, boolean bl) {
        this.set(n, n2, bl ? 127.0 : 0.0);
    }

    private void set(int n, int n2, double d) {
        this.set(n, n2, (byte)(d * 127.0));
    }

    private void set(int n, int n2, NoteCompatible noteCompatible) {
        ((TimeFreqElement)this.tflist.get((int)n)).data[n2] = noteCompatible;
    }

    private void changeTime(int n, double d) {
        this.tflist.get(n).t = d;
    }

    private void changeIsMeasureHead(int n, boolean bl) {
        this.tflist.get(n).isMeasureHead = bl;
    }

    public int length() {
        return this.tflist.size();
    }

    static int dist(TimeFreqElement timeFreqElement, TimeFreqElement timeFreqElement2) {
        return timeFreqElement.dist(timeFreqElement2);
    }

    public void println() {
        for (TimeFreqElement timeFreqElement : this.tflist) {
            System.out.println(timeFreqElement);
        }
    }

    public static TimeFreqRepresentation getTimeFreqRepresentation(PianoRollCompatible pianoRollCompatible, int n) throws TransformerException, IOException, ParserConfigurationException, SAXException {
        return TimeFreqRepresentation.getTimeFreqRepresentation(pianoRollCompatible, n, 4, null);
    }

    public static TimeFreqRepresentation getTimeFreqRepresentation(PianoRollCompatible pianoRollCompatible, final int n, final int n2, MusicXMLWrapper musicXMLWrapper) throws TransformerException, IOException, ParserConfigurationException, SAXException {
        final TimeFreqRepresentation timeFreqRepresentation = new TimeFreqRepresentation(128);
        pianoRollCompatible.processNotes(new CommonNoteHandler(){

            public void beginPart(String string, PianoRollCompatible pianoRollCompatible) {
            }

            public void endPart(String string, PianoRollCompatible pianoRollCompatible) {
            }

            public void processNote(NoteCompatible noteCompatible, PianoRollCompatible pianoRollCompatible) {
                byte by;
                int n5;
                int n22 = noteCompatible.onset(n) * n2 / 4 / n;
                int n3 = noteCompatible.offset(n) * n2 / 4 / n;
                int n4 = noteCompatible.notenum();
                if (n22 > n3) {
                    n22 += n3;
                    n3 = n22 - n3;
                    n22 -= n3;
                }
                while ((n5 = timeFreqRepresentation.length()) <= n3) {
                    timeFreqRepresentation.addTime(n5 * n * 4 / n2);
                }
                timeFreqRepresentation.set(n22, n4, noteCompatible);
                try {
                    by = (byte)noteCompatible.velocity();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    by = 127;
                }
                for (int i = n22; i <= n3; ++i) {
                    timeFreqRepresentation.set(i, n4, by);
                }
            }
        });
        if (musicXMLWrapper != null) {
            int n3 = 1;
            try {
                while (true) {
                    timeFreqRepresentation.changeIsMeasureHead(musicXMLWrapper.getCumulativeTicks(n3++, n) * n2 / 4 / n, true);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
        }
        return timeFreqRepresentation;
    }

    public class TimeFreqElement {
        private byte[] values;
        private NoteCompatible[] data;
        private double t;
        private boolean isMeasureHead;

        private TimeFreqElement(double d, byte[] byArray, NoteCompatible[] noteCompatibleArray) {
            this.values = byArray;
            this.data = noteCompatibleArray;
            this.t = d;
            this.isMeasureHead = false;
        }

        public byte[] values() {
            return this.values;
        }

        int dist(TimeFreqElement timeFreqElement) {
            if (this.values.length != timeFreqElement.values.length) {
                throw new IllegalStateException();
            }
            int n = 0;
            for (int i = 0; i < this.values.length; ++i) {
                int n2 = this.values[i] - timeFreqElement.values[i];
                n += n2 >= 0 ? n2 : -n2;
            }
            return n;
        }

        int distFromZero() {
            int n = 0;
            for (int i = 0; i < this.values.length; ++i) {
                n += this.values[i] > 0 ? this.values[i] : -this.values[i];
            }
            return n;
        }

        public double time() {
            return this.t;
        }

        public NoteCompatible[] data() {
            return this.data;
        }

        public boolean isMeasureHead() {
            return this.isMeasureHead;
        }

        public String toString() {
            String string = "";
            for (int i = 0; i < this.values.length; ++i) {
                string = string + " " + this.values[i];
            }
            return string;
        }
    }
}

