/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.filewrappers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.misc.QueueReader;
import jp.crestmuse.cmx.misc.QueueWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MutableData<D>
implements TimeSeriesCompatible<D> {
    private int nFrames;
    private int timeunit;
    BlockingQueue<D> queue;
    private QueueWrapper<D> qwrap;
    private Map<String, String> attr;

    MutableData(int n, int n2) {
        this.nFrames = n;
        this.timeunit = n2;
        this.queue = new LinkedBlockingQueue<D>();
        this.qwrap = new QueueWrapper<D>(this.queue, n);
        this.attr = new HashMap<String, String>();
    }

    @Override
    public QueueReader<D> getQueueReader() {
        return this.qwrap.createReader();
    }

    @Override
    public int frames() {
        return this.nFrames;
    }

    @Override
    public int timeunit() {
        return this.timeunit;
    }

    @Override
    public String getAttribute(String string) {
        return this.attr.get(string);
    }

    @Override
    public int getAttributeInt(String string) {
        return Integer.parseInt(this.getAttribute(string));
    }

    @Override
    public double getAttributeDouble(String string) {
        return Double.parseDouble(this.getAttribute(string));
    }

    @Override
    public void setAttribute(String string, String string2) {
        this.attr.put(string, string2);
    }

    @Override
    public void setAttribute(String string, int n) {
        this.attr.put(string, String.valueOf(n));
    }

    @Override
    public void setAttribute(String string, double d) {
        this.attr.put(string, String.valueOf(d));
    }

    @Override
    public Iterator<Map.Entry<String, String>> getAttributeIterator() {
        return this.attr.entrySet().iterator();
    }
}

