/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.filewrappers;

import jp.crestmuse.cmx.math.DoubleArray;
import jp.crestmuse.cmx.math.DoubleArrayFactory;

public class PeakSet {
    private int nPeaks;
    private DoubleArray freq;
    private DoubleArray power;
    private DoubleArray phase;
    private DoubleArray iid;
    private DoubleArray ipd;
    private static final DoubleArrayFactory factory = DoubleArrayFactory.getFactory();

    public PeakSet(int n) {
        this.nPeaks = n;
        this.freq = factory.createArray(n);
        this.power = factory.createArray(n);
        this.phase = factory.createArray(n);
        this.iid = factory.createArray(n);
        this.ipd = factory.createArray(n);
    }

    public PeakSet(DoubleArray doubleArray, DoubleArray doubleArray2, DoubleArray doubleArray3, DoubleArray doubleArray4, DoubleArray doubleArray5) {
        this.nPeaks = doubleArray.length();
        this.freq = doubleArray;
        this.power = doubleArray2;
        this.phase = doubleArray3;
        this.iid = doubleArray4;
        this.ipd = doubleArray5;
    }

    public void setPeak(int n, double d, double d2, double d3, double d4, double d5) {
        this.freq.set(n, d);
        this.power.set(n, d2);
        this.phase.set(n, d3);
        this.iid.set(n, d4);
        this.ipd.set(n, d5);
    }

    public int nPeaks() {
        return this.nPeaks;
    }

    public double freq(int n) {
        return this.freq.get(n);
    }

    public double power(int n) {
        return this.power.get(n);
    }

    public double phase(int n) {
        return this.phase.get(n);
    }

    public double iid(int n) {
        return this.iid.get(n);
    }

    public double ipd(int n) {
        return this.ipd.get(n);
    }

    public DoubleArray freq() {
        return this.freq;
    }

    public DoubleArray power() {
        return this.power;
    }

    public DoubleArray phase() {
        return this.phase;
    }

    public DoubleArray iid() {
        return this.iid;
    }

    public DoubleArray ipd() {
        return this.ipd;
    }

    public void filter(Filter filter) {
        if (filter != null && (filter.usesLCF || filter.usesHCF)) {
            for (int i = 0; i < this.nPeaks; ++i) {
                double d;
                double d2 = this.freq.get(i);
                if (filter.usesLCF) {
                    if (d2 < filter.LCFbtm) {
                        this.power.set(i, 0.0);
                    } else if (d2 < filter.LCFtop) {
                        d = (d2 - filter.LCFbtm) / (filter.LCFtop - filter.LCFbtm);
                        this.power.set(i, d * this.power.get(i));
                    }
                }
                if (!filter.usesHCF) continue;
                if (d2 > filter.HCFbtm) {
                    this.power.set(i, 0.0);
                    continue;
                }
                if (!(d2 > filter.HCFtop)) continue;
                d = (d2 - filter.HCFbtm) / (filter.HCFtop - filter.HCFbtm);
                this.power.set(i, d * this.power.get(i));
            }
        }
    }

    public class Filter {
        public boolean usesLCF;
        public boolean usesHCF;
        public double LCFbtm;
        public double LCFtop;
        public double HCFbtm;
        public double HCFtop;
    }
}

