/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.misc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.filewrappers.DeviationDataSet;
import jp.crestmuse.cmx.filewrappers.DeviationInstanceWrapper;
import jp.crestmuse.cmx.filewrappers.MIDIXMLWrapper;
import jp.crestmuse.cmx.filewrappers.MusicXMLWrapper;
import jp.crestmuse.cmx.filewrappers.SCCXMLWrapper;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformanceMatcher3 {
    private static int baseTempo = 120;
    private static final double BASE_DYNAMICS = 100.0;
    private MusicXMLWrapper musicxml;
    private MIDIXMLWrapper midixml;
    private String partid;
    private MusicXMLWrapper.Measure[] measurelist;
    private SCCXMLWrapper.Note[] scoreNotes;
    private SCCXMLWrapper.Note[] pfmNotes;
    private SCCXMLWrapper.Annotation[] barlines;
    private DeviationDataSet dds;
    private int scoreTicksPerBeat;
    private int pfmTicksPerBeat;
    private int i = 0;
    private int lastMeasureNumber = 0;

    public PerformanceMatcher3(MusicXMLWrapper musicXMLWrapper, MIDIXMLWrapper mIDIXMLWrapper) throws ParserConfigurationException, SAXException, IOException, TransformerException {
        this(musicXMLWrapper, mIDIXMLWrapper, mIDIXMLWrapper.ticksPerBeat());
    }

    public PerformanceMatcher3(MusicXMLWrapper musicXMLWrapper, MIDIXMLWrapper mIDIXMLWrapper, int n) throws ParserConfigurationException, SAXException, IOException, TransformerException {
        this.musicxml = musicXMLWrapper;
        this.midixml = mIDIXMLWrapper;
        MusicXMLWrapper.Part part = this.musicxml.getPartList()[0];
        this.measurelist = part.getMeasureList();
        this.partid = part.id();
        SCCXMLWrapper sCCXMLWrapper = musicXMLWrapper.makeDeadpanSCCXML(n);
        SCCXMLWrapper sCCXMLWrapper2 = mIDIXMLWrapper.toSCCXML();
        this.barlines = sCCXMLWrapper.getBarlineList();
        this.scoreNotes = sCCXMLWrapper.getPartList()[0].getSortedNoteOnlyList(1);
        this.pfmNotes = sCCXMLWrapper2.getPartList()[0].getSortedNoteOnlyList(100);
        this.scoreTicksPerBeat = sCCXMLWrapper.getDivision();
        this.pfmTicksPerBeat = sCCXMLWrapper2.getDivision();
        SCCXMLWrapper.HeaderElement[] headerElementArray = sCCXMLWrapper2.getHeaderElementList();
        if (headerElementArray.length >= 1 && headerElementArray[0].name().equals("TEMPO")) {
            baseTempo = Integer.parseInt(headerElementArray[0].content());
        }
    }

    public DeviationInstanceWrapper extractDeviation() throws ParserConfigurationException, SAXException, IOException, TransformerException {
        DeviationInstanceWrapper deviationInstanceWrapper = DeviationInstanceWrapper.createDeviationInstanceFor(this.musicxml);
        DeviationDataSet deviationDataSet = deviationInstanceWrapper.createDeviationDataSet();
        int[] nArray = PerformanceMatcher3.getPath(this.dtw(500));
        int[] nArray2 = new int[nArray.length];
        ArrayList<SCCXMLWrapper.Note> arrayList = new ArrayList<SCCXMLWrapper.Note>();
        this.alignNotes(nArray, nArray2, arrayList);
        ArrayList<TempoAndTime> arrayList2 = this.alignBeats(nArray2);
        this.interpolateBeatTime(arrayList2);
        double d = this.calcTempo(arrayList2);
        double d2 = arrayList2.get(1).timeInSec;
        deviationDataSet.setInitialSilence(d2);
        int n = this.measurelist[0].number();
        deviationDataSet.addNonPartwiseControl(n, 1.0, "tempo", d);
        PerformanceMatcher3.addTempoDeviations(deviationDataSet, arrayList2, d);
        this.setNotewiseDeviations(deviationDataSet, nArray2, arrayList, arrayList2);
        deviationDataSet.addElementsToWrapper();
        return deviationInstanceWrapper;
    }

    public static DeviationInstanceWrapper extractDeviation(MusicXMLWrapper musicXMLWrapper, MIDIXMLWrapper mIDIXMLWrapper) throws ParserConfigurationException, SAXException, IOException, TransformerException {
        PerformanceMatcher3 performanceMatcher3 = new PerformanceMatcher3(musicXMLWrapper, mIDIXMLWrapper);
        return performanceMatcher3.extractDeviation();
    }

    public static DeviationInstanceWrapper extractDeviation(MusicXMLWrapper musicXMLWrapper, MIDIXMLWrapper mIDIXMLWrapper, int n) throws ParserConfigurationException, SAXException, IOException, TransformerException {
        PerformanceMatcher3 performanceMatcher3 = new PerformanceMatcher3(musicXMLWrapper, mIDIXMLWrapper, n);
        return performanceMatcher3.extractDeviation();
    }

    private static int[] getPath(DTWMatrix dTWMatrix) {
        int n = dTWMatrix.nrows;
        int n2 = dTWMatrix.ncols;
        int[] nArray = new int[n];
        int n3 = n - 1;
        int n4 = n2 - 1;
        do {
            nArray[n3] = n4;
            DTWMatrix.DTWMatrixElement dTWMatrixElement = dTWMatrix.get(n3, n4);
            n3 = dTWMatrixElement.targetX;
            n4 = dTWMatrixElement.targetY;
        } while (n3 >= 0 || n4 >= 0);
        return nArray;
    }

    private DTWMatrix dtw(int n) {
        int n2 = this.scoreNotes.length;
        int n3 = this.pfmNotes.length;
        int n4 = this.scoreNotes[n2 - 1].offset();
        int n5 = this.pfmNotes[n3 - 1].offset();
        n = n3;
        DTWMatrix dTWMatrix = new DTWMatrix(n2, n3);
        dTWMatrix.set(-1, -1, 0.0, -1, -1);
        int n6 = 1;
        for (int i = 0; i < n2; ++i) {
            int n7 = 1;
            for (int j = Math.max(0, i - n); j <= Math.min(i + n, n3 - 1); ++j) {
                double d;
                SCCXMLWrapper.Note note = this.scoreNotes[i];
                SCCXMLWrapper.Note note2 = this.pfmNotes[j];
                double d2 = PerformanceMatcher3.dist(note, note2, n4, n5);
                double d3 = dTWMatrix.getValue(i - 1, j) + d2 + (double)n6;
                double d4 = dTWMatrix.getValue(i - 1, j - 1) + 2.0 * d2;
                double d5 = Math.min(d4, Math.min(d3, d = dTWMatrix.getValue(i, j - 1) + d2 + (double)n7));
                if (d5 == d4) {
                    dTWMatrix.set(i, j, d5, i - 1, j - 1);
                    n6 = 1;
                    n7 = 1;
                    continue;
                }
                if (d5 == d) {
                    dTWMatrix.set(i, j, d5, i, j - 1);
                    ++n7;
                    continue;
                }
                dTWMatrix.set(i, j, d5, i - 1, j);
                ++n6;
            }
        }
        return dTWMatrix;
    }

    private static double dist(SCCXMLWrapper.Note note, SCCXMLWrapper.Note note2, int n, int n2) {
        int n3 = Math.abs(note.notenum() - note2.notenum());
        double d = Math.abs((double)note.onset() / (double)n - (double)note2.onset() / (double)n2);
        if (n3 == 0) {
            return d;
        }
        if (Math.abs(note.notenum() - note2.notenum()) % 12 == 0) {
            return 10.0 + d;
        }
        return 100.0;
    }

    private void alignNotes(int[] nArray, int[] nArray2, List<SCCXMLWrapper.Note> list) {
        int n;
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = -1;
        }
        boolean[] blArray = new boolean[this.pfmNotes.length];
        for (n = 0; n < blArray.length; ++n) {
            blArray[n] = false;
        }
        n = 0;
        int n2 = 0;
        while (n < nArray2.length - 1) {
            if (nArray2[n] == -1 && !blArray[n2] && this.scoreNotes[n].notenum() == this.pfmNotes[n2].notenum()) {
                nArray2[n] = n2;
                blArray[n2] = true;
                if (nArray[n + 1] == n2) {
                    ++n;
                    continue;
                }
                if (nArray[n + 1] - n2 > 1) {
                    ++n2;
                    continue;
                }
                ++n;
                ++n2;
                continue;
            }
            if (nArray[n + 1] == n2) {
                ++n;
                continue;
            }
            if (nArray[n + 1] - n2 > 1) {
                if (!blArray[n2]) {
                    list.add(this.pfmNotes[n2]);
                    blArray[n2] = true;
                }
                ++n2;
                continue;
            }
            if (!blArray[n2]) {
                list.add(this.pfmNotes[n2]);
                blArray[n2] = true;
            }
            ++n;
            ++n2;
        }
        if (nArray2[n] == -1 && !blArray[n2] && this.scoreNotes[n].notenum() == this.pfmNotes[n2].notenum()) {
            nArray2[n] = n2;
        } else {
            list.add(this.pfmNotes[n2]);
        }
    }

    private void setNotewiseDeviations(DeviationDataSet deviationDataSet, int[] nArray, List<SCCXMLWrapper.Note> list, ArrayList<TempoAndTime> arrayList) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= 0) {
                this.addNoteDeviation(deviationDataSet, this.scoreNotes[i], this.pfmNotes[nArray[i]], arrayList);
                continue;
            }
            PerformanceMatcher3.addMissNote(deviationDataSet, this.scoreNotes[i]);
        }
        for (SCCXMLWrapper.Note note : list) {
            this.addExtraNote(deviationDataSet, note, this.partid, arrayList);
        }
    }

    private TempoAndTime searchTnT(double d, ArrayList<TempoAndTime> arrayList) {
        int n = arrayList.size();
        while (this.i >= n - 1 || arrayList.get(this.i).tickInPfm > d && this.i > 0) {
            --this.i;
        }
        while (this.i < 0 || arrayList.get(this.i + 1).tickInPfm <= d && this.i < n - 2) {
            ++this.i;
        }
        return arrayList.get(this.i);
    }

    private void addNoteDeviation(DeviationDataSet deviationDataSet, SCCXMLWrapper.Note note, SCCXMLWrapper.Note note2, ArrayList<TempoAndTime> arrayList) {
        double d;
        double d2;
        double d3;
        double d4;
        int n = (int)arrayList.get(0).tickInPfm;
        TempoAndTime tempoAndTime = this.searchTnT(note2.onset(), arrayList);
        if (tempoAndTime.measure >= 0) {
            d4 = (double)note2.onset() - tempoAndTime.tickInPfm;
            d3 = note.onset() - tempoAndTime.tickInScore;
        } else {
            d4 = (double)note2.onset() - arrayList.get(1).tickInPfm;
            d3 = note.onset() - arrayList.get(1).tickInScore;
        }
        double d5 = d4 * tempoAndTime.tempo / (double)(this.pfmTicksPerBeat * baseTempo) - d3 / (double)this.scoreTicksPerBeat;
        tempoAndTime = this.searchTnT(note2.offset(), arrayList);
        if (tempoAndTime.measure >= 0) {
            d2 = (double)note2.offset() - tempoAndTime.tickInPfm;
            d = note.offset() - tempoAndTime.tickInScore;
        } else {
            d2 = (double)note2.offset() - arrayList.get(1).tickInPfm;
            d = note.offset() - arrayList.get(1).tickInScore;
        }
        double d6 = d2 * tempoAndTime.tempo / (double)(this.pfmTicksPerBeat * baseTempo) - d / (double)this.scoreTicksPerBeat;
        double d7 = (double)note2.velocity() / 100.0;
        deviationDataSet.addNoteDeviation(note.getMusicXMLWrapperNote(), d5, d6, d7, d7);
    }

    private static void addMissNote(DeviationDataSet deviationDataSet, SCCXMLWrapper.Note note) {
        deviationDataSet.addMissNote(note.getMusicXMLWrapperNote());
    }

    private void addExtraNote(DeviationDataSet deviationDataSet, SCCXMLWrapper.Note note, String string, ArrayList<TempoAndTime> arrayList) {
        TempoAndTime tempoAndTime;
        int n;
        TempoAndTime tempoAndTime2;
        int n2;
        int n3 = arrayList.size();
        for (n2 = 0; !(n2 >= n3 || (tempoAndTime2 = arrayList.get(n2)).measure == -1 && tempoAndTime2.beat == -1 || tempoAndTime2.tickInPfm > (double)note.onset()); ++n2) {
        }
        tempoAndTime2 = arrayList.get(n2 - 1);
        double d = ((double)note.onset() - tempoAndTime2.tickInPfm) / tempoAndTime2.beatLength();
        for (n = n2 - 1; !(n >= n3 || (tempoAndTime = arrayList.get(n)).measure == -1 && tempoAndTime.beat == -1 || tempoAndTime.tickInPfm > (double)note.offset()); ++n) {
        }
        tempoAndTime = arrayList.get(n - 1);
        double d2 = ((double)note.offset() - tempoAndTime.tickInPfm) / tempoAndTime.beatLength();
        deviationDataSet.addExtraNote(string, tempoAndTime2.measure, (double)tempoAndTime2.beat + d, note.notenum(), (double)(n - n2) + d2 - d, (double)note.velocity() / 100.0, (double)note.velocity() / 100.0);
    }

    private static boolean tickcmp(int n, int n2, int n3) {
        return n >= n2 - n3 && n <= n2 + n3;
    }

    private TempoAndTime getZerothTempoAndTime() {
        TempoAndTime tempoAndTime = new TempoAndTime(0);
        tempoAndTime.tempo = 120.0;
        tempoAndTime.tickInPfm = 0.0;
        tempoAndTime.timeInSec = 0.0;
        tempoAndTime.measure = -1;
        tempoAndTime.beat = 1;
        return tempoAndTime;
    }

    private ArrayList<TempoAndTime> alignBeats(int[] nArray) {
        int n;
        int n2;
        int n3;
        int n4;
        ArrayList<TempoAndTime> arrayList = new ArrayList<TempoAndTime>();
        arrayList.add(this.getZerothTempoAndTime());
        int n5 = 0;
        for (n4 = 0; n4 < this.barlines.length - 1; ++n4) {
            n3 = this.getMeasureNumber(this.barlines[n4].onset());
            n2 = 1;
            for (n = this.barlines[n4].onset(); n < this.barlines[n4 + 1].onset(); n += this.scoreTicksPerBeat) {
                n5 = this.addTempoAndTime(n, n3, n2, n5, nArray, arrayList);
                ++n2;
            }
        }
        n4 = this.barlines[this.barlines.length - 1].onset();
        n3 = this.getMeasureNumber(n4);
        n2 = 1;
        n = n4;
        for (n5 = this.addTempoAndTime(n4, n3, n2, n5, nArray, arrayList); n5 < this.scoreNotes.length; ++n5) {
            if (this.scoreNotes[n5].offset() <= n) continue;
            n = this.scoreNotes[n5].offset();
        }
        n4 += this.scoreTicksPerBeat;
        while (n4 <= n) {
            TempoAndTime tempoAndTime = new TempoAndTime(n4);
            tempoAndTime.measure = n3;
            tempoAndTime.beat = ++n2;
            arrayList.add(tempoAndTime);
            n4 += this.scoreTicksPerBeat;
        }
        return arrayList;
    }

    private int addTempoAndTime(int n, int n2, int n3, int n4, int[] nArray, ArrayList<TempoAndTime> arrayList) {
        while (n4 < this.scoreNotes.length) {
            if (nArray[n4] == -1) {
                ++n4;
                continue;
            }
            if (PerformanceMatcher3.tickcmp(this.scoreNotes[n4].onset(), n, 5)) {
                int n5 = 0;
                int n6 = 0;
                int n7 = n4;
                while (true) {
                    block8: {
                        try {
                            if (!PerformanceMatcher3.tickcmp(this.scoreNotes[n7].onset(), n, 5)) break;
                            if (nArray[n7] == -1) break block8;
                            n6 += this.pfmNotes[nArray[n7]].onset();
                            ++n5;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            break;
                        }
                    }
                    ++n7;
                }
                TempoAndTime tempoAndTime = new TempoAndTime(n);
                tempoAndTime.measure = n2;
                tempoAndTime.beat = n3;
                if (n5 > 0) {
                    tempoAndTime.setTickInPfm((double)n6 / (double)n5);
                }
                arrayList.add(tempoAndTime);
                return n7;
            }
            if (this.scoreNotes[n4].onset() > n) {
                TempoAndTime tempoAndTime = new TempoAndTime(n);
                tempoAndTime.measure = n2;
                tempoAndTime.beat = n3;
                arrayList.add(tempoAndTime);
                return n4;
            }
            ++n4;
        }
        return n4;
    }

    private int getMeasureNumber(int n) {
        int n2 = this.measurelist[this.lastMeasureNumber].cumulativeTicks(this.scoreTicksPerBeat);
        if (n2 == n) {
            return this.measurelist[this.lastMeasureNumber].number();
        }
        if (n2 > n) {
            --this.lastMeasureNumber;
            return this.getMeasureNumber(n);
        }
        ++this.lastMeasureNumber;
        return this.getMeasureNumber(n);
    }

    private void interpolateBeatTime(ArrayList<TempoAndTime> arrayList) {
        TempoAndTime tempoAndTime = arrayList.get(1);
        if (Double.isNaN(tempoAndTime.tickInPfm)) {
            System.err.println("first note in MusicXML is not at t=0");
            tempoAndTime.setTickInPfm(0.0);
        }
        int n = arrayList.size();
        int n2 = 1;
        double d = tempoAndTime.tickInPfm;
        int n3 = -1;
        double d2 = 0.0;
        try {
            for (int i = 2; i < n - 1; ++i) {
                TempoAndTime tempoAndTime2 = arrayList.get(i);
                if (Double.isNaN(tempoAndTime2.tickInPfm)) {
                    if (i >= n3) {
                        n3 = i;
                        while (Double.isNaN(d2 = arrayList.get(n3).tickInPfm)) {
                            ++n3;
                        }
                    }
                    tempoAndTime2.setTickInPfm((d * (double)(n3 - i) + d2 * (double)(i - n2)) / (double)(n3 - n2));
                    continue;
                }
                n2 = i;
                d = tempoAndTime2.tickInPfm;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private double calcTempo(ArrayList<TempoAndTime> arrayList) {
        int n = arrayList.size();
        double d = 0.0;
        double d2 = 0.0;
        int n2 = 0;
        TempoAndTime tempoAndTime = arrayList.get(1);
        for (int i = 2; i < n; ++i) {
            double d3;
            int n3;
            TempoAndTime tempoAndTime2 = arrayList.get(i);
            if (Double.isNaN(tempoAndTime2.timeInSec)) {
                tempoAndTime.tempo = d;
                n3 = tempoAndTime2.tickInScore - tempoAndTime.tickInScore;
                d3 = (double)(n3 * 60 / this.scoreTicksPerBeat) / d;
                tempoAndTime2.setTimeInSec(tempoAndTime.timeInSec + d3);
            } else {
                n3 = tempoAndTime2.tickInScore - tempoAndTime.tickInScore;
                d3 = tempoAndTime2.timeInSec - tempoAndTime.timeInSec;
                tempoAndTime.tempo = (double)(n3 * 60 / this.scoreTicksPerBeat) / d3;
                d = tempoAndTime.tempo;
            }
            d2 += tempoAndTime.tempo;
            ++n2;
            tempoAndTime = tempoAndTime2;
        }
        arrayList.get(n - 1).tempo = d;
        return d2 / (double)n2;
    }

    private static void addTempoDeviations(DeviationDataSet deviationDataSet, ArrayList<TempoAndTime> arrayList, double d) {
        int n = arrayList.size();
        for (int i = 1; i < n - 1; ++i) {
            TempoAndTime tempoAndTime = arrayList.get(i);
            deviationDataSet.addNonPartwiseControl(tempoAndTime.measure, tempoAndTime.beat, "tempo-deviation", tempoAndTime.tempo / d);
        }
    }

    private class TempoAndTime {
        private double tempo = Double.NaN;
        private int tickInScore;
        private double tickInPfm = Double.NaN;
        private double timeInSec = Double.NaN;
        private int measure = -1;
        private int beat = -1;

        private TempoAndTime(int n) {
            this.tickInScore = n;
        }

        private void setTickInPfm(double d) {
            this.tickInPfm = d;
            this.timeInSec = d * 60.0 / (double)(PerformanceMatcher3.this.pfmTicksPerBeat * baseTempo);
        }

        private void setTimeInSec(double d) {
            this.timeInSec = d;
            this.tickInPfm = d * (double)PerformanceMatcher3.this.pfmTicksPerBeat * (double)baseTempo / 60.0;
        }

        private double beatLength() {
            return (double)(PerformanceMatcher3.this.pfmTicksPerBeat * baseTempo) / this.tempo;
        }
    }

    private static class DTWMatrix {
        private HashMap<IntPair, DTWMatrixElement> values;
        private int nrows;
        private int ncols;
        private final DTWMatrixElement DEFAULT_MATRIX_ELEMENT = new DTWMatrixElement(1.073741823E9, -1, -1);

        private DTWMatrix(int n, int n2) {
            this.nrows = n;
            this.ncols = n2;
            this.values = new HashMap(Math.max(n, n2));
        }

        private void set(int n, int n2, double d, int n3, int n4) {
            this.values.put(new IntPair(n, n2), new DTWMatrixElement(d, n3, n4));
        }

        private DTWMatrixElement get(int n, int n2) {
            if (n >= this.nrows || n2 >= this.ncols || n < -1 || n2 < -1) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (this.values.containsKey(new IntPair(n, n2))) {
                return this.values.get(new IntPair(n, n2));
            }
            return this.DEFAULT_MATRIX_ELEMENT;
        }

        private double getValue(int n, int n2) {
            return this.get(n, n2).value;
        }

        private class DTWMatrixElement {
            private int targetX;
            private int targetY;
            private double value;

            private DTWMatrixElement(double d, int n, int n2) {
                this.value = d;
                this.targetX = n;
                this.targetY = n2;
            }
        }

        private class IntPair {
            private int i;
            private int j;

            private IntPair(int n, int n2) {
                this.i = n;
                this.j = n2;
            }

            public boolean equals(Object object) {
                IntPair intPair = (IntPair)object;
                return this.i == intPair.i && this.j == intPair.j;
            }

            public int hashCode() {
                return this.i * DTWMatrix.this.nrows + this.j;
            }
        }
    }
}

