/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.misc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import jp.crestmuse.cmx.misc.QueueReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueWrapper<E> {
    private Queue<E> queue;
    private ArrayList<E> list;
    private int size;
    private byte nReaders = 0;
    private byte[] alreadyRead;

    public QueueWrapper(Queue<E> queue, int n) {
        this.queue = queue;
        this.size = n;
        this.list = new ArrayList();
        this.alreadyRead = new byte[n];
    }

    public QueueReader createReader() {
        this.nReaders = (byte)(this.nReaders + 1);
        return new QueueReaderImpl();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueueReaderImpl
    implements QueueReader<E> {
        private int next = 0;

        private QueueReaderImpl() {
        }

        @Override
        public E take() throws InterruptedException {
            Object e;
            if (this.next < QueueWrapper.this.list.size()) {
                e = QueueWrapper.this.list.get(this.next);
            } else {
                e = QueueWrapper.this.queue instanceof BlockingQueue ? ((BlockingQueue)QueueWrapper.this.queue).take() : QueueWrapper.this.queue.poll();
                QueueWrapper.this.list.add(e);
            }
            byte[] byArray = QueueWrapper.this.alreadyRead;
            int n = this.next;
            byArray[n] = (byte)(byArray[n] + 1);
            if (QueueWrapper.this.alreadyRead[this.next] >= QueueWrapper.this.nReaders) {
                QueueWrapper.this.list.set(this.next, null);
            }
            ++this.next;
            return e;
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator(){

                @Override
                public boolean hasNext() {
                    return QueueReaderImpl.this.next < QueueWrapper.this.size;
                }

                @Override
                public E next() {
                    try {
                        return QueueReaderImpl.this.take();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new RuntimeException();
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

