/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.misc;

import java.util.ArrayList;
import java.util.Iterator;
import jp.crestmuse.cmx.misc.NoteCompatible;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleNoteList
implements Iterable<NoteCompatible> {
    private int serial = 0;
    private String name = "";
    private ArrayList<NoteCompatible> notelist;
    private int lastOffset = 0;
    private int nnBottom = 128;
    private int nnTop = 0;
    private int ticksPerBeat;

    public SimpleNoteList(int n, int n2) {
        this.serial = n;
        this.ticksPerBeat = n2;
        this.notelist = new ArrayList();
    }

    public SimpleNoteList(String string, int n) {
        this.name = string;
        this.ticksPerBeat = n;
        this.notelist = new ArrayList();
    }

    public SimpleNoteList(int n, String string, int n2) {
        this.serial = n;
        this.name = string;
        this.ticksPerBeat = n2;
        this.notelist = new ArrayList();
    }

    public void add(NoteCompatible noteCompatible) {
        this.notelist.add(noteCompatible);
        if (noteCompatible.offset(this.ticksPerBeat) > this.lastOffset) {
            this.lastOffset = noteCompatible.offset(this.ticksPerBeat);
        }
        if (noteCompatible.notenum() > this.nnTop) {
            this.nnTop = noteCompatible.notenum();
        }
        if (noteCompatible.notenum() < this.nnBottom) {
            this.nnBottom = noteCompatible.notenum();
        }
    }

    @Override
    public Iterator<NoteCompatible> iterator() {
        return this.notelist.iterator();
    }

    public int size() {
        return this.notelist.size();
    }

    public NoteCompatible get(int n) {
        return this.notelist.get(n);
    }

    public int serial() {
        return this.serial;
    }

    public String name() {
        return this.name;
    }

    public int lastOffset() {
        return this.lastOffset;
    }

    public int bottomNoteNum() {
        return this.nnBottom;
    }

    public int topNoteNum() {
        return this.nnTop;
    }
}

