/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.filewrappers;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import javax.sound.sampled.AudioFormat;
import jp.crestmuse.cmx.amusaj.filewrappers.AudioDataCompatible;
import jp.crestmuse.cmx.filewrappers.FileWrapperCompatible;
import jp.crestmuse.cmx.filewrappers.InvalidFileTypeException;
import jp.crestmuse.cmx.math.DoubleArray;
import jp.crestmuse.cmx.math.DoubleArrayFactory;

public class WAVWrapper
implements FileWrapperCompatible,
AudioDataCompatible {
    private long filesize;
    private FmtChunk fmt = new FmtChunk();
    private DataChunk data = new DataChunk();
    private String filename = null;
    private static final DoubleArrayFactory dafactory = DoubleArrayFactory.getFactory();
    static final int LINEAR_PCM_FORMAT = 1;

    private WAVWrapper() {
    }

    public WAVWrapper(DoubleArray[] doubleArrayArray, int n) throws IOException {
        this();
        this.setWaveform(doubleArrayArray, n);
    }

    private void setWaveform(DoubleArray[] doubleArrayArray, int n) {
        this.fmt.setDefault(doubleArrayArray.length, n);
        this.data.setWaveform(doubleArrayArray);
        this.filesize = 8L + this.fmt.size + 4L + this.data.size;
    }

    public int sampleRate() {
        return this.fmt.samplesPerSec;
    }

    public DoubleArray[] getDoubleArrayWaveform() {
        return this.data.getWaveform();
    }

    public int channels() {
        return this.data.getWaveform().length;
    }

    public byte[] getByteArrayWaveform() {
        return this.data.bytearray;
    }

    public AudioFormat getAudioFormat() {
        return this.fmt.getAudioFormat();
    }

    public String getFileName() {
        return this.filename;
    }

    public static WAVWrapper readfile(String string) throws IOException {
        WAVWrapper wAVWrapper = new WAVWrapper();
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(string)));
        wAVWrapper.filename = string;
        wAVWrapper.read(dataInputStream);
        return wAVWrapper;
    }

    private void read(DataInputStream dataInputStream) throws IOException {
        this.readRIFFHeader(dataInputStream);
        byte[] byArray = new byte[4];
        while (dataInputStream.read(byArray) != -1) {
            String string = new String(byArray);
            if (string.equals("fmt ")) {
                this.fmt.read(dataInputStream);
                continue;
            }
            if (string.equals("data")) {
                this.data.read(dataInputStream);
                continue;
            }
            this.readDummyData(dataInputStream);
        }
        dataInputStream.close();
    }

    private void readRIFFHeader(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = new byte[4];
        dataInputStream.read(byArray);
        if (!new String(byArray).equals("RIFF")) {
            throw new InvalidFileTypeException();
        }
        this.filesize = WAVWrapper.readUnsignedInt(dataInputStream);
        dataInputStream.read(byArray);
        if (!new String(byArray).equals("WAVE")) {
            throw new InvalidFileTypeException();
        }
    }

    private static int readUnsignedShort(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedByte();
        int n2 = dataInputStream.readUnsignedByte();
        return n + 256 * n2;
    }

    private static int readSignedShort(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2 = dataInputStream.readUnsignedByte();
        int n3 = n2 + 256 * (n = dataInputStream.readUnsignedByte());
        return n3 >= 32768 ? n3 - 65536 : n3;
    }

    private static long readUnsignedInt(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedByte();
        int n2 = dataInputStream.readUnsignedByte();
        int n3 = dataInputStream.readUnsignedByte();
        int n4 = dataInputStream.readUnsignedByte();
        return n + 256 * n2 + 65536 * n3 + 0x1000000 * n4;
    }

    private void readDummyData(DataInputStream dataInputStream) throws IOException {
        long l = WAVWrapper.readUnsignedInt(dataInputStream);
        byte[] byArray = new byte[(int)l];
        dataInputStream.read(byArray);
    }

    public void writefile(String string) throws IOException {
        this.writefile(new File(string));
    }

    public void writefile(File file) throws IOException {
        this.write(new FileOutputStream(file));
    }

    public void write(OutputStream outputStream) throws IOException {
        this.write(new DataOutputStream(new BufferedOutputStream(outputStream)));
    }

    private void write(DataOutputStream dataOutputStream) throws IOException {
        this.writeRIFFHeader(dataOutputStream);
        this.fmt.write(dataOutputStream);
        this.data.write(dataOutputStream);
        dataOutputStream.close();
    }

    public void write(Writer writer) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeGZippedFile(File file) throws IOException {
        throw new UnsupportedOperationException();
    }

    private void writeRIFFHeader(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeBytes("RIFF");
        WAVWrapper.writeUnsignedInt(this.filesize, dataOutputStream);
        dataOutputStream.writeBytes("WAVE");
    }

    private static void writeUnsignedShort(int n, DataOutputStream dataOutputStream) throws IOException {
        byte by = (byte)(n / 256);
        byte by2 = (byte)(n % 256);
        dataOutputStream.writeByte(by2);
        dataOutputStream.writeByte(by);
    }

    private static void writeSignedShort(int n, DataOutputStream dataOutputStream) throws IOException {
        if (n < 0) {
            n += 65536;
        }
        WAVWrapper.writeUnsignedShort(n, dataOutputStream);
    }

    private static void writeUnsignedInt(long l, DataOutputStream dataOutputStream) throws IOException {
        byte by = (byte)(l / 0x1000000L);
        byte by2 = (byte)(l % 0x1000000L / 65536L);
        byte by3 = (byte)(l % 65536L / 256L);
        byte by4 = (byte)(l % 256L);
        dataOutputStream.writeByte(by4);
        dataOutputStream.writeByte(by3);
        dataOutputStream.writeByte(by2);
        dataOutputStream.writeByte(by);
    }

    private class DataChunk {
        private long size;
        private DoubleArray[] data = null;
        private short[] dataInShort = null;
        private byte[] bytearray = null;

        private DataChunk() {
        }

        private void setWaveform(DoubleArray[] doubleArrayArray) {
            this.data = doubleArrayArray;
            this.size = WAVWrapper.this.fmt.blocksize * doubleArrayArray[0].length();
        }

        private DoubleArray[] getWaveform() {
            if (this.data == null) {
                int n;
                int n2 = (int)(this.size / (long)WAVWrapper.this.fmt.blocksize);
                this.data = new DoubleArray[WAVWrapper.this.fmt.channels];
                for (n = 0; n < WAVWrapper.this.fmt.channels; ++n) {
                    this.data[n] = dafactory.createArray(n2);
                }
                for (n = 0; n < n2; ++n) {
                    for (int i = 0; i < WAVWrapper.this.fmt.channels; ++i) {
                        this.data[i].set(n, (double)this.dataInShort[n * WAVWrapper.this.fmt.channels + i] / 32768.0);
                    }
                }
            }
            return this.data;
        }

        private void read(DataInputStream dataInputStream) throws IOException {
            block6: {
                ByteBuffer byteBuffer;
                int n;
                block5: {
                    if (WAVWrapper.this.fmt.format != 1) {
                        throw new InvalidFileTypeException("unsupported waveform type");
                    }
                    this.size = WAVWrapper.readUnsignedInt(dataInputStream);
                    n = (int)(this.size / (long)WAVWrapper.this.fmt.blocksize);
                    this.bytearray = new byte[(int)this.size];
                    dataInputStream.read(this.bytearray);
                    byteBuffer = ByteBuffer.wrap(this.bytearray);
                    this.dataInShort = new short[n * WAVWrapper.this.fmt.channels];
                    if (WAVWrapper.this.fmt.bitsPerSample != 8) break block5;
                    for (int i = 0; i < n; ++i) {
                        for (int j = 0; j < WAVWrapper.this.fmt.channels; ++j) {
                            byte by = byteBuffer.get();
                            this.dataInShort[i * ((FmtChunk)((WAVWrapper)WAVWrapper.this).fmt).channels + j] = by >= 0 ? (short)(by - 128) : (short)(by + 128);
                        }
                    }
                    break block6;
                }
                if (WAVWrapper.this.fmt.bitsPerSample != 16) break block6;
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < WAVWrapper.this.fmt.channels; ++j) {
                        this.dataInShort[i * ((FmtChunk)((WAVWrapper)WAVWrapper.this).fmt).channels + j] = byteBuffer.getShort();
                    }
                }
            }
        }

        private short[] getShortArray() {
            if (this.dataInShort == null) {
                this.dataInShort = new short[this.getWaveform()[0].length() * this.data.length];
                for (int i = 0; i < this.getWaveform()[0].length(); ++i) {
                    for (int j = 0; j < this.getWaveform().length; ++j) {
                        this.dataInShort[i * j] = (short)(this.getWaveform()[j].get(j) * 32768.0);
                    }
                }
            }
            return this.dataInShort;
        }

        private void write(DataOutputStream dataOutputStream) throws IOException {
            if (WAVWrapper.this.fmt.format != 1) {
                throw new InvalidFileTypeException("unsupported waveform type");
            }
            dataOutputStream.writeBytes("data");
            WAVWrapper.writeUnsignedInt(this.size, dataOutputStream);
            int n = (int)(this.size / (long)WAVWrapper.this.fmt.blocksize);
            for (int i = 0; i < n; ++i) {
                if (i % 65536 == 0) {
                    System.err.print(".");
                }
                for (int j = 0; j < WAVWrapper.this.fmt.channels; ++j) {
                    if (WAVWrapper.this.fmt.bitsPerSample == 8) {
                        dataOutputStream.writeByte((int)(this.getWaveform()[j].get(i) * 128.0 + 128.0));
                        continue;
                    }
                    if (WAVWrapper.this.fmt.bitsPerSample == 16) {
                        WAVWrapper.writeSignedShort((int)(this.getWaveform()[j].get(i) * 32768.0), dataOutputStream);
                        continue;
                    }
                    throw new InvalidFileTypeException();
                }
            }
        }
    }

    private class FmtChunk {
        private long size;
        private int format;
        private int channels;
        private int samplesPerSec;
        private long bytesPerSec;
        private int blocksize;
        private int bitsPerSample;
        private byte[] ext;

        private FmtChunk() {
        }

        private void setDefault(int n, int n2) {
            this.size = 16L;
            this.format = 1;
            this.channels = n;
            this.samplesPerSec = n2;
            this.bitsPerSample = 16;
            this.bytesPerSec = this.samplesPerSec * this.channels * (this.bitsPerSample / 8);
            this.blocksize = this.channels * (this.bitsPerSample / 8);
        }

        private AudioFormat getAudioFormat() {
            return new AudioFormat(this.samplesPerSec, this.bitsPerSample, this.channels, this.bitsPerSample != 8, false);
        }

        private void read(DataInputStream dataInputStream) throws IOException {
            this.size = WAVWrapper.readUnsignedInt(dataInputStream);
            this.format = WAVWrapper.readUnsignedShort(dataInputStream);
            this.channels = WAVWrapper.readUnsignedShort(dataInputStream);
            this.samplesPerSec = (int)WAVWrapper.readUnsignedInt(dataInputStream);
            this.bytesPerSec = WAVWrapper.readUnsignedInt(dataInputStream);
            this.blocksize = WAVWrapper.readUnsignedShort(dataInputStream);
            this.bitsPerSample = WAVWrapper.readUnsignedShort(dataInputStream);
            if (this.size > 16L) {
                this.ext = new byte[(int)this.size - 16];
                dataInputStream.read(this.ext);
            }
        }

        private void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeBytes("fmt ");
            WAVWrapper.writeUnsignedInt(this.size, dataOutputStream);
            WAVWrapper.writeUnsignedShort(this.format, dataOutputStream);
            WAVWrapper.writeUnsignedShort(this.channels, dataOutputStream);
            WAVWrapper.writeUnsignedInt(this.samplesPerSec, dataOutputStream);
            WAVWrapper.writeUnsignedInt(this.bytesPerSec, dataOutputStream);
            WAVWrapper.writeUnsignedShort(this.blocksize, dataOutputStream);
            WAVWrapper.writeUnsignedShort(this.bitsPerSample, dataOutputStream);
            if (this.size > 16L) {
                dataOutputStream.write(this.ext);
            }
        }
    }
}

