/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.commands;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.commands.ConfigXMLException;
import jp.crestmuse.cmx.commands.InvalidNumberOfFilesException;
import jp.crestmuse.cmx.commands.InvalidOptionException;
import jp.crestmuse.cmx.commands.NotOverridenException;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.filewrappers.CMXInitializer;
import jp.crestmuse.cmx.filewrappers.ConfigXMLWrapper;
import jp.crestmuse.cmx.filewrappers.FileWrapperCompatible;
import jp.crestmuse.cmx.filewrappers.InvalidFileTypeException;
import jp.crestmuse.cmx.misc.EmptyQueueException;
import jp.crestmuse.cmx.misc.Queue;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CMXCommand<F1 extends FileWrapperCompatible, F2 extends FileWrapperCompatible>
implements CMXInitializer {
    private F1 indata;
    private F2 outdata;
    private Queue<String> filenames;
    private String filename;
    private String outfilename = null;
    private String dirDest = null;
    private String ext = null;
    private StringBuffer helpMessage = new StringBuffer();
    private boolean isStdOut = false;
    private boolean mkdir = false;
    private boolean gzipped = false;
    private static String configfilename = null;
    private static ConfigXMLWrapper config = null;

    private void setOutfilename(String string) {
        this.outfilename = string;
    }

    private void setOutFileName(String string) {
        this.outfilename = string;
    }

    protected String getOutFileName() {
        if (this.outfilename == null) {
            return null;
        }
        if (this.outfilename.contains("%d")) {
            return this.outfilename.replace("%d", this.getDestDir());
        }
        return this.outfilename;
    }

    public CMXCommand() {
        this.filenames = new Queue();
        this.appendDefaultHelpMessage();
    }

    public final F1 indata() {
        return this.indata;
    }

    public final F2 outdata() {
        return this.outdata;
    }

    public final void newOutputData(String string) throws InvalidFileTypeException, ParserConfigurationException, SAXException {
        this.outdata = CMXFileWrapper.createDocument(string);
    }

    public final void setOutputData(F2 F2) {
        this.outdata = F2;
    }

    protected String getVersion() {
        return "0.32.000";
    }

    private final void readCommandLine(String[] stringArray) throws InvalidOptionException, IOException {
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("-")) {
                boolean bl = this.setBoolOptions(stringArray[i]);
                if (bl) continue;
                string = stringArray[i];
                continue;
            }
            if (string == null) {
                this.filenames.enqueue(stringArray[i]);
                continue;
            }
            this.setOptions(string, stringArray[i]);
            string = null;
        }
    }

    private boolean setBoolOptions(String string) {
        if (string.equals("-stdout")) {
            this.isStdOut = true;
            return true;
        }
        if (string.equals("-mkdir")) {
            this.mkdir = true;
            return true;
        }
        if (string.equals("-gz")) {
            this.gzipped = true;
            return true;
        }
        return this.setBoolOptionsLocal(string);
    }

    protected boolean setBoolOptionsLocal(String string) {
        return false;
    }

    private void setOptions(String string, String string2) throws InvalidOptionException, IOException {
        if (string.equals("-d")) {
            this.dirDest = string2;
        } else if (string.equals("-o") || string.equals("-out")) {
            this.outfilename = string2;
        } else if (string.equals("-ext")) {
            this.ext = string2;
        } else if (string.equals("-S")) {
            this.setFileList(string2);
        } else if (string.equals("-conf")) {
            configfilename = string2;
        } else if (string.equals("-catalog")) {
            CMXFileWrapper.catalogFileName = string2;
        } else if (string.equals("-err")) {
            try {
                System.setErr(new PrintStream(new FileOutputStream(string2)));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new FileNotFoundException("Can't change Standard Error.");
            }
        } else if (string.equals("-property")) {
            Properties properties = new Properties(System.getProperties());
            properties.load(new FileInputStream(new File(string2)));
            System.setProperties(properties);
        } else if (!this.setOptionsLocal(string, string2)) {
            throw new InvalidOptionException("Invalid option: " + string);
        }
    }

    protected boolean setOptionsLocal(String string, String string2) {
        return false;
    }

    private void setFileList(String string) throws IOException {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                this.filenames.enqueue(string2);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileNotFoundException("FileList not found.");
        }
    }

    protected String getDestDir() {
        if (this.dirDest == null) {
            return null;
        }
        if (this.dirDest.contains("%_")) {
            return this.dirDest.replace("%_", new File(this.filename).getAbsoluteFile().getParent());
        }
        return this.dirDest;
    }

    protected boolean loopEnabled() {
        return true;
    }

    protected int requiredFiles() {
        return 1;
    }

    protected FileWrapperCompatible readInputData(String string) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        return CMXFileWrapper.readfile(string, (CMXInitializer)this);
    }

    @Override
    public void init(CMXFileWrapper cMXFileWrapper) {
    }

    public final void start(String[] stringArray) throws IOException, SAXException, ParserConfigurationException, TransformerException, InvalidOptionException, InvalidFileTypeException {
        this.showHelpIfNeeded(stringArray);
        this.readCommandLine(stringArray);
        this.runAll();
    }

    void runAll() throws IOException, ParserConfigurationException, TransformerException, SAXException, InvalidFileTypeException, InvalidOptionException {
        int n = this.requiredFiles();
        if (this.loopEnabled() && this.filenames.size() % n != 0) {
            throw new InvalidNumberOfFilesException();
        }
        if (!this.loopEnabled() && this.filenames.size() != n) {
            throw new InvalidNumberOfFilesException();
        }
        this.preproc();
        FileWrapperCompatible[] fileWrapperCompatibleArray = new FileWrapperCompatible[n];
        try {
            do {
                Object object;
                for (int i = 0; i < n; ++i) {
                    object = this.filenames.dequeue();
                    System.err.println("[" + (String)object + "]");
                    fileWrapperCompatibleArray[i] = this.readInputData((String)object);
                }
                this.filename = fileWrapperCompatibleArray[0].getFileName();
                this.outdata = null;
                String string = this.getDestDir();
                if (this.mkdir && string != null && !((File)(object = new File(string))).exists()) {
                    ((File)object).mkdirs();
                }
                this.outdata = this.run((F1)fileWrapperCompatibleArray);
                if (this.outdata == null) continue;
                if (this.isStdOut) {
                    this.outdata.write(System.out);
                    continue;
                }
                File file = null;
                object = this.getOutFileName();
                if (object != null) {
                    file = new File((String)object);
                } else if (string != null) {
                    file = this.ext != null ? new File(string, CMXCommand.getBaseName(this.filename) + "." + this.ext) : new File(string, CMXCommand.removeDirName(this.filename));
                } else if (this.ext != null) {
                    file = new File(CMXCommand.removeExt(this.filename) + "." + this.ext);
                }
                if (file == null) {
                    this.outdata.write(System.out);
                    continue;
                }
                if (this.gzipped) {
                    this.outdata.writeGZippedFile(file);
                    continue;
                }
                this.outdata.writefile(file);
            } while (this.loopEnabled());
        }
        catch (EmptyQueueException emptyQueueException) {
            this.postproc();
        }
    }

    protected void run() throws IOException, ParserConfigurationException, SAXException, TransformerException, InvalidFileTypeException {
        throw new NotOverridenException();
    }

    protected F2 run(F1 F1) throws IOException, ParserConfigurationException, SAXException, TransformerException, InvalidFileTypeException {
        if (F1 != null) {
            this.indata = F1;
        }
        this.run();
        return this.outdata;
    }

    protected F2 run(F1[] F1Array) throws IOException, ParserConfigurationException, SAXException, TransformerException, InvalidFileTypeException {
        if (F1Array.length == 0) {
            return this.run((FileWrapperCompatible)null);
        }
        if (F1Array.length == 1) {
            return this.run(F1Array[0]);
        }
        throw new NotOverridenException();
    }

    protected void preproc() throws IOException, InvalidOptionException, ParserConfigurationException, SAXException, TransformerException {
    }

    protected void postproc() throws IOException, ParserConfigurationException, SAXException, TransformerException {
    }

    protected final String getFileName() {
        return this.filename;
    }

    String[] getFileList() {
        return this.filenames.toArray();
    }

    public static ConfigXMLWrapper getConfigXMLWrapper() {
        try {
            if (config == null) {
                config = (ConfigXMLWrapper)CMXFileWrapper.readfile(configfilename);
            }
            return config;
        }
        catch (NullPointerException nullPointerException) {
            throw new ConfigXMLException("ConfigXML file is not specfied.");
        }
        catch (IOException iOException) {
            throw new ConfigXMLException(iOException.toString());
        }
    }

    private void showHelpIfNeeded(String[] stringArray) {
        if (stringArray.length < this.requiredFiles() || stringArray.length >= 1 && (stringArray[0].equals("-h") || stringArray[0].equals("-help"))) {
            System.err.println(this.helpMessage);
            System.exit(1);
        }
    }

    protected String getHelpMessage() {
        return this.helpMessage.toString();
    }

    private void appendDefaultHelpMessage() {
        this.appendHelpMessage("[" + this.getClass().getName() + " version " + this.getVersion() + "]");
        this.appendHelpMessage("Usage: ");
        this.appendHelpMessage("java [<VM options>] " + this.getClass().getName() + " [<options>] <filename>...");
        this.appendHelpMessage("Options :");
        this.appendHelpMessage("-h: show this help message");
        this.appendHelpMessage("-d <dirname>: specify the output directory");
        this.appendHelpMessage("-o <filename>: specioutput file name");
        this.appendHelpMessage("-stdout: output the generated object to the standard output");
    }

    protected void appendHelpMessage(String string) {
        this.helpMessage.append(string);
        this.helpMessage.append("\n");
    }

    protected void showErrorMessage(Exception exception) {
        exception.printStackTrace();
    }

    protected void exitWithMessage(String string) {
        System.err.println(string);
        System.exit(1);
    }

    protected static String removeExt(String string) {
        return CMXCommand.removeExt(string, ".");
    }

    protected static String removeExt(String string, String string2) {
        int n = string.lastIndexOf(string2);
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    protected static String getBaseName(String string) {
        return CMXCommand.getBaseName(string, ".");
    }

    protected static String getBaseName(String string, String string2) {
        int n = string.lastIndexOf(File.separator);
        int n2 = string.lastIndexOf(string2);
        if (n2 < 0) {
            n2 = string.length();
        }
        return string.substring(n + 1, n2);
    }

    protected static String removeDirName(String string) {
        int n = string.lastIndexOf(File.separator);
        return string.substring(n + 1);
    }
}

