/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequencer;
import jp.crestmuse.cmx.amusaj.filewrappers.BayesNetWrapper;
import jp.crestmuse.cmx.amusaj.sp.MidiInputModule;
import jp.crestmuse.cmx.amusaj.sp.MidiOutputModule;
import jp.crestmuse.cmx.amusaj.sp.SPExecutor;
import jp.crestmuse.cmx.inference.AccompanimentCalculator;
import jp.crestmuse.cmx.inference.AccompanimentGenerator;
import jp.crestmuse.cmx.inference.MusicRepresentation;
import jp.crestmuse.cmx.inference.MusicRepresentationModule;
import jp.crestmuse.cmx.inference.NaiveVoicingCalculator;
import jp.crestmuse.cmx.sound.SequencerManager;

public class AutoAccompanimentSystem {
    static MusicRepresentation mr;

    public static void main(String[] stringArray) {
        try {
            MidiInputModule midiInputModule;
            if (stringArray.length < 2) {
                System.err.println("Usage: java -jar BayesianBand.jar <model file> <midi file> <options>");
                System.exit(1);
            }
            int n = 8;
            String string = stringArray[0];
            String string2 = stringArray[1];
            String string3 = "C";
            String string4 = null;
            boolean bl = false;
            for (int i = 2; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-length")) {
                    n = Integer.parseInt(stringArray[i + 1]);
                    ++i;
                    continue;
                }
                if (stringArray[i].equals("-start")) {
                    string3 = stringArray[i + 1];
                    ++i;
                    continue;
                }
                if (stringArray[i].equals("-smf")) {
                    string4 = stringArray[i + 1];
                    ++i;
                    continue;
                }
                if (!stringArray[i].equals("-v")) continue;
                bl = true;
            }
            mr = new MusicRepresentation(n, 8);
            mr.setTiedChordLength(8);
            mr.setTiedVoicingLength(8);
            mr.setTiedBassLength(2);
            AccompanimentCalculator accompanimentCalculator = new AccompanimentCalculator(mr, new BayesNetWrapper(string));
            NaiveVoicingCalculator naiveVoicingCalculator = new NaiveVoicingCalculator(mr);
            mr.addCalculator(accompanimentCalculator);
            mr.addCalculator(naiveVoicingCalculator);
            MusicRepresentation.MusicElement musicElement = mr.addChordElement(0);
            musicElement.setProb(musicElement.indexOf(string3), 1.0);
            mr.update(MusicRepresentation.Type.Chord, musicElement, 0);
            Sequencer sequencer = null;
            if (string4 != null) {
                sequencer = MidiSystem.getSequencer(false);
                sequencer.setSequence(MidiSystem.getSequence(new File(string4)));
                midiInputModule = new MidiInputModule(sequencer);
            } else {
                midiInputModule = new MidiInputModule(AutoAccompanimentSystem.getMidiDevice(true));
            }
            SPExecutor sPExecutor = new SPExecutor(null, 1);
            MusicRepresentationModule musicRepresentationModule = new MusicRepresentationModule(mr, bl);
            MidiDevice midiDevice = AutoAccompanimentSystem.getMidiDevice(false);
            midiDevice.open();
            MidiOutputModule midiOutputModule = new MidiOutputModule(midiDevice.getReceiver());
            SequencerManager sequencerManager = new SequencerManager(midiDevice.getReceiver());
            if (string4 != null) {
                sequencer.setMasterSyncMode(sequencerManager.getSequencer().getMasterSyncMode());
            }
            AccompanimentGenerator accompanimentGenerator = new AccompanimentGenerator(mr, string2);
            sequencerManager.addGeneratable(accompanimentGenerator);
            midiInputModule.setTickTimer(sequencerManager);
            sPExecutor.addSPModule(midiInputModule);
            sPExecutor.addSPModule(midiOutputModule);
            sPExecutor.addSPModule(musicRepresentationModule);
            sPExecutor.connect(midiInputModule, 0, midiOutputModule, 0);
            sPExecutor.connect(midiInputModule, 0, musicRepresentationModule, 0);
            sequencerManager.start();
            if (string4 != null) {
                sequencer.start();
            }
            sPExecutor.start();
            System.err.println("press button to exit...");
            System.in.read();
            sPExecutor.stop();
            midiDevice.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.exit(0);
    }

    public static MidiDevice getMidiDevice(boolean bl) {
        MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
        MidiDevice midiDevice = null;
        for (int i = 0; i < infoArray.length; ++i) {
            try {
                midiDevice = MidiSystem.getMidiDevice(infoArray[i]);
                if (bl && midiDevice.getMaxTransmitters() == 0 || !bl && midiDevice.getMaxReceivers() == 0) continue;
                System.err.println("*** " + i + " ***");
                System.err.println("  Description:" + infoArray[i].getDescription());
                System.err.println("  Name:" + infoArray[i].getName());
                System.err.println("  Vendor:" + infoArray[i].getVendor());
                System.err.println();
                continue;
            }
            catch (MidiUnavailableException midiUnavailableException) {
                midiUnavailableException.printStackTrace();
            }
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in), 1);
            if (bl) {
                System.err.print("Using Input Device Number: ");
            } else {
                System.err.print("Using Output Device Number: ");
            }
            String string = bufferedReader.readLine();
            midiDevice = MidiSystem.getMidiDevice(infoArray[Integer.parseInt(string)]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return midiDevice;
    }
}

