/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jp.crestmuse.cmx.amusaj.filewrappers.MutableTimeSeries;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.sp.ProducerConsumerCompatible;
import jp.crestmuse.cmx.amusaj.sp.SPElement;
import jp.crestmuse.cmx.misc.QueueReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPExecutor {
    private List<SPThread> list = new LinkedList<SPThread>();
    private SPThread lastThread = null;
    private Map<ProducerConsumerCompatible, SPModule> map = new HashMap<ProducerConsumerCompatible, SPModule>();
    private Map<String, String> params;
    private int timeunit;
    private long sleepTime = 0L;

    public SPExecutor(Map<String, String> map, int n) {
        this.params = map;
        this.timeunit = n;
    }

    public void addSPModule(ProducerConsumerCompatible producerConsumerCompatible) {
        int n;
        if (this.lastThread == null) {
            this.lastThread = new SPThread();
            this.list.add(this.lastThread);
        }
        producerConsumerCompatible.setParams(this.params);
        SPModule sPModule = new SPModule();
        sPModule.module = producerConsumerCompatible;
        int n2 = producerConsumerCompatible.getOutputChannels();
        for (n = 0; n < n2; ++n) {
            sPModule.dest.add(new MutableTimeSeries());
        }
        n2 = producerConsumerCompatible.getInputChannels();
        for (n = 0; n < n2; ++n) {
            sPModule.src.add(null);
        }
        this.lastThread.modules.add(sPModule);
        this.map.put(producerConsumerCompatible, sPModule);
    }

    public void newThread() {
        this.lastThread = null;
    }

    public void connect(ProducerConsumerCompatible producerConsumerCompatible, int n, ProducerConsumerCompatible producerConsumerCompatible2, int n2) {
        SPModule sPModule = this.map.get(producerConsumerCompatible);
        SPModule sPModule2 = this.map.get(producerConsumerCompatible2);
        System.err.println(sPModule);
        System.err.println(sPModule.dest);
        System.err.println(sPModule.dest.get(n));
        System.err.println(sPModule2);
        System.err.println(sPModule2.src);
        sPModule2.src.set(n2, sPModule.dest.get(n).getQueueReader());
    }

    public void start() {
        for (SPThread sPThread : this.list) {
            sPThread.start();
        }
    }

    public void stop() {
        for (SPThread sPThread : this.list) {
            sPThread.interrupt();
        }
    }

    public boolean finished() {
        for (SPThread sPThread : this.list) {
            if (sPThread.finish) continue;
            return false;
        }
        return true;
    }

    public boolean finished(ProducerConsumerCompatible producerConsumerCompatible) {
        return this.map.get((Object)producerConsumerCompatible).finish;
    }

    public List<TimeSeriesCompatible<? extends SPElement>> getResult(ProducerConsumerCompatible producerConsumerCompatible) {
        return this.map.get((Object)producerConsumerCompatible).dest;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setSleepTime(long l) {
        this.sleepTime = l;
    }

    private class SPModule {
        ProducerConsumerCompatible module;
        List<QueueReader<? extends SPElement>> src = new ArrayList<QueueReader<? extends SPElement>>();
        List<TimeSeriesCompatible<? extends SPElement>> dest = new ArrayList<TimeSeriesCompatible<? extends SPElement>>();
        boolean finish = false;

        private SPModule() {
        }
    }

    private class SPThread
    extends Thread {
        private List<SPModule> modules = new LinkedList<SPModule>();
        private boolean finish = false;

        private SPThread() {
        }

        public void run() {
            int n = this.modules.size();
            int n2 = 0;
            for (SPModule sPModule : this.modules) {
                if (sPModule.dest.size() != 0) continue;
                ++n2;
            }
            while (n2 < n) {
                try {
                    for (SPModule sPModule : this.modules) {
                        if (sPModule.finish) continue;
                        sPModule.module.execute(sPModule.src, sPModule.dest);
                        if (sPModule.dest.size() == 0) continue;
                        boolean bl = true;
                        for (TimeSeriesCompatible<? extends SPElement> timeSeriesCompatible : sPModule.dest) {
                            bl = bl && timeSeriesCompatible.isComplete();
                        }
                        if (!bl) continue;
                        System.err.println("finished: " + sPModule.module);
                        sPModule.finish = true;
                        ++n2;
                    }
                    if (SPExecutor.this.sleepTime > 0L) {
                        SPThread.sleep(SPExecutor.this.sleepTime);
                    }
                    if (!Thread.interrupted()) continue;
                    break;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
            }
            for (SPModule sPModule : this.modules) {
                sPModule.module.stop(sPModule.src, sPModule.dest);
            }
            this.finish = true;
        }
    }
}

