/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.inference;

import java.util.List;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.sp.MidiEventWithTicktime;
import jp.crestmuse.cmx.amusaj.sp.SPDummyObject;
import jp.crestmuse.cmx.amusaj.sp.SPModule;
import jp.crestmuse.cmx.inference.MusicRepresentation;
import jp.crestmuse.cmx.misc.QueueReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MusicRepresentationModule
extends SPModule<MidiEventWithTicktime, SPDummyObject> {
    private MusicRepresentation musicRepresentation;
    private boolean writeLog;

    public MusicRepresentationModule(MusicRepresentation musicRepresentation) {
        this(musicRepresentation, false);
    }

    public MusicRepresentationModule(MusicRepresentation musicRepresentation, boolean bl) {
        this.musicRepresentation = musicRepresentation;
        this.writeLog = bl;
    }

    @Override
    public void execute(List<QueueReader<MidiEventWithTicktime>> list, List<TimeSeriesCompatible<SPDummyObject>> list2) throws InterruptedException {
        MidiEventWithTicktime midiEventWithTicktime = list.get(0).take();
        byte[] byArray = midiEventWithTicktime.getMessage().getMessage();
        if ((byArray[0] & 0xF0) == 144 && byArray[2] > 0) {
            int n = this.musicRepresentation.getIndex(midiEventWithTicktime.music_position);
            MusicRepresentation.MusicElement musicElement = this.musicRepresentation.addMelodyElement(n);
            musicElement.setEvidence(byArray[1]);
            this.musicRepresentation.update(MusicRepresentation.Type.Melody, musicElement, n);
            if (this.writeLog && n < this.musicRepresentation.getDivision() * this.musicRepresentation.getMeasureNum() - 2) {
                System.out.println(midiEventWithTicktime.music_position + ", " + byArray[1] + ", " + byArray[2]);
                MusicRepresentation.MusicElement musicElement2 = this.musicRepresentation.getMelodyElement(n + 1);
                if (musicElement2 != null) {
                    for (int i = 0; i < 11; ++i) {
                        System.out.print(musicElement2.getLabel(i) + ":" + musicElement2.getProb(i) + ", ");
                    }
                }
                System.out.print(musicElement2.getLabel(11) + ":" + musicElement2.getProb(11));
                System.out.println();
                MusicRepresentation.MusicElement musicElement3 = this.musicRepresentation.getChordElement((n / this.musicRepresentation.getDivision() + 1) * this.musicRepresentation.getDivision());
                if (musicElement3 != null) {
                    for (int i = 0; i < 6; ++i) {
                        System.out.print(musicElement3.getLabel(i) + ":" + musicElement3.getProb(i) + ", ");
                    }
                    System.out.print(musicElement3.getLabel(6) + ":" + musicElement3.getProb(6));
                }
                System.out.println();
            }
        }
    }

    @Override
    public int getInputChannels() {
        return 1;
    }

    @Override
    public int getOutputChannels() {
        return 0;
    }
}

