/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.TrapezoidIntegrator;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.UnivariateRealIntegratorImpl;

public class SimpsonIntegrator
extends UnivariateRealIntegratorImpl {
    private static final long serialVersionUID = 3405465123320678216L;

    public SimpsonIntegrator(UnivariateRealFunction f) {
        super(f, 64);
    }

    public double integrate(double min, double max) throws MaxIterationsExceededException, FunctionEvaluationException, IllegalArgumentException {
        this.clearResult();
        this.verifyInterval(min, max);
        this.verifyIterationCount();
        TrapezoidIntegrator qtrap = new TrapezoidIntegrator(this.f);
        if (this.minimalIterationCount == 1) {
            double s = (4.0 * qtrap.stage(min, max, 1) - qtrap.stage(min, max, 0)) / 3.0;
            this.setResult(s, 1);
            return this.result;
        }
        double olds = 0.0;
        double oldt = qtrap.stage(min, max, 0);
        for (int i = 1; i <= this.maximalIterationCount; ++i) {
            double t = qtrap.stage(min, max, i);
            double s = (4.0 * t - oldt) / 3.0;
            if (i >= this.minimalIterationCount && Math.abs(s - olds) <= Math.abs(this.relativeAccuracy * olds)) {
                this.setResult(s, i);
                return this.result;
            }
            olds = s;
            oldt = t;
        }
        throw new MaxIterationsExceededException(this.maximalIterationCount);
    }

    protected void verifyIterationCount() throws IllegalArgumentException {
        super.verifyIterationCount();
        if (this.maximalIterationCount > 64) {
            throw new IllegalArgumentException("Iteration upper limit out of [0, 64] range: " + this.maximalIterationCount);
        }
    }
}

