package jp.crestmuse.cmx.amusaj.commands;

import jp.crestmuse.cmx.filewrappers.SCCXMLWrapper;

public class ARFFFunctions {

	
	static ChordConverter cc = new ChordConverter();
	
	static final String key_set_Regexp = "C|B#|C#|Db|D|D#|Eb|E|Fb|F|E#|F#|Gb|G|G#|Ab|A|A#|Bb|B|Cb";

	//ノートナンバーを12で割った余り
    static final String[] notenums_div12 = { "0", "1", "2", "3", "4", "5", "6", "7", "8", "9",
            "10", "11" };
    
    // 48種類に圧縮したコード M,m,aug,dim,(#5),(b5)
    static final String[] chords_48 = {
    		"A", "A#", "A#aug", "A#dim", "A#m", "Aaug", "Adim", "Am",
    		"B", "Baug", "Bdim", "Bm", "C", "C#", "C#aug", "C#dim", "C#m",
    		"Caug", "Cdim", "Cm", "D", "D#", "D#aug", "D#dim", "D#m", "Daug",
    		"Ddim", "Dm", "E", "Eaug", "Edim", "Em", "F", "F#", "F#aug", "F#dim",
    		"F#m", "Faug", "Fdim", "Fm", "G", "G#", "G#aug", "G#dim", "G#m",
    		"Gaug", "Gdim", "Gm"};
    
    //ダイアトニックコード
    static final String[] diatonic_chords ={"C", "Dm", "Em", "F", "G", "Am", "Bm(b5)"};
    static final String diatonic_chords_RegExp = "C|Dm|Em|F|G|Am|Bm(b5)";
    
	//ARFF上で無視するコード
	static final String ignore_chords = ".+\\(b5\\)|.+\\(#5\\)|.+maug|.+mdim";
    
    // 曲のキーを取得
    public static String getMusicKey(SCCXMLWrapper scc){
	    for(int i=0; i < scc.getHeaderElementList().length; i++){
	    	if(scc.getHeaderElementList()[i].name().equals("KEY")){
	    		
	    		if(cc.getPrefix(scc.getHeaderElementList()[i].content()).matches(key_set_Regexp))
	    			return cc.getPrefix(scc.getHeaderElementList()[i].content());
	    	}
	    }
	    return null;
    }
}
