package jp.crestmuse.cmx.amusaj.commands;

import jp.crestmuse.cmx.amusaj.filewrappers.BayesNetWrapper;
import jp.crestmuse.cmx.filewrappers.*;
import jp.crestmuse.cmx.filewrappers.SCCXMLWrapper.*;

import jp.crestmuse.cmx.filewrappers.SCCXMLWrapper.Note;

public class Checker080811model3 {
	
	private BayesNetWrapper bnw;
	private int totalTrial = 0;
	private int totalCorrect = 0;
	private int totalInf2 = 0;
	private int totalInf3 = 0;
	private int totalFailed =0;
	private int totalSamePrefix = 0;
	
	
	public Checker080811model3(String biffile){
		bnw = new BayesNetWrapper(biffile);
	}

	public void checkSCCXML(String filename){
		
		String musickey;
		int countTrial = 0;
		int countCorrect = 0;
		int countInf2 = 0;
		int countInf3 = 0;
		int countFailed = 0;
		int countSamePrefix = 0;
		
		try{
			SCCXMLWrapper scc = (SCCXMLWrapper)CMXFileWrapper.readfile(filename);
		    ChordConverter cc = new ChordConverter();
		    
		    musickey=ARFFFunctions.getMusicKey(scc);
		    if(musickey == null) return;
		    
			int pprevNote = -1;
			String pprevChord = null;
			int prevNote = -1;
		    String prevChord = null;
		    
			for(Annotation a: scc.getChordList()){
				
				String currentChord = a.content();
				
				 int currentNote = -1;
			      //
				 for(Note n : scc.getPartList()[0].getNoteList()){
			        if (n.onset() >= a.onset()) {
			          currentNote = n.notenum() % 12;
			          break;
			        }
			      }
			      
				 if(currentNote == -1)
					 continue;	//currentNoteが取得できなかったものは回避(ノート無しでコードが鳴り続けるものへの対処)
				 	
			      //currentChordが"/"の時はprevChordを代入
			      currentChord = cc.chordOmitter(cc.chordTransfer(musickey, currentChord));
			      if(currentChord.equals("/")){
			    	  currentChord = prevChord;
			      }
			      currentNote = cc.noteTransfer(musickey, currentNote);
			      
			      if (prevChord != null && currentNote != -1 && pprevChord != null )
			      if (prevChord.matches(ARFFFunctions.diatonic_chords_RegExp)
			    		  && pprevChord.matches(ARFFFunctions.diatonic_chords_RegExp)
			    		  && currentChord.matches(ARFFFunctions.diatonic_chords_RegExp)){
			    	  //arff.addData(prevNote + "," + prevChord + "," + currentNote + ","+ currentChord);
			    	  bnw.setEvidence(0, pprevNote);
			    	  bnw.setEvidence(1, pprevChord);
			    	  bnw.setEvidence(2, prevNote);
			    	  bnw.setEvidence(3, prevChord);
			    	  //bnw.setEvidence(2, currentNote);
			    	  bnw.update();
			    	  countTrial++;
			    	  String inf1 = bnw.getHighestMarginName(5);
			    	  String inf2 = bnw.getRankedMarginName(5, 2);
			    	  String inf3 = bnw.getRankedMarginName(5, 3);
			    	  
			    	  System.out.println("ppN:"+pprevNote+"  ppC:"+pprevChord+"  pN:"+prevNote+"  pC:"+prevChord+"  (Fact: "+currentChord+"  Inf:"+inf1+")  Follows:"+inf2+" "+inf3);
			    	  //System.out.println("Example: "+currentChord+"\tInference: "+inf1+"\tpNote: "+prevNote+"  cNote: "+currentNote+"\tFollowing Inference: "+inf2+", "+inf3);
			    	  
			    	  //System.out.println("prevNote: "+prevNote+"currentNote: "+currentNote);
			    	  if(currentChord.equals(inf1)){
			    		  countCorrect++;	//結果と事例が等しければカウント
			    	  }
			    	  else{
			    		  countFailed++;
			    		  
			    		  if(currentChord.equals(inf2)){
			    			  countInf2++;
			    		  }
			    		  else if(currentChord.equals(inf3)){
			    			  countInf3++;
			    		  }
			    		  
			    		  if(cc.getPrefix(currentChord).equals(cc.getPrefix(inf1))){
				    		  countSamePrefix++;	//コードの先頭が等しければカウント
				    	  }
				    	  
			    	  }
			    	  
			    	  
			      }
			      
			      //prevNote = currentNote;
			      //pprevNote = prevNote;
			      prevNote = -1;
			      for(Note n : scc.getPartList()[0].getNoteList()){
			    	  if(n.onset() < a.offset()){
			    		  pprevNote = prevNote;
			    		  prevNote = n.notenum();
			    	  }
			    	  else{
			    		  break;
			    	  }
			      }
			      if(prevNote == -1 || pprevNote == -1){
			    	  continue;
			      }
			      else{
			    	  prevNote %= 12;
			    	  prevNote = cc.noteTransfer(musickey, prevNote);
			    	  pprevNote %= 12;
			    	  pprevNote = cc.noteTransfer(musickey, pprevNote);
			      }
			      
			      pprevChord = prevChord;
			      prevChord = currentChord;
			}
			
			totalTrial += countTrial;
			totalCorrect += countCorrect;
			totalInf2 += countInf2;
			totalInf3 += countInf3;
			totalFailed += countFailed;
			totalSamePrefix += countSamePrefix;
			
			System.out.println(filename+" -- Trial :"+countTrial+"\tCorrect: "+countCorrect+"\tFailed: "+countFailed
					+"  (Match2nd: "+countInf2+"  Match3rd: "+countInf3+"  SamePrefix: "+countSamePrefix+")\n");
			
		}
		catch(Exception e){
			e.printStackTrace();
		}
		
	}
	
	public void printTotalCounter(){
		System.out.println("----------- TOTAL ---------");
		System.out.println("Trial: "+totalTrial+"\tCorrect: "+totalCorrect+"\tFailed: "+totalFailed+"\n(Match2nd: "+totalInf2+"  Match3rd: "+totalInf3+"  SamePrefix: "+totalSamePrefix+")");
		System.out.println("SuccessRate: "+((double)totalCorrect/(double)totalTrial)*100+" %"+"\tMatch in 3rd Range: "+(double)(totalCorrect+totalInf2+totalInf3)/(double)totalTrial*100+"%");
	}

	public static void main(String[] args){
		
		
		//String biffile = "080626model.bif";
		String biffile = "080811model3_NCtoNN.bif";
		Checker080811model3 bic = new Checker080811model3(biffile);
		System.out.println("--- "+biffile+" loaded. ---");
		//bic.checkSCCXML("funkyxml//sample018.xml");
		//bic.checkSCCXML("funkyxml//j1_001.xml");

		

		String[] filenames = {"j1_001.xml", "j1_002.xml", "j1_003.xml", "j1_004.xml", "j1_005.xml", "j1_006.xml", "j1_007.xml", "j1_008.xml", "j1_009.xml", "j1_010.xml", "j1_011.xml", "j1_012.xml", "j1_013.xml", "j1_014.xml", "j1_015.xml", "j1_016.xml", "j1_017.xml", "j1_018.xml", "j1_019.xml", "j1_020.xml", "j1_021.xml", "j1_022.xml", "j1_023.xml", "j1_024.xml", "j1_025.xml", "j1_026.xml", "j1_027.xml", "j1_028.xml", "j1_029.xml", "j1_030.xml", "j1_031.xml", "j1_032.xml", "j1_033.xml", "j1_034.xml", "j1_035.xml", "j1_036.xml", "j1_037.xml", "j1_038.xml", "j1_039.xml", "j1_040.xml", "j1_041.xml", "j1_042.xml", "j1_043.xml", "j1_044.xml", "j1_045.xml", "j1_046.xml", "j1_047.xml", "j1_048.xml", "j1_049.xml", "j1_050.xml", "j1_051.xml", "j1_052.xml", "j1_053.xml", "j1_054.xml", "j1_055.xml", "j1_056.xml", "j1_057.xml", "j1_058.xml", "j1_059.xml", "j1_060.xml", "j1_061.xml", "j1_062.xml", "j1_063.xml", "j1_064.xml", "j1_065.xml", "j1_066.xml", "j1_067.xml", "j1_068.xml", "j1_069.xml", "j1_070.xml", "j1_071.xml", "j1_072.xml", "j1_073.xml", "j1_074.xml", "j1_075.xml", "j1_076.xml", "j1_077.xml", "j1_078.xml", "j1_079.xml", "j1_080.xml", "j1_081.xml", "j1_082.xml", "j1_083.xml", "j1_084.xml", "j1_085.xml", "j1_086.xml", "j1_087.xml", "j1_088.xml", "j1_089.xml", "j1_090.xml", "j1_091.xml", "j1_092.xml", "j1_093.xml", "j1_094.xml", "j1_095.xml", "j1_096.xml", "j1_097.xml", "j1_098.xml", "j1_099.xml", "j1_100.xml", "j1_101.xml", "j1_102.xml", "j1_103.xml", "j1_104.xml", "j1_105.xml", "j1_106.xml", "j1_107.xml", "j1_108.xml", "j1_109.xml", "j1_110.xml", "j1_111.xml", "j1_112.xml", "j1_113.xml", "j1_114.xml", "j1_115.xml", "j1_116.xml", "j1_117.xml", "j1_118.xml", "j1_119.xml", "j1_120.xml", "j1_121.xml", "j1_122.xml", "j1_123.xml", "j1_124.xml", "j1_125.xml", "j1_126.xml", "j1_127.xml", "j1_128.xml", "j1_129.xml", "j1_130.xml", "j1_131.xml", "j1_132.xml", "j1_133.xml", "j1_134.xml", "j1_135.xml", "j1_136.xml", "j1_137.xml", "j1_138.xml", "j1_140.xml", "j1_141.xml", "j1_142.xml", "j1_143.xml", "j1_145.xml", "j1_146.xml", "j1_147.xml", "j1_148.xml", "j1_149.xml", "j1_150.xml", "j1_151.xml", "j1_152.xml", "j1_153.xml", "j1_154.xml", "j1_155.xml", "j1_156.xml", "j1_157.xml", "j1_158.xml", "j1_159.xml", "j1_160.xml", "j1_161.xml", "j1_162.xml", "j1_163.xml", "j1_164.xml", "j1_165.xml", "j1_166.xml", "j1_167.xml", "j1_168.xml", "j1_169.xml", "j1_170.xml", "j1_171.xml", "j1_172.xml", "j1_173.xml", "j1_174.xml", "j1_175.xml", "j1_176.xml", "j1_177.xml", "j1_188.xml", "j1_189.xml", "j1_190.xml", "j1_191.xml", "j1_192.xml", "j1_193.xml", "j1_194.xml", "j1_195.xml", "j1_196.xml", "j1_197.xml", "j1_198.xml", "j1_199.xml", "j1_200.xml", "j1_201.xml", "j1_202.xml", "j1_203.xml", "j1_204.xml", "j1_205.xml", "j1_206.xml", "j1_207.xml", "j1_208.xml", "j1_209.xml", "sample001.xml", "sample002.xml", "sample003.xml", "sample004.xml", "sample005.xml", "sample006.xml", "sample007.xml", "sample008.xml", "sample009.xml", "sample010.xml", "sample011.xml", "sample012.xml", "sample013.xml", "sample014.xml", "sample015.xml", "sample016.xml", "sample017.xml", "sample018.xml", "sample019.xml", "sample020.xml", "sample021.xml", "sample022.xml", "sample023.xml", "sample024.xml", "sample025.xml", "sample026.xml", "sample027.xml", "sample028.xml", "sample029.xml", "sample030.xml", "sample031.xml", "sample032.xml", "sample033.xml", "sample034.xml", "sample035.xml", "sample036.xml", "sample037.xml", "sample039.xml", "sample040.xml", "sample041.xml", "sample042.xml", "sample043.xml", "sample044.xml", "sample045.xml", "sample046.xml", "sample047.xml", "sample048.xml", "sample049.xml", "sample050.xml", "sample051.xml", "sample052.xml", "sample053.xml", "sample054.xml", "sample055.xml", "sample056.xml", "sample057.xml", "sample058.xml", "sample059.xml", "sample060.xml", "sample061.xml", "sample062.xml", "sample063.xml", "sample064.xml", "sample065.xml", "sample066.xml", "sample067.xml", "sample068.xml", "sample069.xml", "sample070.xml", "sample071.xml", "sample072.xml", "sample073.xml", "sample075.xml", "sample076.xml", "sample077.xml", "sample078.xml", "sample079.xml", "sample080.xml", "sample081.xml", "sample082.xml", "sample083.xml", "sample084.xml", "sample085.xml", "sample086.xml", "sample087.xml", "sample088.xml", "sample089.xml", "sample090.xml", "sample091.xml", "sample092.xml", "sample093.xml", "sample094.xml", "sample095.xml", "sample096.xml", "sample099.xml", "sample100.xml", "sample101.xml", "sample102.xml", "sample104.xml", "sample105.xml", "sample106.xml", "sample107.xml", "sample108.xml", "sample109.xml", "sample110.xml", "sample111.xml", "sample112.xml", "sample113.xml", "sample114.xml", "sample115.xml", "sample116.xml", "sample117.xml", "sample118.xml", "sample119.xml", "sample120.xml", "sample121.xml", "sample122.xml", "sample123.xml", "sample124.xml", "sample125.xml", "sample126.xml", "sample127.xml", "sample128.xml", "sample129.xml", "sample130.xml", "sample131.xml", "sample132.xml", "sample133.xml", "sample134.xml", "sample135.xml", "sample136.xml", "sample137.xml", "sample138.xml", "sample139.xml", "sample140.xml", "sample141.xml", "sample142.xml", "sample143.xml", "sample144.xml", "sample145.xml", "sample146.xml", "sample147.xml", "sample148.xml", "sample149.xml", "sample150.xml", "sample151.xml", "sample152.xml", "sample153.xml", "sample154.xml", "sample155.xml", "sample156.xml", "sample157.xml", "sample158.xml", "sample159.xml", "sample160.xml", "sample162.xml", "sample163.xml", "sample164.xml", "sample165.xml", "sample166.xml", "sample167.xml", "sample168.xml", "sample169.xml", "sample170.xml", "sample171.xml", "sample172.xml", "sample173.xml", "sample174.xml", "sample175.xml", "sample176.xml", "sample177.xml", "sample178.xml", "sample179.xml", "sample180.xml", "sample181.xml", "sample182.xml", "sample183.xml", "sample184.xml", "sample185.xml", "sample186.xml", "sample187.xml", "sample188.xml", "sample189.xml", "sample190.xml", "sample191.xml", "sample192.xml", "sample193.xml", "sample194.xml", "sample195.xml", "sample196.xml", "sample197.xml", "sample198.xml", "sample199.xml", "sample200.xml", "sample201.xml", "sample202.xml", "sample203.xml", "sample204.xml", "sample205.xml", "sample206.xml", "sample207.xml", "sample208.xml"};
		
		for(String f : filenames){
			bic.checkSCCXML("funkyxml//"+f);
		}
		

		bic.printTotalCounter();
	}
}

