/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.commands;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.amusaj.filewrappers.AmusaDataSet;
import jp.crestmuse.cmx.amusaj.filewrappers.AmusaDataSetCompatible;
import jp.crestmuse.cmx.amusaj.filewrappers.AudioDataCompatible;
import jp.crestmuse.cmx.amusaj.filewrappers.WAVWrapper;
import jp.crestmuse.cmx.amusaj.sp.SPExecutor;
import jp.crestmuse.cmx.amusaj.sp.WindowSlider;
import jp.crestmuse.cmx.commands.CMXCommand;
import jp.crestmuse.cmx.filewrappers.FileWrapperCompatible;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWAVAnalyzer
extends CMXCommand<WAVWrapper, AmusaDataSetCompatible> {
    protected Map<String, String> params = new HashMap<String, String>();
    private AmusaDataSet dataset = null;

    @Override
    protected boolean setOptionsLocal(String string, String string2) {
        if (string.equals("-winsize")) {
            this.params.put("WINDOW_SIZE", String.valueOf(string2));
            return true;
        }
        if (string.equals("-wintype")) {
            this.params.put("WINDOW_TYPE", String.valueOf(string2));
            return true;
        }
        if (string.equals("-shift")) {
            this.params.put("SHIFT", String.valueOf(string2));
            return true;
        }
        if (string.equals("-ch")) {
            this.params.put("TARGET_CHANNEL", string2);
            return true;
        }
        return false;
    }

    @Override
    protected FileWrapperCompatible readInputData(String string) throws IOException {
        return WAVWrapper.readfile(string);
    }

    @Override
    protected AmusaDataSetCompatible run(WAVWrapper wAVWrapper) throws IOException, ParserConfigurationException, TransformerException, SAXException {
        WindowSlider windowSlider = new WindowSlider();
        windowSlider.setParams(this.params);
        windowSlider.setInputData(wAVWrapper);
        int n = windowSlider.getTimeUnit();
        SPExecutor sPExecutor = new SPExecutor(this.params, n);
        return this.analyzeWaveform(wAVWrapper, windowSlider, sPExecutor);
    }

    protected abstract AmusaDataSetCompatible analyzeWaveform(AudioDataCompatible var1, WindowSlider var2, SPExecutor var3) throws IOException, ParserConfigurationException, TransformerException, SAXException;

    static {
        AbstractWAVAnalyzer.addOptionHelpMessage("-winsize <winsize>", "window size in STFT");
        AbstractWAVAnalyzer.addOptionHelpMessage("-wintype {hamming|hanning|gaussian}", "window type in STFT");
        AbstractWAVAnalyzer.addOptionHelpMessage("-shift <value>", "shift size in STFT");
        AbstractWAVAnalyzer.addOptionHelpMessage("-ch <nn>", "target channel");
    }
}

