/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import java.util.Map;
import jp.crestmuse.cmx.amusaj.filewrappers.PeakSet;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.sp.F0PDFCalculator;
import jp.crestmuse.cmx.amusaj.sp.F0PDFCalculatorFactory;
import jp.crestmuse.cmx.amusaj.sp.SPDoubleArray;
import jp.crestmuse.cmx.amusaj.sp.SPElement;
import jp.crestmuse.cmx.amusaj.sp.SPModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class F0PDFCalculatorModule
extends SPModule {
    private F0PDFCalculatorFactory factory = F0PDFCalculatorFactory.getFactory();
    private F0PDFCalculator f0calc;
    private boolean paramSet = false;
    private double nnFrom;
    private double nnThru;
    private double step;
    private String filterName = null;
    private PeakSet.Filter filter = null;

    @Override
    protected String getParamCategory() {
        return "f0pdf";
    }

    @Override
    protected String[] getUsedParamNames() {
        return new String[]{"NOTENUMBER_FROM", "NOTENUMBER_THRU", "STEP"};
    }

    @Override
    public void setParams(Map<String, String> map) {
        super.setParams(map);
        this.copyParamsFromConfigXML("param", "f0pdf", "NOTENUMBER_FROM", "NOTENUMBER_THRU", "STEP");
        if (map.containsKey("FILTER_NAME")) {
            this.filterName = map.get("FILTER_NAME");
            this.copyParamsFromConfigXML("filters", this.filterName, "LOW_CUT_FILTER", "LOW_CUT_BUTTOM", "LOW_CUT_TOP", "HIGH_CUT_FILTER", "HIGH_CUT_TOP", "HIGH_CUT_BUTTOM");
        }
        this.paramSet = false;
    }

    private void setParams() {
        this.nnFrom = this.getParamDouble("NOTENUMBER_FROM");
        this.nnThru = this.getParamDouble("NOTENUMBER_THRU");
        this.step = this.getParamDouble("STEP");
        this.f0calc = this.factory.createCalculator(this.nnFrom, this.nnThru, this.step);
        if (this.filterName != null) {
            this.filter = PeakSet.getFilter(this.getParam("LOW_CUT_FILTER").equals("on"), this.getParamDouble("LOW_CUT_BUTTOM"), this.getParamDouble("LOW_CUT_TOP"), this.getParam("HIGH_CUT_FILTER").equals("on"), this.getParamDouble("HIGH_CUT_TOP"), this.getParamDouble("HIGH_CUT_BUTTOM"));
        }
        this.paramSet = true;
    }

    @Override
    public void execute(SPElement[] sPElementArray, TimeSeriesCompatible<SPElement>[] timeSeriesCompatibleArray) throws InterruptedException {
        if (!this.paramSet) {
            this.setParams();
        }
        PeakSet peakSet = (PeakSet)sPElementArray[0];
        if (this.filter != null) {
            peakSet.filter(this.filter);
        }
        timeSeriesCompatibleArray[0].add(new SPDoubleArray(this.f0calc.calcWeights(peakSet)));
    }

    @Override
    public Class<SPElement>[] getInputClasses() {
        return new Class[]{PeakSet.class};
    }

    @Override
    public Class<SPElement>[] getOutputClasses() {
        return new Class[]{SPDoubleArray.class};
    }
}

