/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.gui.deveditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import javax.sound.midi.InvalidMidiDataException;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.gui.deveditor.CompiledDeviation;
import jp.crestmuse.cmx.gui.deveditor.CorePlayer;
import jp.crestmuse.cmx.gui.deveditor.PianoRollPanel;
import jp.crestmuse.cmx.sound.MusicPlaySynchronized;
import jp.crestmuse.cmx.sound.MusicPlaySynchronizer;

public class GUI
implements MusicPlaySynchronized {
    private static GUI instance;
    private CorePlayer corePlayer = new CorePlayer();
    private MusicPlaySynchronizer synchronizer = new MusicPlaySynchronizer(this.corePlayer);
    private boolean showAsTickTime;
    private JMenuItem openMenuItem;
    private JCheckBoxMenuItem tempoMenuItem;
    private JComboBox comboBox;
    private ArrayList<PianoRollPanel> pianoRollPanels;
    private PianoRollPanel showingPanel;
    private JScrollPane scrollPane;
    private JFrame mainFrame;
    private JSlider currentPositionSlider;

    public static GUI Instance() {
        return instance;
    }

    private GUI() {
        this.synchronizer.addSynchronizedComponent(this);
        this.showAsTickTime = true;
        this.pianoRollPanels = new ArrayList();
        this.mainFrame = new JFrame("DeviationEditor");
        this.mainFrame.setDefaultCloseOperation(3);
        this.mainFrame.setSize(640, 480);
        this.mainFrame.getContentPane().setLayout(new BorderLayout());
        this.setMenuBar();
        this.setScrollPane();
        JPanel jPanel = new JPanel(new FlowLayout());
        this.setList(jPanel);
        this.setSlider(jPanel);
        this.setButtons(jPanel);
        this.mainFrame.getContentPane().add((Component)jPanel, "South");
        this.mainFrame.setVisible(true);
    }

    private void setMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("file");
        this.openMenuItem = new JMenuItem("open");
        this.openMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
                if (jFileChooser.showOpenDialog(GUI.this.mainFrame) == 0) {
                    GUI.this.openMenuItem.setEnabled(false);
                    GUI.this.open(jFileChooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        JMenuItem jMenuItem = new JMenuItem("save");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
                if (jFileChooser.showSaveDialog(GUI.this.mainFrame) == 0) {
                    GUI.this.save(jFileChooser.getSelectedFile());
                }
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem("quit");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jMenu.add(this.openMenuItem);
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        JMenu jMenu2 = new JMenu("show");
        this.tempoMenuItem = new JCheckBoxMenuItem("tempo");
        this.tempoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GUI.this.showingPanel != null) {
                    GUI.this.showingPanel.getTempoFrame().setVisible(GUI.this.tempoMenuItem.isSelected());
                }
            }
        });
        jMenu2.add(this.tempoMenuItem);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        this.mainFrame.setJMenuBar(jMenuBar);
    }

    private void setScrollPane() {
        this.scrollPane = new JScrollPane();
        JSlider jSlider = new JSlider();
        jSlider.setMinimum(PianoRollPanel.WIDTH_PER_BEAT / 2);
        jSlider.setValue(PianoRollPanel.WIDTH_PER_BEAT);
        jSlider.setMaximum(PianoRollPanel.WIDTH_PER_BEAT * 2);
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                PianoRollPanel.WIDTH_PER_BEAT = ((JSlider)changeEvent.getSource()).getValue();
                if (GUI.this.showingPanel != null) {
                    GUI.this.showingPanel.updateScale();
                }
                GUI.this.scrollPane.repaint();
            }
        });
        this.scrollPane.setCorner("LOWER_LEFT_CORNER", jSlider);
        this.scrollPane.setCorner("UPPER_LEFT_CORNER", new JPanel());
        this.scrollPane.setCorner("UPPER_RIGHT_CORNER", new JPanel());
        this.scrollPane.setCorner("LOWER_RIGHT_CORNER", new JPanel());
        this.mainFrame.getContentPane().add((Component)this.scrollPane, "Center");
    }

    private void setList(JPanel jPanel) {
        this.comboBox = new JComboBox();
        this.comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (GUI.this.showingPanel != null) {
                        GUI.this.showingPanel.getTempoFrame().setVisible(false);
                    }
                    int n = ((JComboBox)actionEvent.getSource()).getSelectedIndex();
                    GUI.this.corePlayer.changeDeviation(n);
                    GUI.this.showingPanel = (PianoRollPanel)GUI.this.pianoRollPanels.get(n);
                    GUI.this.showingPanel.updateScale();
                    GUI.this.showingPanel.setScrollPane(GUI.this.scrollPane);
                    Point point = GUI.this.scrollPane.getViewport().getViewPosition();
                    point.y = (((GUI)GUI.this).showingPanel.getPreferredSize().height - GUI.this.scrollPane.getHeight()) / 2;
                    GUI.this.scrollPane.getViewport().setViewPosition(point);
                    if (GUI.this.showAsTickTime) {
                        GUI.this.currentPositionSlider.setMaximum((int)GUI.this.corePlayer.getCurrentSequence().getTickLength());
                    } else {
                        GUI.this.currentPositionSlider.setMaximum((int)GUI.this.corePlayer.getCurrentSequence().getMicrosecondLength());
                    }
                    GUI.this.showingPanel.getTempoFrame().setVisible(GUI.this.tempoMenuItem.isSelected());
                }
                catch (InvalidMidiDataException invalidMidiDataException) {
                    invalidMidiDataException.printStackTrace();
                }
            }
        });
        jPanel.add(this.comboBox);
    }

    private void setSlider(JPanel jPanel) {
        this.currentPositionSlider = new JSlider();
        this.currentPositionSlider.setValue(0);
        this.currentPositionSlider.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (GUI.this.showingPanel == null) {
                    return;
                }
                GUI.this.setPlayPosition(GUI.this.currentPositionSlider.getValue());
            }
        });
        jPanel.add(this.currentPositionSlider);
    }

    private void setButtons(JPanel jPanel) {
        JButton jButton = new JButton("start");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JButton jButton = (JButton)actionEvent.getSource();
                if (GUI.this.synchronizer.isNowPlaying()) {
                    GUI.this.currentPositionSlider.setEnabled(true);
                    GUI.this.synchronizer.stop();
                    jButton.setText("start");
                } else {
                    GUI.this.currentPositionSlider.setEnabled(false);
                    GUI.this.synchronizer.play();
                    jButton.setText("pause");
                }
            }
        });
        JButton jButton2 = new JButton("reset");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUI.this.currentPositionSlider.setEnabled(true);
                GUI.this.synchronizer.stop();
                GUI.this.setPlayPosition(0L);
            }
        });
        JButton jButton3 = new JButton("change");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUI.this.showAsTickTime = !GUI.this.showAsTickTime;
                if (GUI.this.showingPanel != null) {
                    GUI.this.showingPanel.updateNotes();
                    GUI.this.mainFrame.repaint();
                }
                if (GUI.this.showAsTickTime) {
                    GUI.this.currentPositionSlider.setMaximum((int)GUI.this.corePlayer.getCurrentSequence().getTickLength());
                    GUI.this.currentPositionSlider.setValue((int)GUI.this.corePlayer.getTickPosition());
                } else {
                    GUI.this.currentPositionSlider.setMaximum((int)GUI.this.corePlayer.getCurrentSequence().getMicrosecondLength());
                    GUI.this.currentPositionSlider.setValue((int)GUI.this.corePlayer.getMicrosecondPosition());
                }
            }
        });
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
    }

    public void start(MusicPlaySynchronizer musicPlaySynchronizer) {
    }

    public void stop(MusicPlaySynchronizer musicPlaySynchronizer) {
        this.corePlayer.reset();
        this.currentPositionSlider.setEnabled(true);
    }

    public void synchronize(final double d, final long l, MusicPlaySynchronizer musicPlaySynchronizer) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Point point = GUI.this.scrollPane.getViewport().getViewPosition();
                point.x = GUI.this.showingPanel.getPlayPointX(d, l);
                int n = GUI.this.scrollPane.getViewport().getWidth();
                point.x = Math.max(0, Math.min(((GUI)GUI.this).showingPanel.getPreferredSize().width - n, point.x - n / 2));
                GUI.this.scrollPane.getViewport().setViewPosition(point);
                if (GUI.this.showAsTickTime) {
                    GUI.this.currentPositionSlider.setValue((int)l);
                } else {
                    GUI.this.currentPositionSlider.setValue((int)(d * 1000000.0));
                }
            }
        });
        this.showingPanel.repaint();
    }

    public boolean getShowAsTickTime() {
        return this.showAsTickTime;
    }

    public void open(final String string) {
        Thread thread = new Thread(){

            public void run() {
                try {
                    CMXFileWrapper cMXFileWrapper = CMXFileWrapper.readfile(string);
                    CompiledDeviation compiledDeviation = GUI.this.corePlayer.open(cMXFileWrapper);
                    GUI.this.pianoRollPanels.add(new PianoRollPanel(compiledDeviation));
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            GUI.this.comboBox.addItem("dev" + GUI.this.comboBox.getItemCount());
                        }
                    });
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        GUI.this.openMenuItem.setEnabled(true);
                    }
                });
            }
        };
        thread.start();
    }

    public void save(final File file) {
        Thread thread = new Thread(){

            public void run() {
                try {
                    GUI.this.corePlayer.writeFile(new FileOutputStream(file));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        thread.start();
    }

    public void setPlayPosition(long l) {
        if (this.showAsTickTime) {
            this.corePlayer.setTickPosition(l);
        } else {
            this.corePlayer.setMicrosecondPosition(l);
        }
        this.synchronize((double)this.corePlayer.getMicrosecondPosition() / 1000000.0, this.corePlayer.getTickPosition(), null);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                instance = new GUI();
            }
        });
    }
}

