/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.gui.deveditor;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jp.crestmuse.cmx.gui.deveditor.CompiledDeviation;
import jp.crestmuse.cmx.gui.deveditor.GUI;
import jp.crestmuse.cmx.gui.deveditor.NoteEditFrame;
import jp.crestmuse.cmx.gui.deveditor.PrintableDeviatedNote;
import jp.crestmuse.cmx.gui.deveditor.PrintableNote;
import jp.crestmuse.cmx.gui.deveditor.TempoPanel;

public class PianoRollPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    public static int WIDTH_PER_BEAT = 32;
    public static int HEIGHT_PER_NOTE = 16;
    public static int COLUMN_HEADER_HEIGHT = 16;
    private CompiledDeviation compiledDeviation;
    private ArrayList<PrintableDeviatedNote> deviatedNotes;
    private ArrayList<PrintableNote> originalNotes;
    private PrintableDeviatedNote hoverNote;
    private PrintableDeviatedNote.NoteMoveHandle holdNote;
    private ColumnHeaderPanel columnHeader;
    private RowHeaderPanel rowHeader;
    private int playingLine;
    private JFrame tempoFrame;
    private NoteEditFrame noteEditFrame = new NoteEditFrame(this);

    public PianoRollPanel(CompiledDeviation compiledDeviation) {
        this.compiledDeviation = compiledDeviation;
        this.setTempoFrame();
        this.playingLine = 0;
        this.deviatedNotes = new ArrayList();
        this.originalNotes = new ArrayList();
        for (CompiledDeviation.DeviatedNote deviatedNote : compiledDeviation.getDeviatedNotes()) {
            this.deviatedNotes.add(new PrintableDeviatedNote(deviatedNote, this));
            if (deviatedNote.isExtraNote()) continue;
            this.originalNotes.add(new PrintableNote(deviatedNote, this));
        }
        this.holdNote = null;
        int n = (int)compiledDeviation.getSequence().getTickLength();
        int n2 = WIDTH_PER_BEAT * n / CompiledDeviation.TICKS_PER_BEAT;
        this.setPreferredSize(new Dimension(n2, HEIGHT_PER_NOTE * 128));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        int n3 = n / (CompiledDeviation.TICKS_PER_BEAT * 4);
        int n4 = (int)(compiledDeviation.getSequence().getMicrosecondLength() / 1000000L);
        this.columnHeader = new ColumnHeaderPanel(n3, WIDTH_PER_BEAT * 4, n4, n2 / n4, n2, COLUMN_HEADER_HEIGHT);
        this.rowHeader = new RowHeaderPanel();
        this.rowHeader.setPreferredSize(new Dimension(64, HEIGHT_PER_NOTE * 128));
    }

    private void setTempoFrame() {
        this.tempoFrame = new JFrame();
        this.tempoFrame.setSize(320, 256);
        this.tempoFrame.setResizable(false);
        JScrollPane jScrollPane = new JScrollPane();
        TempoPanel tempoPanel = new TempoPanel((int)this.compiledDeviation.getSequence().getTickLength(), this.compiledDeviation.getTicks2Tempo());
        jScrollPane.setViewportView(tempoPanel);
        jScrollPane.setRowHeaderView(tempoPanel.getRowHeader());
        this.tempoFrame.getContentPane().add(jScrollPane);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && this.hoverNote == null && this.holdNote == null) {
            if (GUI.Instance().getShowAsTickTime()) {
                GUI.Instance().setPlayPosition(this.compiledDeviation.getSequence().getTickLength() * (long)mouseEvent.getX() / (long)this.getPreferredSize().width);
            } else {
                GUI.Instance().setPlayPosition(this.compiledDeviation.getSequence().getMicrosecondLength() * (long)mouseEvent.getX() / (long)this.getPreferredSize().width);
            }
        } else if (mouseEvent.getButton() == 3 && this.hoverNote != null) {
            this.noteEditFrame.setNote(this.hoverNote);
            this.noteEditFrame.setLocation(MouseInfo.getPointerInfo().getLocation());
            this.noteEditFrame.setVisible(true);
            this.hoverNote = null;
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() != 1) {
            return;
        }
        for (PrintableDeviatedNote printableDeviatedNote : this.deviatedNotes) {
            this.holdNote = printableDeviatedNote.getHandle(mouseEvent.getX(), mouseEvent.getY());
            if (this.holdNote == null) continue;
            this.hoverNote = null;
            try {
                Point point = MouseInfo.getPointerInfo().getLocation();
                Robot robot = new Robot();
                robot.mouseMove(point.x + this.holdNote.press(mouseEvent.getX()), point.y);
            }
            catch (AWTException aWTException) {
                aWTException.printStackTrace();
            }
            break;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.holdNote != null) {
            this.holdNote.release();
            this.holdNote = null;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.holdNote != null) {
            this.holdNote.drag(mouseEvent.getX());
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.holdNote == null) {
            this.hoverNote = null;
            for (PrintableDeviatedNote printableDeviatedNote : this.deviatedNotes) {
                if (!printableDeviatedNote.isMouseOver(mouseEvent.getX(), mouseEvent.getY())) continue;
                this.hoverNote = printableDeviatedNote;
                if (printableDeviatedNote.isMouseOnRight(mouseEvent.getX(), mouseEvent.getY())) {
                    this.setCursor(Cursor.getPredefinedCursor(11));
                    break;
                }
                this.setCursor(Cursor.getPredefinedCursor(10));
                break;
            }
            if (this.hoverNote == null) {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.setColor(Color.BLACK);
        int n = WIDTH_PER_BEAT * 4;
        if (!GUI.Instance().getShowAsTickTime()) {
            n = 2 * this.getPreferredSize().width / (int)(this.compiledDeviation.getSequence().getMicrosecondLength() / 1000000L);
        }
        for (int i = 0; i < this.getPreferredSize().width; i += n) {
            graphics.drawLine(i, 0, i, this.getHeight());
        }
        for (PrintableNote object : this.originalNotes) {
            object.paint(graphics);
        }
        for (PrintableDeviatedNote printableDeviatedNote : this.deviatedNotes) {
            printableDeviatedNote.print(graphics);
        }
        if (this.hoverNote != null) {
            this.hoverNote.printAsHover(graphics);
        }
        graphics.setColor(Color.BLUE);
        graphics.fillRect(this.playingLine - 1, 0, 3, this.getHeight());
    }

    public CompiledDeviation getCompiledDeviation() {
        return this.compiledDeviation;
    }

    public JFrame getTempoFrame() {
        return this.tempoFrame;
    }

    public int getPlayPointX(double d, long l) {
        this.playingLine = GUI.Instance().getShowAsTickTime() ? (int)((long)this.getPreferredSize().width * l / this.compiledDeviation.getSequence().getTickLength()) : (int)((double)this.getPreferredSize().width * d * 1000000.0 / (double)this.compiledDeviation.getSequence().getMicrosecondLength());
        return this.playingLine;
    }

    public void setScrollPane(JScrollPane jScrollPane) {
        jScrollPane.setViewportView(this);
        jScrollPane.setColumnHeaderView(this.columnHeader);
        jScrollPane.setRowHeaderView(this.rowHeader);
    }

    public void updateScale() {
        int n = (int)this.compiledDeviation.getSequence().getTickLength();
        int n2 = WIDTH_PER_BEAT * n / CompiledDeviation.TICKS_PER_BEAT;
        this.setPreferredSize(new Dimension(n2, HEIGHT_PER_NOTE * 128));
        this.updateNotes();
        this.columnHeader.setPreferredSize(new Dimension(n2, COLUMN_HEADER_HEIGHT));
        this.columnHeader.widthPerMeasure = PianoRollPanel.WIDTH_PER_BEAT * 4;
        int n3 = (int)(this.compiledDeviation.getSequence().getMicrosecondLength() / 1000000L);
        this.columnHeader.widthPerSecond = n2 / n3;
    }

    public void updateNotes() {
        if (GUI.Instance().getShowAsTickTime()) {
            for (PrintableDeviatedNote object : this.deviatedNotes) {
                object.asTickTime();
            }
            for (PrintableNote printableNote : this.originalNotes) {
                printableNote.asTickTime();
            }
        } else {
            for (PrintableDeviatedNote printableDeviatedNote : this.deviatedNotes) {
                printableDeviatedNote.asRealTime();
            }
            for (PrintableNote printableNote : this.originalNotes) {
                printableNote.asRealTime();
            }
        }
    }

    private class RowHeaderPanel
    extends JPanel {
        private RowHeaderPanel() {
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            graphics.setColor(Color.BLACK);
            graphics.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, this.getHeight());
            for (int i = 0; i < 128; ++i) {
                if (i % 12 == 1 || i % 12 == 3 || i % 12 == 6 || i % 12 == 8 || i % 12 == 10) {
                    graphics.drawLine(0, (127 - i) * HEIGHT_PER_NOTE + HEIGHT_PER_NOTE / 2, this.getWidth(), (127 - i) * HEIGHT_PER_NOTE + HEIGHT_PER_NOTE / 2);
                    graphics.fillRect(0, (127 - i) * HEIGHT_PER_NOTE + HEIGHT_PER_NOTE / 4, this.getWidth() / 2, HEIGHT_PER_NOTE / 2);
                    continue;
                }
                if (i % 12 != 0 && i % 12 != 5) continue;
                graphics.drawLine(0, (127 - i + 1) * HEIGHT_PER_NOTE, this.getWidth(), (127 - i + 1) * HEIGHT_PER_NOTE);
            }
        }
    }

    private class ColumnHeaderPanel
    extends JPanel {
        private int measureNum;
        private int widthPerMeasure;
        private int seconds;
        private int widthPerSecond;

        public ColumnHeaderPanel(int n, int n2, int n3, int n4, int n5, int n6) {
            this.measureNum = n;
            this.widthPerMeasure = n2;
            this.seconds = n3;
            this.widthPerSecond = n4;
            this.setPreferredSize(new Dimension(n5, n6));
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            graphics.setColor(Color.BLACK);
            if (GUI.Instance().getShowAsTickTime()) {
                for (int i = 0; i < this.measureNum; ++i) {
                    graphics.drawString(i + 1 + "", i * this.widthPerMeasure, COLUMN_HEADER_HEIGHT);
                }
            } else {
                for (int i = 0; i < this.seconds; i += 2) {
                    graphics.drawString(i / 60 + ":" + i % 60, i * this.widthPerSecond, COLUMN_HEADER_HEIGHT);
                }
            }
        }
    }
}

