/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.gui.sound;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import jp.crestmuse.cmx.filewrappers.MusicXMLWrapper;
import jp.crestmuse.cmx.gui.sound.NoteEvent;
import jp.crestmuse.cmx.gui.sound.SoundUtility;
import jp.crestmuse.cmx.gui.sound.TimeEventMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIDIExpressionDataSet {
    public static int TICKSPERBEAT = 480;
    private static int ON_OFF_RESOLUTION_TIME = 3;
    private static int EVENT_RESOLUTION_TIME = 3;
    private static int OFF_VELOCITY = 127;
    private static boolean DEBUG = false;
    private static LinkedList<NoteEvent> midiEventList;
    private TimeEventMap timeEventMap = new TimeEventMap();
    private int baseBeat = 4;
    private double baseBPM = 120.0;
    private long baseBeatTime = 500L;
    private double maxLength = 0.0;
    private TreeMap<Double, List<Long>> tempoEventMap = new TreeMap();
    private TreeMap<Integer, Long> soundNotesStatus;
    private double selectTimeFrom = 0.0;
    private double selectTimeEnd = 0.0;
    private double performanceLength = 0.0;

    public static MIDIExpressionDataSet createMIDIExpressionDataSet() {
        MIDIExpressionDataSet mIDIExpressionDataSet = new MIDIExpressionDataSet();
        return mIDIExpressionDataSet;
    }

    private MIDIExpressionDataSet() {
        midiEventList = new LinkedList();
        this.soundNotesStatus = new TreeMap();
    }

    void addTempoEventMap(int n, double d, long l) {
        int n2 = n - 1;
        double d2 = (long)((d - 1.0) * 1000.0);
        double d3 = (double)(n2 * this.baseBeat) + d2;
        ArrayList<Long> arrayList = this.tempoEventMap.containsKey(d3) ? this.tempoEventMap.get(d3) : new ArrayList<Long>();
        arrayList.add(l);
        this.tempoEventMap.put(d3, arrayList);
    }

    void createSampleNotes() {
        this.timeEventMap.clear();
        this.tempoEventMap.clear();
        this.addNoteToTimeEventMap("ON", 1, 1.0, 60, 50, 0.5);
        this.addNoteToTimeEventMap("ON", 1, 1.6, 62, 60, 0.5);
        this.addNoteToTimeEventMap("ON", 1, 2.0, 64, 70, 0.5);
        this.addNoteToTimeEventMap("ON", 1, 2.5, 65, 80, 0.5);
        this.addNoteToTimeEventMap("ON", 1, 3.0, 67, 90, 1.0);
        this.addNoteToTimeEventMap("ON", 1, 4.0, 74, 64, 1.0);
        this.addNoteToTimeEventMap("ON", 2, 1.0, 72, 64, 1.0);
        this.addTempoEventMap(1, 1.0, 400L);
        this.addTempoEventMap(1, 2.0, 600L);
        this.addTempoEventMap(1, 3.0, 400L);
        this.addTempoEventMap(1, 4.0, 600L);
        this.addTempoEventMap(1, 5.0, 400L);
        this.addNoteOffEvents();
        System.out.println(this.timeEventMap.toString());
        System.out.println("Time event map: (maxlength: " + this.maxLength + ")");
        this.setDeltaTimes();
    }

    final int getBaseBeat() {
        return this.baseBeat;
    }

    final double getBaseBeatTime() {
        return this.baseBeatTime;
    }

    final double getBPM() {
        return this.baseBPM;
    }

    final double getMaxLength() {
        return this.maxLength;
    }

    final List<NoteEvent> getMidiEventList() {
        return midiEventList;
    }

    final List<MidiMessage> getMidiMessageList(double d, double d2) {
        NoteEvent noteEvent;
        LinkedList<MidiMessage> linkedList = new LinkedList<MidiMessage>();
        Iterator iterator = midiEventList.iterator();
        while (iterator.hasNext() && !((double)(noteEvent = (NoteEvent)iterator.next()).getOnset() >= d2)) {
            if ((double)noteEvent.getOnset() < d) continue;
            linkedList.add(noteEvent.getMidiMessage());
        }
        return linkedList;
    }

    double getPerformanceLength() {
        return this.performanceLength;
    }

    TimeEventMap getTimeEventMap() {
        return this.timeEventMap;
    }

    public TimeEventMap getTimeEventMapIn(double d, double d2) {
        TimeEventMap timeEventMap = (TimeEventMap)this.timeEventMap.subMap(d, d2);
        TimeEventMap timeEventMap2 = new TimeEventMap();
        Iterator iterator = timeEventMap.keySet().iterator();
        while (iterator.hasNext()) {
            double d3 = (Double)iterator.next();
            timeEventMap2.put(d3 - d, timeEventMap.get(d3));
        }
        return timeEventMap2;
    }

    void resetSelectingGroup() {
        this.selectTimeFrom = 0.0;
        this.selectTimeEnd = this.getPerformanceLength();
    }

    void setBaseBeat(int n, int n2) {
        this.baseBeat = (int)((double)n / ((double)n2 / 4.0));
    }

    void setBaseBeatTime(double d) {
        this.baseBeatTime = (int)d;
        this.baseBPM = SoundUtility.beatTimeToBPM(d);
    }

    void setBPM(double d) {
        this.baseBPM = d;
        this.baseBeatTime = (int)SoundUtility.bpmToBeatTime(d);
    }

    void setDefaultTempo() {
        this.tempoEventMap.clear();
        int n = (int)this.maxLength;
        for (int i = 0; i < n; ++i) {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            arrayList.add(this.baseBeatTime);
            this.tempoEventMap.put(Double.valueOf(i), arrayList);
        }
    }

    synchronized void setMIDIEventList(TimeEventMap timeEventMap) {
        midiEventList.clear();
        if (DEBUG) {
            System.err.println("==== Set MIDI Event list ====");
        }
        Iterator iterator = timeEventMap.keySet().iterator();
        while (iterator.hasNext()) {
            double d = (Double)iterator.next();
            if (d < this.selectTimeFrom || d > this.selectTimeEnd) continue;
            for (NoteEvent noteEvent : (LinkedList)timeEventMap.get(d)) {
                if (DEBUG) {
                    System.out.println(noteEvent);
                }
                int n = 0;
                if (noteEvent.getMessageType().equals("ON")) {
                    n = 144;
                    this.soundNotesStatus.put(noteEvent.getNoteNum(), noteEvent.getOnset());
                } else if (noteEvent.getMessageType().equals("OFF")) {
                    n = 128;
                    if (this.soundNotesStatus.containsKey(noteEvent.getNoteNum())) {
                        this.soundNotesStatus.remove(noteEvent.getNoteNum());
                    }
                } else {
                    System.err.println("??? status=" + n);
                }
                ShortMessage shortMessage = new ShortMessage();
                try {
                    shortMessage.setMessage(n, noteEvent.getNoteNum(), noteEvent.getVelocity());
                }
                catch (InvalidMidiDataException invalidMidiDataException) {
                    invalidMidiDataException.printStackTrace();
                }
                noteEvent.setMidiMessge(shortMessage);
                midiEventList.add(noteEvent);
                if (!DEBUG) continue;
                System.err.println("   ontime " + noteEvent.getOnset() + " note " + shortMessage.getData1() + " " + noteEvent.getMessageType() + " length " + noteEvent.getLength());
            }
        }
        this.expandMIDIEvents();
        if (DEBUG) {
            System.err.println("==== (end) MIDI Event list ====");
        }
    }

    private synchronized void addNoteOffEvents() {
        TimeEventMap timeEventMap = new TimeEventMap();
        Iterator iterator = this.timeEventMap.keySet().iterator();
        while (iterator.hasNext()) {
            double d = (Double)iterator.next();
            for (NoteEvent noteEvent : (LinkedList)this.timeEventMap.get(d)) {
                List<NoteEvent> list;
                if (noteEvent.getMessageType().equals("OFF")) continue;
                double d2 = SoundUtility.castDouble(noteEvent.getBeatOnset() + noteEvent.getLength());
                double d3 = d2 - (double)noteEvent.getMeasure();
                if (this.timeEventMap.containsKey(d2)) {
                    list = (LinkedList<NoteEvent>)this.timeEventMap.get(d2);
                    list.add(0, new NoteEvent("OFF", noteEvent.getMeasure(), d3, noteEvent.getNoteNum(), OFF_VELOCITY, 0.0, this.getBaseBeat()));
                } else if (timeEventMap.containsKey(d2)) {
                    list = (List)timeEventMap.get(d2);
                    list.add(0, new NoteEvent("OFF", noteEvent.getMeasure(), d3, noteEvent.getNoteNum(), OFF_VELOCITY, 0.0, this.getBaseBeat()));
                } else {
                    list = new LinkedList<NoteEvent>();
                    ((LinkedList)list).add(0, new NoteEvent("OFF", noteEvent.getMeasure(), d3, noteEvent.getNoteNum(), OFF_VELOCITY, 0.0, this.getBaseBeat()));
                    timeEventMap.put(d2, list);
                }
                if (!(this.maxLength < d2)) continue;
                this.maxLength = d2;
            }
        }
        this.timeEventMap.putAll(timeEventMap);
    }

    private synchronized void addNoteToTimeEventMap(String string, int n, double d, int n2, int n3, double d2) {
        int n4 = n - 1;
        double d3 = SoundUtility.castDouble(d - 1.0);
        double d4 = (double)(n4 * this.baseBeat) + d3;
        LinkedList linkedList = this.timeEventMap.containsKey(d4) ? (LinkedList)this.timeEventMap.get(d4) : new LinkedList();
        linkedList.add(new NoteEvent(string, n4, d3, n2, n3, d2, this.getBaseBeat()));
        this.timeEventMap.put(d4, linkedList);
        if (this.maxLength < d4 + d2) {
            this.maxLength = d4 + d2;
        }
    }

    private synchronized void expandMIDIEvents() {
        if (DEBUG) {
            System.out.println("======== expandMIDIEvents ============");
        }
        NoteEvent noteEvent = null;
        for (NoteEvent noteEvent2 : midiEventList) {
            if (noteEvent != null && noteEvent2.getOnset() - noteEvent.getOnset() < (long)EVENT_RESOLUTION_TIME) {
                noteEvent2.setOnset(noteEvent.getOnset() + (long)EVENT_RESOLUTION_TIME);
            }
            if (DEBUG) {
                System.out.println("time=" + noteEvent2.getOnset() + " note " + noteEvent2.getNoteNum() + " " + noteEvent2.getMessageType() + " onset=" + noteEvent2.getOnset() + " length=" + noteEvent2.getLength());
            }
            noteEvent = noteEvent2;
        }
        if (DEBUG) {
            System.out.println("======== (end) expandMIDIEvents ============");
        }
    }

    private <N> double getNoteEventOnset(N n) {
        if (n instanceof MusicXMLWrapper.Note) {
            MusicXMLWrapper.Note note = (MusicXMLWrapper.Note)n;
            for (Double d : this.timeEventMap.keySet()) {
                for (NoteEvent noteEvent : (LinkedList)this.timeEventMap.get(d)) {
                    if (note.measure().number() != noteEvent.getMeasure() + 1 || note.beat() != noteEvent.getBeat() + 1.0 || note.notenum() != noteEvent.getNoteNum()) continue;
                    return noteEvent.getBeatOnset();
                }
            }
            return -1.0;
        }
        throw new UnsupportedClassVersionError("note is an instance of " + n.getClass().getName());
    }

    private NoteEvent getNoteOffEvent(NoteEvent noteEvent, double d, int n) {
        Iterator iterator = this.timeEventMap.keySet().iterator();
        while (iterator.hasNext()) {
            double d2 = (Double)iterator.next();
            if (d2 < d) continue;
            if (d2 > d + SoundUtility.millisecondToBeatLength(n, this.getBPM())) break;
            for (NoteEvent noteEvent2 : (LinkedList)this.timeEventMap.get(d2)) {
                if (noteEvent2.getMessageType().equals("ON")) continue;
                long l = noteEvent2.getOnset() - noteEvent.getOnset();
                if (noteEvent2.getNoteNum() != noteEvent.getNoteNum() || l <= (long)(-n) || l >= (long)n) continue;
                return noteEvent2;
            }
        }
        return null;
    }

    private synchronized void setDeltaTimes() {
        int n = (int)this.maxLength;
        int n2 = 0;
        if (DEBUG) {
            System.out.println("======== setDeltaTimes ============");
        }
        for (int i = ((Double)this.timeEventMap.firstKey()).intValue(); i < n; ++i) {
            int n3 = (int)this.getBaseBeatTime();
            Iterator iterator = this.timeEventMap.keySet().iterator();
            while (iterator.hasNext()) {
                double d = (Double)iterator.next();
                if (d < (double)i) continue;
                if (d >= (double)(i + 1)) break;
                List list = (List)this.timeEventMap.get(d);
                for (NoteEvent noteEvent : list) {
                    if (noteEvent.getOnset() >= 0L) continue;
                    noteEvent.setOnset((long)((double)n2 + (double)n3 * (d - (double)i)));
                    if (!DEBUG) continue;
                    System.out.println("mstime=" + noteEvent.getOnset() + " note " + noteEvent.getNoteNum() + " " + noteEvent.getMessageType() + " onset=" + noteEvent.getOnset() + " length=" + noteEvent.getLength());
                }
            }
            this.selectTimeEnd = n2 += n3;
            this.setPerformanceLength(this.selectTimeEnd);
        }
        if (this.timeEventMap.containsKey(n)) {
            for (NoteEvent noteEvent : (LinkedList)this.timeEventMap.get(n)) {
                if (noteEvent.getOnset() >= 0L) continue;
                noteEvent.setOnset(n2);
                if (!DEBUG) continue;
                System.out.println("time=" + noteEvent.getOnset() + " note " + noteEvent.getNoteNum() + " " + noteEvent.getMessageType() + " onset=" + noteEvent.getOnset() + " length=" + noteEvent.getLength());
            }
        }
        if (DEBUG) {
            System.out.println("======== (end) setDeltaTimes ============");
        }
    }

    private void setPerformanceLength(double d) {
        this.performanceLength = d;
    }

    private synchronized void switchOFFEvents() {
        double d;
        if (DEBUG) {
            System.out.println("======== switchOFFEvents ============");
        }
        Iterator iterator = this.timeEventMap.keySet().iterator();
        while (iterator.hasNext()) {
            d = (Double)iterator.next();
            if (d < this.selectTimeFrom || d > this.selectTimeEnd) continue;
            for (NoteEvent noteEvent : (LinkedList)this.timeEventMap.get(d)) {
                NoteEvent noteEvent2;
                if (!noteEvent.getMessageType().equals("ON")) continue;
                while ((noteEvent2 = this.getNoteOffEvent(noteEvent, d, ON_OFF_RESOLUTION_TIME)) != null) {
                    noteEvent2.setOnset(noteEvent.getOnset() - (long)ON_OFF_RESOLUTION_TIME);
                }
            }
        }
        if (DEBUG) {
            iterator = this.timeEventMap.keySet().iterator();
            while (iterator.hasNext()) {
                d = (Double)iterator.next();
                for (NoteEvent noteEvent : (LinkedList)this.timeEventMap.get(d)) {
                    System.out.println("time=" + noteEvent.getOnset() + " note " + noteEvent.getNoteNum() + " " + noteEvent.getMessageType() + " onset=" + noteEvent.getOnset() + " length=" + noteEvent.getLength());
                }
            }
            System.out.println("======== (end) switchOFFEvents ============");
        }
    }
}

