/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.commands;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.amusaj.commands.AbstractWAVAnalyzer;
import jp.crestmuse.cmx.amusaj.filewrappers.AmusaDataSet;
import jp.crestmuse.cmx.amusaj.filewrappers.AmusaDataSetCompatible;
import jp.crestmuse.cmx.amusaj.filewrappers.AudioDataCompatible;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.sp.PeakExtractor;
import jp.crestmuse.cmx.amusaj.sp.SPElement;
import jp.crestmuse.cmx.amusaj.sp.SPExecutor;
import jp.crestmuse.cmx.amusaj.sp.STFT;
import jp.crestmuse.cmx.amusaj.sp.WindowSlider;
import org.xml.sax.SAXException;

public class ChromaExtractor
extends AbstractWAVAnalyzer {
    protected boolean setOptionsLocal(String string, String string2) {
        if (super.setOptionsLocal(string, string2)) {
            return true;
        }
        if (string.startsWith("-l")) {
            this.params.put("CHROMA_LOW_LIMIT_FREQ", string2);
            return true;
        }
        if (string.startsWith("-h")) {
            this.params.put("CHROMA_HIGH_LIMIT_FREQ", string2);
            return true;
        }
        return false;
    }

    protected AmusaDataSetCompatible analyzeWaveform(AudioDataCompatible audioDataCompatible, WindowSlider windowSlider, SPExecutor sPExecutor) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        sPExecutor.addSPModule(windowSlider);
        STFT sTFT = new STFT();
        sPExecutor.addSPModule(sTFT);
        PeakExtractor peakExtractor = new PeakExtractor();
        sPExecutor.addSPModule(peakExtractor);
        int n = windowSlider.getOutputClasses().length;
        for (int i = 0; i < n; ++i) {
            sPExecutor.connect(windowSlider, i, sTFT, i);
            sPExecutor.connect(sTFT, i, peakExtractor, i);
        }
        jp.crestmuse.cmx.amusaj.sp.ChromaExtractor chromaExtractor = new jp.crestmuse.cmx.amusaj.sp.ChromaExtractor();
        sPExecutor.addSPModule(chromaExtractor);
        sPExecutor.connect(peakExtractor, 0, chromaExtractor, 0);
        sPExecutor.start();
        TimeSeriesCompatible<SPElement> timeSeriesCompatible = sPExecutor.getResult(chromaExtractor).get(0);
        AmusaDataSet<TimeSeriesCompatible<SPElement>> amusaDataSet = new AmusaDataSet<TimeSeriesCompatible<SPElement>>("array", sPExecutor.getParams());
        amusaDataSet.add(timeSeriesCompatible);
        return amusaDataSet;
    }

    public static void main(String[] stringArray) {
        ChromaExtractor chromaExtractor = new ChromaExtractor();
        try {
            chromaExtractor.start(stringArray);
        }
        catch (Exception exception) {
            chromaExtractor.showErrorMessage(exception);
            System.exit(1);
        }
    }

    static {
        ChromaExtractor.addOptionHelpMessage("-l <freq>", "lower bound frequency for analysis");
        ChromaExtractor.addOptionHelpMessage("-h <freq>", "upper bound frequency for analysis");
    }
}

