/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.commands;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.amusaj.commands.AbstractWAVAnalyzer;
import jp.crestmuse.cmx.amusaj.filewrappers.AmusaDataSet;
import jp.crestmuse.cmx.amusaj.filewrappers.AmusaDataSetCompatible;
import jp.crestmuse.cmx.amusaj.filewrappers.AmusaScriptWrapper;
import jp.crestmuse.cmx.amusaj.filewrappers.AudioDataCompatible;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.sp.ProducerConsumerCompatible;
import jp.crestmuse.cmx.amusaj.sp.SPElement;
import jp.crestmuse.cmx.amusaj.sp.SPExecutor;
import jp.crestmuse.cmx.amusaj.sp.WindowSlider;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import org.xml.sax.SAXException;

public class WAVAnalyzer
extends AbstractWAVAnalyzer {
    private String scriptName;
    private AmusaScriptWrapper script;

    protected boolean setOptionsLocal(String string, String string2) {
        if (super.setOptionsLocal(string, string2)) {
            return true;
        }
        if (string.equals("-script")) {
            this.scriptName = string2;
            return true;
        }
        return false;
    }

    protected void preproc() throws IOException {
        String[] stringArray;
        this.script = (AmusaScriptWrapper)CMXFileWrapper.readfile(this.scriptName);
        for (String string : stringArray = this.script.getParamNameList()) {
            this.params.put(string, this.script.getParam(string));
        }
    }

    protected AmusaDataSetCompatible analyzeWaveform(AudioDataCompatible audioDataCompatible, WindowSlider windowSlider, SPExecutor sPExecutor) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        AmusaScriptWrapper.Output[] outputArray;
        Map<String, String> map = this.script.getModules();
        LinkedHashMap<String, WindowSlider> linkedHashMap = new LinkedHashMap<String, WindowSlider>();
        AmusaScriptWrapper.Connection[] connectionArray = map.entrySet().iterator();
        while (connectionArray.hasNext()) {
            ProducerConsumerCompatible outputArray2;
            Map.Entry<String, String> object2 = connectionArray.next();
            try {
                outputArray2 = object2.getValue().equals("jp.crestmuse.cmx.amusaj.sp.WindowSlider") ? windowSlider : (ProducerConsumerCompatible)Class.forName(object2.getValue()).newInstance();
            }
            catch (ClassNotFoundException illegalAccessException) {
                throw new IllegalStateException("unknown object: " + object2.getValue());
            }
            catch (InstantiationException instantiationException) {
                throw new IllegalStateException("unknown object: " + object2.getValue());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException("unknown object: " + object2.getValue());
            }
            linkedHashMap.put(object2.getKey(), (WindowSlider)outputArray2);
            System.err.println("Added " + outputArray2);
            sPExecutor.addSPModule(outputArray2);
        }
        for (AmusaScriptWrapper.Connection connection : connectionArray = this.script.getConnections()) {
            sPExecutor.connect((ProducerConsumerCompatible)linkedHashMap.get(connection.objFrom), connection.chFrom, (ProducerConsumerCompatible)linkedHashMap.get(connection.objTo), connection.chTo);
            System.err.println("Connected " + linkedHashMap.get(connection.objFrom) + " ch." + connection.chFrom + " to " + linkedHashMap.get(connection.objTo) + " ch." + connection.chTo);
        }
        sPExecutor.start();
        AmusaDataSet<TimeSeriesCompatible<SPElement>> amusaDataSet = new AmusaDataSet<TimeSeriesCompatible<SPElement>>(this.script.getOutputFormat());
        for (AmusaScriptWrapper.Output output : outputArray = this.script.getOutputs()) {
            amusaDataSet.add(sPExecutor.getResult((ProducerConsumerCompatible)linkedHashMap.get(output.object)).get(output.ch));
        }
        return amusaDataSet;
    }

    public static void main(String[] stringArray) {
        WAVAnalyzer wAVAnalyzer = new WAVAnalyzer();
        try {
            wAVAnalyzer.start(stringArray);
        }
        catch (Exception exception) {
            wAVAnalyzer.showErrorMessage(exception);
            System.exit(1);
        }
    }
}

