/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.sp.FFT;
import jp.crestmuse.cmx.amusaj.sp.FFTFactory;
import jp.crestmuse.cmx.amusaj.sp.SPComplexArray;
import jp.crestmuse.cmx.amusaj.sp.SPDoubleArray;
import jp.crestmuse.cmx.amusaj.sp.SPElement;
import jp.crestmuse.cmx.amusaj.sp.SPModule;
import jp.crestmuse.cmx.amusaj.sp.Utils;
import jp.crestmuse.cmx.math.DoubleArrayFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STFT
extends SPModule {
    private int winsize = -1;
    private String wintype = null;
    private double[] window;
    private boolean paramSet = false;
    private static final FFTFactory factory = FFTFactory.getFactory();
    private FFT fft = factory.createFFT();
    private static final DoubleArrayFactory dfactory = DoubleArrayFactory.getFactory();
    private boolean isStereo;

    public void changeWindow(String string, int n) {
        this.winsize = n;
        this.setParam("WINDOW_SIZE", n);
        this.wintype = string;
        this.setParam("WINDOW_TYPE", string);
        if (string.startsWith("ham")) {
            this.window = Utils.hamming(n);
        } else if (string.startsWith("han")) {
            this.window = Utils.hanning(n);
        } else if (string.startsWith("gaus")) {
            this.window = Utils.gaussian(n);
        } else if (string.startsWith("rect")) {
            this.window = null;
        } else {
            throw new IllegalStateException("Unsupported window type");
        }
    }

    @Override
    protected String getParamCategory() {
        return "fft";
    }

    @Override
    protected String[] getUsedParamNames() {
        return new String[]{"WINDOW_TYPE"};
    }

    private void setParams() {
        this.wintype = this.getParam("WINDOW_TYPE").toLowerCase();
        this.isStereo = this.getParam("TARGET_CHANNEL").equalsIgnoreCase("stereo");
        this.paramSet = true;
    }

    @Override
    public void execute(SPElement[] sPElementArray, TimeSeriesCompatible<SPElement>[] timeSeriesCompatibleArray) throws InterruptedException {
        if (!this.paramSet) {
            this.setParams();
        }
        SPDoubleArray sPDoubleArray = (SPDoubleArray)sPElementArray[0];
        if (this.winsize < 0 || this.winsize != sPDoubleArray.length()) {
            this.changeWindow(this.wintype, sPDoubleArray.length());
        }
        SPComplexArray sPComplexArray = new SPComplexArray(this.fft.executeR2C(sPDoubleArray, this.window));
        timeSeriesCompatibleArray[0].add(sPComplexArray);
        if (this.isStereo) {
            timeSeriesCompatibleArray[1].add(new SPComplexArray(this.fft.executeR2C((SPDoubleArray)sPElementArray[1], this.window)));
            timeSeriesCompatibleArray[2].add(new SPComplexArray(this.fft.executeR2C((SPDoubleArray)sPElementArray[2], this.window)));
        } else {
            timeSeriesCompatibleArray[1].add(sPComplexArray);
            timeSeriesCompatibleArray[2].add(sPComplexArray);
        }
    }

    @Override
    public Class<SPElement>[] getInputClasses() {
        return new Class[]{SPDoubleArray.class, SPDoubleArray.class, SPDoubleArray.class};
    }

    @Override
    public Class<SPElement>[] getOutputClasses() {
        return new Class[]{SPComplexArray.class, SPComplexArray.class, SPComplexArray.class};
    }
}

