/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.commands;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.commands.CMXCommand;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.filewrappers.DeviationDataSet;
import jp.crestmuse.cmx.filewrappers.DeviationInstanceWrapper;
import jp.crestmuse.cmx.filewrappers.InvalidFileTypeException;
import jp.crestmuse.cmx.filewrappers.MIDIXMLWrapper;
import jp.crestmuse.cmx.filewrappers.MusicXMLWrapper;
import jp.crestmuse.cmx.filewrappers.SCCXMLWrapper;
import org.xml.sax.SAXException;

public class PerformanceRenderingTest1
extends CMXCommand {
    private String smffilename = null;
    private DeviationDataSet dds;
    private int ticksPerBeat = 480;

    public static void main(String[] stringArray) {
        PerformanceRenderingTest1 performanceRenderingTest1 = new PerformanceRenderingTest1();
        try {
            performanceRenderingTest1.start(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println("end");
    }

    protected void run() throws IOException, ParserConfigurationException, SAXException, TransformerException, InvalidFileTypeException {
        MusicXMLWrapper musicXMLWrapper = (MusicXMLWrapper)this.indata();
        this.newOutputData("deviation");
        DeviationInstanceWrapper deviationInstanceWrapper = (DeviationInstanceWrapper)this.outdata();
        deviationInstanceWrapper.setTargetMusicXMLFileName(musicXMLWrapper.getFileName());
        this.dds = deviationInstanceWrapper.createDeviationDataSet();
        this.dds.addNonPartwiseControl(1, 1.0, "tempo", 120.0);
        MusicXMLWrapper.Part[] partArray = musicXMLWrapper.getPartList();
        for (MusicXMLWrapper.Part part : partArray) {
            MusicXMLWrapper.Measure[] measureArray;
            System.out.println("Part " + part.id());
            for (MusicXMLWrapper.Measure measure : measureArray = part.getMeasureList()) {
                System.out.println("Measure " + measure.number());
                for (MusicXMLWrapper.MusicData musicData : measure.getMusicDataList()) {
                    this.makeExpressionOfNote(musicData);
                }
            }
        }
        this.dds.toWrapper();
        deviationInstanceWrapper.finalizeDocument();
        if (this.smffilename != null) {
            SCCXMLWrapper sCCXMLWrapper = (SCCXMLWrapper)CMXFileWrapper.createDocument("scc");
            deviationInstanceWrapper.toSCCXML(sCCXMLWrapper, this.ticksPerBeat);
            MIDIXMLWrapper mIDIXMLWrapper = (MIDIXMLWrapper)CMXFileWrapper.createDocument("MIDIFile");
            sCCXMLWrapper.toMIDIXML(mIDIXMLWrapper);
            mIDIXMLWrapper.writefileAsSMF(this.smffilename);
            System.out.println("SMF output: " + this.smffilename);
        }
    }

    protected boolean setOptionsLocal(String string, String string2) {
        if (string.equals("-smf")) {
            this.smffilename = string2;
            return true;
        }
        if (string.equals("-division")) {
            this.ticksPerBeat = Integer.parseInt(string2);
            return false;
        }
        return false;
    }

    private void makeExpressionOfNote(MusicXMLWrapper.MusicData musicData) {
        if (!(musicData instanceof MusicXMLWrapper.Note)) {
            return;
        }
        MusicXMLWrapper.Note note = (MusicXMLWrapper.Note)musicData;
        String string = "Note[" + note.noteName();
        if (!note.rest()) {
            string = string + ", " + note.notenum();
        }
        string = string + "] ";
        System.out.print(string);
        MusicXMLWrapper.Notations notations = note.getFirstNotations();
        if (notations != null) {
            if (notations.hasArticulation("staccato")) {
                System.out.print(" staccato");
                if (note.chordNotes() == null) {
                    this.dds.addNoteDeviation(note, 0.0, -0.5 * (double)note.duration() / 4.0, 1.0, 1.0);
                } else {
                    System.out.print(" w/chord ");
                    this.dds.addChordDeviation(note, 0.0, -0.5 * (double)note.duration() / 4.0, 1.0, 1.0);
                }
            }
            if (notations.fermataType() != null) {
                System.out.print(" fermata");
                this.dds.addNonPartwiseControl(note.measure().number(), note.beat(), "tempo-deviation", 0.5);
            }
        }
        if (note.grace()) {
            this.dds.addNoteDeviation(note, -0.125, 0.0, 1.2, 1.0);
        }
        System.out.println();
    }
}

