/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.commands.test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import jp.crestmuse.cmx.commands.test.NoteFormatElement;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.filewrappers.DeviationInstanceWrapper;
import jp.crestmuse.cmx.filewrappers.MusicXMLWrapper;

public class Dev2NoteFormatTest {
    boolean debug_mode = false;
    FileWriter fw;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dev2NoteFormatTest(DeviationInstanceWrapper deviationInstanceWrapper) {
        if (!this.debug_mode) {
            try {
                this.fw = new FileWriter(new File("output.txt"));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            MusicXMLWrapper.Part[] partArray;
            MusicXMLWrapper musicXMLWrapper = deviationInstanceWrapper.getTargetMusicXML();
            NoteFormatElement noteFormatElement = new NoteFormatElement();
            noteFormatElement = noteFormatElement.setHeaderInformation(musicXMLWrapper);
            this.output(noteFormatElement.getHeader() + System.getProperty("line.separator"));
            for (MusicXMLWrapper.Part part : partArray = musicXMLWrapper.getPartList()) {
                String string = part.getAttribute("id");
                MusicXMLWrapper.Measure[] measureArray = part.getMeasureList();
                double d = measureArray[0].tempo();
                for (MusicXMLWrapper.Measure measure : measureArray) {
                    MusicXMLWrapper.MusicData[] musicDataArray = measure.getMusicDataList();
                    double d2 = 0.0;
                    for (MusicXMLWrapper.MusicData musicData : musicDataArray) {
                        DeviationInstanceWrapper.ExtraNote extraNote;
                        DeviationInstanceWrapper.ChordDeviation chordDeviation;
                        if (!(musicData instanceof MusicXMLWrapper.Note)) continue;
                        MusicXMLWrapper.Note note = (MusicXMLWrapper.Note)musicData;
                        NoteFormatElement noteFormatElement2 = new NoteFormatElement();
                        noteFormatElement2.starttime = (double)((measure.number() - 1) * noteFormatElement.beattype) + note.beat();
                        noteFormatElement2.ident = string;
                        noteFormatElement2.len = (double)(4 / noteFormatElement.beattype) * note.actualDuration();
                        if (note.rest()) continue;
                        noteFormatElement2.pitch = note.pitchStep() + note.pitchOctave();
                        DeviationInstanceWrapper.NoteDeviation noteDeviation = deviationInstanceWrapper.getNoteDeviation((MusicXMLWrapper.Note)musicData);
                        if (noteDeviation != null) {
                            noteFormatElement2.vel = (int)((double)deviationInstanceWrapper.getBaseVelocity() * noteDeviation.dynamics());
                            noteFormatElement2.off_vel = (int)((double)deviationInstanceWrapper.getBaseVelocity() * noteDeviation.endDynamics());
                            noteFormatElement2.on_devi = (double)(noteFormatElement.beattype / 4) * noteDeviation.attack();
                            noteFormatElement2.off_devi = (double)(noteFormatElement.beattype / 4) * noteDeviation.release();
                        }
                        if ((chordDeviation = deviationInstanceWrapper.getChordDeviation((MusicXMLWrapper.Note)musicData)) != null) {
                            // empty if block
                        }
                        DeviationInstanceWrapper.MissNote missNote = deviationInstanceWrapper.getMissNote((MusicXMLWrapper.Note)musicData);
                        boolean bl = false;
                        if (missNote != null && missNote.hasAttribute("xlink:href")) {
                            bl = true;
                        }
                        Iterator iterator = deviationInstanceWrapper.getExtraNotesList(deviationInstanceWrapper, string).iterator();
                        while (iterator.hasNext() && noteFormatElement2.starttime > (double)(((extraNote = (DeviationInstanceWrapper.ExtraNote)iterator.next()).measure() - 1) * noteFormatElement.beattype) + extraNote.beat()) {
                            if (!(d2 <= (double)((extraNote.measure() - 1) * noteFormatElement.beattype) + extraNote.beat())) continue;
                            NoteFormatElement noteFormatElement3 = new NoteFormatElement();
                            noteFormatElement3.starttime = (double)((extraNote.measure() - 1) * noteFormatElement.beattype) + extraNote.beat();
                            noteFormatElement3.ident = string;
                            noteFormatElement3.len = (double)(4 / noteFormatElement.beattype) * extraNote.duration();
                            noteFormatElement3.pitch = extraNote.pitchStep() + extraNote.pitchOctave();
                            noteFormatElement3.vel = (int)((double)deviationInstanceWrapper.getBaseVelocity() * extraNote.dynamics());
                            noteFormatElement3.off_vel = (int)((double)deviationInstanceWrapper.getBaseVelocity() * extraNote.endDynamics());
                            noteFormatElement3.on_devi = 0.0;
                            noteFormatElement3.off_devi = 0.0;
                            this.output(noteFormatElement3.getFormedElement() + System.getProperty("line.separator"));
                        }
                        double d3 = 1.0;
                        for (DeviationInstanceWrapper.Control control : deviationInstanceWrapper.getNonPartwiseList(deviationInstanceWrapper)) {
                            if (noteFormatElement2.starttime >= (double)((control.measure() - 1) * noteFormatElement.beattype) + control.beat()) {
                                if (control.type().equals("tempo")) {
                                    d = control.value();
                                } else {
                                    if (!control.type().equals("tempo-deviation")) break;
                                    d3 = control.value();
                                }
                            }
                            if (d2 == noteFormatElement2.starttime) continue;
                            this.output(noteFormatElement2.starttime + " BPM " + d * d3 + " " + noteFormatElement.beattype + System.getProperty("line.separator"));
                            d2 = noteFormatElement2.starttime;
                        }
                        if (bl) continue;
                        this.output(noteFormatElement2.getFormedElement() + System.getProperty("line.separator"));
                    }
                }
            }
            this.output(NoteFormatElement.getEnd());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (!this.debug_mode) {
                try {
                    this.fw.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public void output(String string) {
        if (this.debug_mode) {
            System.out.print(string);
        } else {
            try {
                this.fw.write(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            DeviationInstanceWrapper deviationInstanceWrapper = (DeviationInstanceWrapper)CMXFileWrapper.readfile("deviation.xml");
            new Dev2NoteFormatTest(deviationInstanceWrapper);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

