/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.commands.test;

import jp.crestmuse.cmx.filewrappers.MusicXMLWrapper;

class NoteFormatElement {
    int beat = -1;
    int beattype = -1;
    String bpm = null;
    String bpmbeat = null;
    String beattime = null;
    String beattimebeat = null;
    String tactus = null;
    String tactusbeat = null;
    String timescale = "BEAT";
    String title = null;
    String composer = null;
    String perfomer = null;
    String accompanist = null;
    String arranger = null;
    String generator = null;
    double starttime;
    double on_devi;
    String ident;
    String pitch;
    double off_devi;
    int vel;
    double off_vel;
    double len;

    NoteFormatElement() {
    }

    String getFormedElement() {
        return this.starttime + " (" + this.on_devi + " " + this.ident + " " + this.pitch + " " + this.vel + " " + this.len + " " + this.off_devi + ")";
    }

    String getSimpleFormedElement() {
        return this.starttime + " (" + this.pitch + " " + this.len + ")";
    }

    NoteFormatElement setHeaderInformation(MusicXMLWrapper musicXMLWrapper) {
        NoteFormatElement noteFormatElement = new NoteFormatElement();
        noteFormatElement.title = musicXMLWrapper.getMovementTitle();
        noteFormatElement.beat = Integer.parseInt(musicXMLWrapper.getPartList()[0].getChildText("beats"));
        noteFormatElement.beattype = Integer.parseInt(musicXMLWrapper.getPartList()[0].getChildText("beat-type"));
        noteFormatElement.generator = "Dev2NoteFormatTest";
        return noteFormatElement;
    }

    String getHeader() {
        String string = "Header {\n";
        if (this.beat != -1 && this.beattype != -1) {
            string = string + "  BEAT " + this.beat + "/" + this.beattype + "\n";
        }
        if (this.bpm != null) {
            string = string + "  BPM " + this.bpm + " " + this.bpmbeat + "\n";
        }
        if (this.beattime != null) {
            string = string + "  BEATTIME " + this.beattime + " " + this.beattimebeat + "\n";
        }
        if (this.tactus != null) {
            string = string + "  TACTUS " + this.tactus + " " + this.tactusbeat + "\n";
        }
        if (this.timescale != null) {
            string = string + "  TIMESCALE " + this.timescale + "\n";
        }
        if (this.title != null) {
            string = string + "  TITLE \"" + this.title + "\"\n";
        }
        if (this.composer != null) {
            string = string + "  COMPOSER \"" + this.composer + "\"\n";
        }
        if (this.perfomer != null) {
            string = string + "  PERFORMER \"" + this.perfomer + "\"\n";
        }
        if (this.accompanist != null) {
            string = string + "  ACCOMPANIST \"" + this.accompanist + "\"\n";
        }
        if (this.arranger != null) {
            string = string + "  ARRANGER \"" + this.arranger + "\"\n";
        }
        if (this.generator != null) {
            string = string + "  GENERATOR \"" + this.generator + "\"\n";
        }
        return string + "}\n";
    }

    public static String getEnd() {
        return "END";
    }

    public static String getMeasureLine(String string) {
        return "=" + string;
    }
}

