/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.filewrappers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.filewrappers.MusicApexWrapper;
import jp.crestmuse.cmx.filewrappers.MusicXMLWrapper;
import jp.crestmuse.cmx.filewrappers.NodeInterface;
import jp.crestmuse.cmx.filewrappers.NoteGroup;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MusicApexDataSet {
    private MusicApexWrapper mawxml = null;
    private MusicXMLWrapper musicxml = null;
    private Boolean inherited = false;
    private String aspect = null;
    private ApexDataGroup toplevel = null;
    private HashMap<Node, MusicXMLWrapper.Note> noteMap = new HashMap();
    private List<MusicXMLWrapper.Note> allnotes;

    public MusicApexDataSet(MusicXMLWrapper musicXMLWrapper) {
        this.musicxml = musicXMLWrapper;
    }

    public NoteGroup createTopLevelGroup(Boolean bl) {
        return this.createTopLevelGroup(bl, null);
    }

    public NoteGroup createTopLevelGroup(Boolean bl, String string) {
        MusicXMLWrapper.Part[] partArray;
        this.inherited = bl;
        this.aspect = string;
        this.toplevel = new ApexDataGroup();
        this.allnotes = new ArrayList<MusicXMLWrapper.Note>();
        this.toplevel.depth = 1;
        this.toplevel.groupParent = null;
        for (MusicXMLWrapper.Part part : partArray = this.musicxml.getPartList()) {
            MusicXMLWrapper.Measure[] measureArray;
            for (MusicXMLWrapper.Measure measure : measureArray = part.getMeasureList()) {
                MusicXMLWrapper.MusicData[] musicDataArray;
                for (MusicXMLWrapper.MusicData musicData : musicDataArray = measure.getMusicDataList()) {
                    if (!(musicData instanceof MusicXMLWrapper.Note)) continue;
                    MusicXMLWrapper.Note note = (MusicXMLWrapper.Note)musicData;
                    this.toplevel.addNote(note);
                    this.noteMap.put(note.node(), note);
                    this.allnotes.add(note);
                }
            }
        }
        return this.toplevel;
    }

    public NoteGroup createGroup() {
        return new ApexDataGroup();
    }

    public NoteGroup createGroup(List<MusicXMLWrapper.Note> list) {
        return new ApexDataGroup(list, null, Double.NaN);
    }

    public NoteGroup createGroup(List<MusicXMLWrapper.Note> list, MusicXMLWrapper.Note note) {
        return new ApexDataGroup(list, note, Double.NaN);
    }

    public NoteGroup createGroup(List<MusicXMLWrapper.Note> list, MusicXMLWrapper.Note note, double d) {
        return new ApexDataGroup(list, note, d);
    }

    public void setAspect(String string) {
        this.aspect = string;
    }

    public ApexDataGroup topgroup() {
        return this.toplevel;
    }

    public MusicApexWrapper toWrapper() {
        if (this.toplevel == null) {
            throw new RuntimeException("TopLevelGroup not created.");
        }
        this.mawxml = new MusicApexWrapper();
        this.mawxml = MusicApexWrapper.createMusicApexWrapperFor(this.musicxml);
        this.mawxml.setAttribute("target", this.musicxml.getFileName());
        this.mawxml.setAttribute("apex-inherited", this.inherited != false ? "yes" : "no");
        if (this.aspect != null) {
            this.mawxml.setAttribute("aspect", this.aspect);
        }
        this.writeApexDataGroup(this.toplevel);
        return this.mawxml;
    }

    private void writeApexDataGroup(NoteGroup noteGroup) {
        this.mawxml.addChild("group");
        if (noteGroup.depth() == -1) {
            throw new RuntimeException("Invalid GroupDepth");
        }
        this.mawxml.setAttribute("depth", noteGroup.depth());
        if (!noteGroup.getSubgroups().isEmpty()) {
            for (NoteGroup object : noteGroup.getSubgroups()) {
                this.writeApexDataGroup(object);
            }
        }
        if (!noteGroup.getNotes().isEmpty()) {
            for (MusicXMLWrapper.Note note : noteGroup.getNotes()) {
                this.mawxml.addChild("note");
                this.mawxml.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "#xpointer(" + note.getXPathExpression() + ")");
                this.mawxml.returnToParent();
            }
        } else {
            throw new RuntimeException("Creating No Notes Group");
        }
        if (noteGroup.getApex() != null) {
            this.mawxml.addChild("apex");
            this.mawxml.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "#xpointer(" + noteGroup.getApex().getXPathExpression() + ")");
            if (!Double.isNaN(noteGroup.getApexSaliency())) {
                this.mawxml.setAttribute("saliency", noteGroup.getApexSaliency());
            }
            this.mawxml.returnToParent();
        }
        this.mawxml.returnToParent();
    }

    private List<MusicXMLWrapper.Note> getNotesByRange(int n, int n2) {
        ArrayList<MusicXMLWrapper.Note> arrayList = new ArrayList<MusicXMLWrapper.Note>();
        for (int i = n; i <= n2; ++i) {
            arrayList.add(this.allnotes.get(i));
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        MusicXMLWrapper musicXMLWrapper = new MusicXMLWrapper();
        try {
            musicXMLWrapper = (MusicXMLWrapper)CMXFileWrapper.readfile("./sample.xml");
            MusicApexDataSet musicApexDataSet = new MusicApexDataSet(musicXMLWrapper);
            musicApexDataSet.createTopLevelGroup(true);
            musicApexDataSet.setAspect("hoge");
            musicApexDataSet.toplevel.setApex(musicApexDataSet.allnotes.get(8));
            musicApexDataSet.toplevel.makeSubgroup(musicApexDataSet.getNotesByRange(5, 10), musicApexDataSet.allnotes.get(6));
            musicApexDataSet.toplevel.makeSubgroup(musicApexDataSet.getNotesByRange(20, 30));
            ((ApexDataGroup)musicApexDataSet.toplevel.subGroups.get(1)).makeSubgroup(musicApexDataSet.getNotesByRange(24, 28), musicApexDataSet.allnotes.get(28));
            NodeList nodeList = musicXMLWrapper.selectNodeList("/score-partwise/part/measure[@number='1']/note");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                System.out.println(nodeList.item(i).getTextContent());
                MusicApexDataSet.printNote(musicApexDataSet.noteMap.get(nodeList.item(i)));
            }
            MusicXMLWrapper.Note note = musicApexDataSet.allnotes.get(1);
            Class<MusicXMLWrapper.Note> clazz = MusicXMLWrapper.Note.class;
            System.out.println(note instanceof NodeInterface);
            System.out.println(clazz.getName());
            System.out.println(note);
            System.out.println(note.getClass().equals(clazz));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Deprecated
    public static void printNote(MusicXMLWrapper.Note note) {
        System.out.println("Type:" + note.type() + " m:" + note.measure().number() + " b:" + note.beat() + " text:" + note.getText());
        System.out.println(note.getText());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ApexDataGroup
    implements NoteGroup {
        private int depth = -1;
        private List<MusicXMLWrapper.Note> ownnotes = new ArrayList<MusicXMLWrapper.Note>();
        private List<MusicXMLWrapper.Note> undernotes = new ArrayList<MusicXMLWrapper.Note>();
        private List<NoteGroup> subGroups = new ArrayList<NoteGroup>();
        private NoteGroup groupParent = null;
        private MusicXMLWrapper.Note apex = null;
        private double saliency = Double.NaN;

        public ApexDataGroup() {
        }

        public ApexDataGroup(List<MusicXMLWrapper.Note> list, MusicXMLWrapper.Note note, double d) {
            this.ownnotes.addAll(list);
            this.undernotes.addAll(list);
            this.apex = note;
            this.saliency = d;
        }

        @Override
        public int depth() {
            return this.depth;
        }

        @Override
        public boolean isApexInherited() {
            return MusicApexDataSet.this.inherited;
        }

        @Override
        public double getApexSaliency() {
            return this.saliency;
        }

        @Override
        public List<MusicXMLWrapper.Note> getNotes() {
            return this.ownnotes;
        }

        @Override
        public List<MusicXMLWrapper.Note> getAllNotes() {
            return this.undernotes;
        }

        @Override
        public MusicXMLWrapper.Note getApex() {
            return this.apex;
        }

        @Override
        public List<NoteGroup> getSubgroups() {
            return this.subGroups;
        }

        @Override
        public void addNote(MusicXMLWrapper.Note note) {
            this.ownnotes.add(note);
            this.undernotes.add(note);
        }

        @Override
        public void addSubgroup(NoteGroup noteGroup) {
            if (noteGroup instanceof ApexDataGroup) {
                ((ApexDataGroup)noteGroup).groupParent = this;
                ((ApexDataGroup)noteGroup).depth = this.depth() + 1;
                if (this.isApexInherited()) {
                    this.refreshSubGroupApex((ApexDataGroup)noteGroup);
                }
            }
            this.undernotes.addAll(noteGroup.getAllNotes());
            this.subGroups.add(noteGroup);
        }

        @Override
        public void makeSubgroup(List<MusicXMLWrapper.Note> list) {
            this.makeSubgroup(list, null);
        }

        public void makeSubgroup(List<MusicXMLWrapper.Note> list, MusicXMLWrapper.Note note) {
            this.makeSubgroup(list, note, Double.NaN);
        }

        public void makeSubgroup(List<MusicXMLWrapper.Note> list, MusicXMLWrapper.Note note, double d) {
            for (MusicXMLWrapper.Note note2 : list) {
                Boolean bl = false;
                bl = this.ownnotes.contains(note2);
                if (!bl.booleanValue()) {
                    for (NoteGroup noteGroup : this.getSubgroups()) {
                        if (!noteGroup.getNotes().contains(note2)) continue;
                        bl = true;
                        break;
                    }
                }
                if (bl.booleanValue()) continue;
                throw new RuntimeException("Note is not included Parent and Parent's subgroups");
            }
            ApexDataGroup apexDataGroup = new ApexDataGroup();
            apexDataGroup.groupParent = this;
            apexDataGroup.ownnotes.addAll(list);
            apexDataGroup.undernotes.addAll(list);
            apexDataGroup.depth = this.depth + 1;
            if (this.isApexInherited() && this.getApex() != null && apexDataGroup.ownnotes.contains(this.apex)) {
                apexDataGroup.apex = this.apex;
                apexDataGroup.saliency = this.saliency;
            } else {
                apexDataGroup.apex = note;
                apexDataGroup.saliency = d;
            }
            this.subGroups.add(apexDataGroup);
            this.ownnotes.removeAll(list);
        }

        @Override
        public void setApex(MusicXMLWrapper.Note note) {
            if (this.apex != null) {
                throw new RuntimeException("This group already has Apex. : " + note.getXPathExpression());
            }
            this.apex = note;
        }

        @Override
        public void setApex(MusicXMLWrapper.Note note, double d) {
            if (MusicApexDataSet.this.inherited.booleanValue()) {
                throw new RuntimeException("This Apex is inherited");
            }
            this.apex = note;
            this.saliency = d;
        }

        private void refreshSubGroupApex(ApexDataGroup apexDataGroup) {
            if (apexDataGroup.getNotes().contains(this.apex)) {
                apexDataGroup.apex = this.apex;
                apexDataGroup.saliency = this.saliency;
            }
            if (!apexDataGroup.subGroups.isEmpty()) {
                for (NoteGroup noteGroup : apexDataGroup.getSubgroups()) {
                    apexDataGroup.refreshSubGroupApex((ApexDataGroup)noteGroup);
                }
            }
        }

        public NoteGroup getParentGroup() {
            return this.groupParent;
        }
    }
}

