/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.gui.deveditor.view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JPanel;
import jp.crestmuse.cmx.gui.deveditor.controller.DeviatedNoteUpdateListener;
import jp.crestmuse.cmx.gui.deveditor.model.DeviatedPerformance;
import jp.crestmuse.cmx.gui.deveditor.view.PianoRollPanel;

public class CurvesPanel
extends JPanel
implements DeviatedNoteUpdateListener,
MouseListener,
MouseMotionListener {
    public static int ROW_HEADER_WIDTH = 64;
    public static int PANEL_HEIGHT = 200;
    private static Color TEMPO_COLOR = Color.BLUE;
    private static Color HOVER_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.5f);
    private Curve tempo;
    private double scale;
    private RowHeader rowHeader;
    private DeviatedPerformance deviatedPerformance;
    private PianoRollPanel pianoRollPanel;
    private int hoverAreaX = -1000;
    private boolean dragged = false;

    public CurvesPanel(DeviatedPerformance deviatedPerformance, PianoRollPanel pianoRollPanel) {
        this.deviatedPerformance = deviatedPerformance;
        this.pianoRollPanel = pianoRollPanel;
        this.updateScale();
        this.rowHeader = new RowHeader();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void noteUpdated(DeviatedPerformance.DeviatedNote deviatedNote) {
        this.updateScale();
        this.repaint();
    }

    public JPanel getRowHeader() {
        return this.rowHeader;
    }

    public void updateScale() {
        int n = (int)this.deviatedPerformance.getSequence().getTickLength();
        int n2 = this.pianoRollPanel.getPreferredSize().width;
        this.setPreferredSize(new Dimension(n2, PANEL_HEIGHT));
        this.scale = (double)n2 / (double)n;
        Map<Integer, Integer> map = this.deviatedPerformance.getTicks2Tempo();
        this.tempo = new Curve(map.size() * 2 - 1, TEMPO_COLOR);
        Iterator<Map.Entry<Integer, Integer>> iterator = map.entrySet().iterator();
        Map.Entry<Integer, Integer> entry = iterator.next();
        this.tempo.xPoints[0] = (int)((double)entry.getKey().intValue() * this.scale);
        this.tempo.yPoints[0] = entry.getValue();
        int n3 = 2;
        while (iterator.hasNext()) {
            int n4;
            Map.Entry<Integer, Integer> entry2 = iterator.next();
            this.tempo.xPoints[n3 - 1] = n4 = (int)((double)entry2.getKey().intValue() * this.scale);
            this.tempo.yPoints[n3 - 1] = this.tempo.yPoints[n3 - 2];
            this.tempo.xPoints[n3] = n4;
            this.tempo.yPoints[n3] = entry2.getValue();
            n3 += 2;
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.tempo.draw(graphics);
        graphics.setColor(HOVER_COLOR);
        graphics.fillRect(this.hoverAreaX, 0, (int)((double)DeviatedPerformance.TICKS_PER_BEAT * this.scale), this.getHeight());
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.dragged) {
            this.dragged = false;
            int n = (int)this.deviatedPerformance.getSequence().getTickLength();
            for (int i = 0; i < n; i += DeviatedPerformance.TICKS_PER_BEAT) {
                if (!((double)i * this.scale > (double)this.hoverAreaX)) continue;
                this.deviatedPerformance.setTempo(i - DeviatedPerformance.TICKS_PER_BEAT, this.getHeight() - mouseEvent.getY());
                this.updateScale();
                this.repaint();
                break;
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        for (int i = 0; i < this.tempo.nPoints; ++i) {
            if (this.tempo.xPoints[i] < this.hoverAreaX) continue;
            int n = this.getHeight() - mouseEvent.getY();
            this.tempo.yPoints[i + 2] = n;
            this.tempo.yPoints[i + 1] = n;
            this.dragged = true;
            this.repaint();
            break;
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = (int)this.deviatedPerformance.getSequence().getTickLength();
        for (int i = 0; i < n; i += DeviatedPerformance.TICKS_PER_BEAT) {
            if (!((double)i * this.scale > (double)mouseEvent.getX())) continue;
            this.hoverAreaX = (int)((double)(i - DeviatedPerformance.TICKS_PER_BEAT) * this.scale);
            this.repaint();
            break;
        }
    }

    public static class RowHeader
    extends JPanel {
        public RowHeader() {
            this.setPreferredSize(new Dimension(ROW_HEADER_WIDTH, PANEL_HEIGHT));
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            graphics.setColor(Color.BLACK);
            for (int i = 0; i < this.getHeight(); i += 30) {
                graphics.drawString(i + "", ROW_HEADER_WIDTH - 30, this.getHeight() - i - 0);
            }
            graphics.setColor(TEMPO_COLOR);
            graphics.drawString("Tempo", 0, 30);
            graphics.drawString("(BMP)", 0, 44);
        }
    }

    private class Curve {
        int[] xPoints;
        int[] yPoints;
        int nPoints;
        Color color;

        Curve(int n, Color color) {
            this.xPoints = new int[n];
            this.yPoints = new int[n];
            this.nPoints = n;
            this.color = color;
        }

        void draw(Graphics graphics) {
            graphics.setColor(this.color);
            for (int i = 0; i < this.nPoints - 1; ++i) {
                graphics.drawLine(this.xPoints[i], CurvesPanel.this.getHeight() - this.yPoints[i], this.xPoints[i + 1], CurvesPanel.this.getHeight() - this.yPoints[i + 1]);
            }
            graphics.drawLine(this.xPoints[this.nPoints - 1], CurvesPanel.this.getHeight() - this.yPoints[this.nPoints - 1], CurvesPanel.this.getWidth(), CurvesPanel.this.getHeight() - this.yPoints[this.nPoints - 1]);
        }
    }
}

