/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.gui.deveditor.view;

import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.filewrappers.DeviationInstanceWrapper;
import jp.crestmuse.cmx.filewrappers.MusicXMLWrapper;
import jp.crestmuse.cmx.gui.deveditor.controller.CommandInvoker;
import jp.crestmuse.cmx.gui.deveditor.controller.DeviatedNoteControler;
import jp.crestmuse.cmx.gui.deveditor.model.DeviatedPerformance;
import jp.crestmuse.cmx.gui.deveditor.view.CurvesPanel;
import jp.crestmuse.cmx.gui.deveditor.view.NoteEditPanel;
import jp.crestmuse.cmx.gui.deveditor.view.NoteList;
import jp.crestmuse.cmx.gui.deveditor.view.PianoRollPanel;
import jp.crestmuse.cmx.gui.deveditor.view.VelocityPanel;

public class DeviatedPerformanceList
extends JList {
    private DefaultListModel model = new DefaultListModel();

    public DeviatedPerformanceList() {
        this.setModel(this.model);
    }

    public void addPerformance(String string, JScrollPane jScrollPane, ListElementLoadListener listElementLoadListener) {
        this.model.addElement(new ListElement(string, jScrollPane, listElementLoadListener));
    }

    public ListElement getSelectedValue() {
        return (ListElement)super.getSelectedValue();
    }

    private void removePerformance(ListElement listElement) {
        this.model.removeElement(listElement);
    }

    public static interface ListElementLoadListener {
        public void listElementLoaded();

        public void listElementLoadFailed();
    }

    public class ListElement {
        private String fileName;
        private DeviatedPerformance deviatedPerformance;
        private CommandInvoker commandInvoker;
        private PianoRollPanel pianoRollPanel;
        private CurvesPanel curvesPanel;
        private VelocityPanel velocityPanel;
        private NoteList noteList;
        private NoteEditPanel noteEditPanel;
        private boolean loading;

        private ListElement(String string, JScrollPane jScrollPane, ListElementLoadListener listElementLoadListener) {
            LoadThread loadThread = new LoadThread(string, jScrollPane, listElementLoadListener);
            loadThread.start();
            this.fileName = "loading...";
            this.loading = true;
        }

        public String toString() {
            return this.fileName;
        }

        public String getName() {
            return this.fileName;
        }

        public DeviatedPerformance getDeviatedPerformance() {
            return this.deviatedPerformance;
        }

        public CommandInvoker getCommandInvoker() {
            return this.commandInvoker;
        }

        public PianoRollPanel getPianoRollPanel() {
            return this.pianoRollPanel;
        }

        public CurvesPanel getCurvesPanel() {
            return this.curvesPanel;
        }

        public VelocityPanel getVelocityPanel() {
            return this.velocityPanel;
        }

        public NoteList getNoteList() {
            return this.noteList;
        }

        public NoteEditPanel getNoteEditPanel() {
            return this.noteEditPanel;
        }

        public boolean isLoading() {
            return this.loading;
        }

        private class LoadThread
        extends Thread {
            String filename;
            JScrollPane notelistParent;
            ListElementLoadListener listener;

            LoadThread(String string, JScrollPane jScrollPane, ListElementLoadListener listElementLoadListener) {
                this.filename = string;
                this.notelistParent = jScrollPane;
                this.listener = listElementLoadListener;
            }

            public void run() {
                Thread thread = new Thread(){
                    int c = 0;
                    int v = 1;

                    public void run() {
                        while (ListElement.this.loading) {
                            this.c += this.v;
                            if (this.c > 10) {
                                this.v = -1;
                            } else if (this.c < 1) {
                                this.v = 1;
                            }
                            ListElement.this.fileName = "loading";
                            for (int i = 0; i < this.c; ++i) {
                                ListElement.this.fileName = ListElement.this.fileName + " ";
                            }
                            ListElement.this.fileName = ListElement.this.fileName + "...";
                            DeviatedPerformanceList.this.repaint();
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                        }
                    }
                };
                thread.start();
                try {
                    DeviationInstanceWrapper deviationInstanceWrapper;
                    CMXFileWrapper cMXFileWrapper = CMXFileWrapper.readfile(this.filename);
                    try {
                        deviationInstanceWrapper = DeviationInstanceWrapper.createDeviationInstanceFor((MusicXMLWrapper)cMXFileWrapper);
                        deviationInstanceWrapper.finalizeDocument();
                    }
                    catch (ClassCastException classCastException) {
                        try {
                            deviationInstanceWrapper = (DeviationInstanceWrapper)cMXFileWrapper;
                        }
                        catch (ClassCastException classCastException2) {
                            throw new IllegalArgumentException("argument must be MusicXMLWrapper or DeviationInstanceWrapper");
                        }
                    }
                    ListElement.this.deviatedPerformance = new DeviatedPerformance(deviationInstanceWrapper);
                    ListElement.this.commandInvoker = new CommandInvoker();
                    DeviatedNoteControler deviatedNoteControler = new DeviatedNoteControler(ListElement.this.commandInvoker);
                    ListElement.this.pianoRollPanel = new PianoRollPanel(ListElement.this.deviatedPerformance, deviatedNoteControler);
                    ListElement.this.curvesPanel = new CurvesPanel(ListElement.this.deviatedPerformance, ListElement.this.pianoRollPanel);
                    ListElement.this.velocityPanel = new VelocityPanel(ListElement.this.deviatedPerformance, ListElement.this.pianoRollPanel, deviatedNoteControler);
                    ListElement.this.noteList = new NoteList(ListElement.this.deviatedPerformance, deviatedNoteControler, this.notelistParent);
                    ListElement.this.noteEditPanel = new NoteEditPanel(deviatedNoteControler);
                    ListElement.this.deviatedPerformance.addListener(ListElement.this.pianoRollPanel);
                    ListElement.this.deviatedPerformance.addListener(ListElement.this.velocityPanel);
                    ListElement.this.deviatedPerformance.addListener(ListElement.this.noteList);
                    ListElement.this.deviatedPerformance.addListener(ListElement.this.noteEditPanel);
                    ListElement.this.deviatedPerformance.addListener(ListElement.this.curvesPanel);
                    ListElement.this.loading = false;
                    ListElement.this.fileName = cMXFileWrapper.getFileName();
                    this.listener.listElementLoaded();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    DeviatedPerformanceList.this.removePerformance(ListElement.this);
                    this.listener.listElementLoadFailed();
                }
            }
        }
    }
}

