/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.gui.deveditor.view;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Transmitter;
import jp.crestmuse.cmx.gui.deveditor.model.DeviatedPerformance;
import jp.crestmuse.cmx.sound.MusicPlayer;
import org.xml.sax.SAXException;

public class DeviatedPerformancePlayer
implements MusicPlayer {
    private DeviatedPerformance currentPerformance = null;
    private Sequencer sequencer = MidiSystem.getSequencer();
    private LabeledMidiDevice[] receivers;
    private int currentReceiverIndex = 0;
    private Transmitter transmitter;

    public DeviatedPerformancePlayer() throws MidiUnavailableException {
        this.sequencer.open();
        this.transmitter = this.sequencer.getTransmitters().get(0);
        ArrayList<MidiDevice> arrayList = new ArrayList<MidiDevice>();
        for (MidiDevice.Info info : MidiSystem.getMidiDeviceInfo()) {
            try {
                MidiDevice midiDevice = MidiSystem.getMidiDevice(info);
                if (midiDevice.getMaxReceivers() == 0) continue;
                arrayList.add(midiDevice);
            }
            catch (MidiUnavailableException midiUnavailableException) {
                midiUnavailableException.printStackTrace();
            }
        }
        this.receivers = new LabeledMidiDevice[arrayList.size()];
        for (int i = 0; i < this.receivers.length; ++i) {
            this.receivers[i] = new LabeledMidiDevice((MidiDevice)arrayList.get(i));
        }
    }

    public void setReciever(int n) throws MidiUnavailableException {
        MidiDevice midiDevice = this.receivers[n].md;
        midiDevice.open();
        Receiver receiver = midiDevice.getReceiver();
        this.transmitter.setReceiver(receiver);
        this.currentReceiverIndex = n;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.sequencer != null) {
            this.sequencer.close();
        }
    }

    public long getMicrosecondPosition() {
        if (this.sequencer == null) {
            return 0L;
        }
        return this.sequencer.getMicrosecondPosition();
    }

    public int getTicksPerBeat() {
        if (this.sequencer == null) {
            return 0;
        }
        return this.sequencer.getSequence().getResolution();
    }

    public long getTickPosition() {
        if (this.sequencer == null) {
            return 0L;
        }
        return this.sequencer.getTickPosition();
    }

    public boolean isNowPlaying() {
        if (this.sequencer == null) {
            return false;
        }
        return this.sequencer.isRunning();
    }

    public void play() {
        if (this.sequencer != null) {
            this.sequencer.start();
        }
    }

    public void stop() {
        if (this.sequencer != null) {
            this.sequencer.stop();
        }
    }

    public void run() {
    }

    public void reset() {
        if (this.sequencer != null) {
            this.sequencer.setTickPosition(0L);
        }
    }

    public void setTickPosition(long l) {
        if (this.sequencer != null) {
            this.sequencer.setTickPosition(l);
        }
    }

    public void setMicrosecondPosition(long l) {
        if (this.sequencer != null) {
            this.sequencer.setMicrosecondPosition(l);
        }
    }

    public void changeDeviation(DeviatedPerformance deviatedPerformance) throws InvalidMidiDataException {
        if (deviatedPerformance == this.currentPerformance) {
            return;
        }
        try {
            long l = this.sequencer.getTickPosition();
            this.sequencer.setSequence(deviatedPerformance.getSequence());
            this.sequencer.setTickPosition(l);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.currentPerformance = deviatedPerformance;
    }

    public Sequence getCurrentSequence() {
        return this.currentPerformance.getSequence();
    }

    public LabeledMidiDevice[] getReceivers() {
        return this.receivers;
    }

    public int getCurrentReceiverIndex() {
        return this.currentReceiverIndex;
    }

    public void writeFile(OutputStream outputStream) throws IOException, SAXException {
        this.currentPerformance.calcDeviation().write(outputStream);
    }

    public class LabeledMidiDevice {
        private MidiDevice md;

        private LabeledMidiDevice(MidiDevice midiDevice) {
            this.md = midiDevice;
        }

        public String toString() {
            return this.md.getDeviceInfo().getName();
        }
    }
}

