/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.gui.deveditor.view;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.crestmuse.cmx.filewrappers.MusicXMLWrapper;
import jp.crestmuse.cmx.gui.deveditor.controller.ChangeAttackInMSec;
import jp.crestmuse.cmx.gui.deveditor.controller.ChangeDeviation;
import jp.crestmuse.cmx.gui.deveditor.controller.ChangeReleaseInMSec;
import jp.crestmuse.cmx.gui.deveditor.controller.DeviatedNoteControler;
import jp.crestmuse.cmx.gui.deveditor.controller.DeviatedNoteSelectListener;
import jp.crestmuse.cmx.gui.deveditor.controller.DeviatedNoteUpdateListener;
import jp.crestmuse.cmx.gui.deveditor.model.DeviatedPerformance;
import jp.crestmuse.cmx.gui.deveditor.view.MainFrame;

public class PianoRollPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
ChangeListener,
DeviatedNoteSelectListener,
DeviatedNoteUpdateListener {
    public static int WIDTH_PER_BEAT = 32;
    public static int HEIGHT_PER_NOTE = 16;
    public static int COLUMN_HEADER_HEIGHT = 16;
    private DeviatedPerformance deviatedPerformance;
    private ArrayList<PrintableDeviatedNote> deviatedNotes;
    private ArrayList<PrintableNote> allNotes;
    private PrintableDeviatedNote hoverNote;
    private PrintableDeviatedNote.NoteMoveHandle holdNote;
    private PrintableDeviatedNote selectedNote;
    private ColumnHeaderPanel columnHeader;
    private int playingLine;
    private HashMap<DeviatedPerformance.DeviatedNote, PrintableDeviatedNote> dn2pdn;
    private DeviatedNoteControler deviatedNoteControler;
    private static short showVoice = (short)63;

    public PianoRollPanel(DeviatedPerformance deviatedPerformance, DeviatedNoteControler deviatedNoteControler) {
        this.deviatedPerformance = deviatedPerformance;
        this.deviatedNoteControler = deviatedNoteControler;
        deviatedNoteControler.addDeviatedNoteSelectListener(this);
        this.playingLine = 0;
        this.deviatedNotes = new ArrayList();
        this.allNotes = new ArrayList();
        this.dn2pdn = new HashMap();
        for (DeviatedPerformance.DeviatedNote deviatedNote : deviatedPerformance.getDeviatedNotes()) {
            PrintableDeviatedNote printableDeviatedNote = new PrintableDeviatedNote(deviatedNote);
            this.deviatedNotes.add(printableDeviatedNote);
            this.allNotes.add(printableDeviatedNote);
            if (!deviatedNote.isExtraNote()) {
                this.allNotes.add(new PrintableOriginalNote(deviatedNote));
            }
            this.dn2pdn.put(deviatedNote, printableDeviatedNote);
        }
        this.holdNote = null;
        int n = (int)deviatedPerformance.getSequence().getTickLength();
        int n2 = WIDTH_PER_BEAT * n / DeviatedPerformance.TICKS_PER_BEAT;
        this.setPreferredSize(new Dimension(n2, HEIGHT_PER_NOTE * 128));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        int n3 = n / (DeviatedPerformance.TICKS_PER_BEAT * 4);
        int n4 = (int)(deviatedPerformance.getSequence().getMicrosecondLength() / 1000000L);
        this.columnHeader = new ColumnHeaderPanel(n3, WIDTH_PER_BEAT * 4, n4, n2 / n4, n2, COLUMN_HEADER_HEIGHT);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && this.hoverNote == null && this.holdNote == null) {
            if (MainFrame.getInstance().getShowAsTickTime()) {
                MainFrame.getInstance().setPlayPosition(this.deviatedPerformance.getSequence().getTickLength() * (long)mouseEvent.getX() / (long)this.getPreferredSize().width);
            } else {
                MainFrame.getInstance().setPlayPosition(this.deviatedPerformance.getSequence().getMicrosecondLength() * (long)mouseEvent.getX() / (long)this.getPreferredSize().width);
            }
        } else if (mouseEvent.getButton() == 3 && this.hoverNote != null) {
            this.hoverNote = null;
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() != 1) {
            return;
        }
        if (this.selectedNote != null) {
            this.holdNote = this.selectedNote.getHandle(mouseEvent.getX(), mouseEvent.getY());
            if (this.holdNote != null) {
                try {
                    Point point = MouseInfo.getPointerInfo().getLocation();
                    Robot robot = new Robot();
                    robot.mouseMove(point.x + this.holdNote.press(mouseEvent.getX()), point.y);
                }
                catch (AWTException aWTException) {
                    aWTException.printStackTrace();
                }
                return;
            }
        }
        for (PrintableDeviatedNote printableDeviatedNote : this.deviatedNotes) {
            if (mouseEvent.getX() < printableDeviatedNote.x || mouseEvent.getX() > printableDeviatedNote.x + printableDeviatedNote.width || mouseEvent.getY() < printableDeviatedNote.y || mouseEvent.getY() > printableDeviatedNote.y + printableDeviatedNote.height || (printableDeviatedNote.voice & showVoice) <= 0) continue;
            this.deviatedNoteControler.select(printableDeviatedNote.deviatedNote);
            break;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.holdNote != null) {
            this.holdNote.release();
            this.holdNote = null;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.holdNote != null) {
            this.holdNote.drag(mouseEvent.getX());
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.holdNote == null) {
            this.hoverNote = null;
            for (PrintableDeviatedNote printableDeviatedNote : this.deviatedNotes) {
                if (!printableDeviatedNote.isMouseOver(mouseEvent.getX(), mouseEvent.getY()) || (printableDeviatedNote.voice & showVoice) <= 0) continue;
                this.hoverNote = printableDeviatedNote;
                if (printableDeviatedNote.isMouseOnRight(mouseEvent.getX(), mouseEvent.getY())) {
                    this.setCursor(Cursor.getPredefinedCursor(11));
                    break;
                }
                this.setCursor(Cursor.getPredefinedCursor(10));
                break;
            }
            if (this.hoverNote == null) {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            this.repaint();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.updateScale();
        this.repaint();
    }

    public void noteSelected(DeviatedPerformance.DeviatedNote deviatedNote) {
        this.selectedNote = this.dn2pdn.get(deviatedNote);
        this.hoverNote = null;
        this.repaint();
    }

    public void noteUpdated(DeviatedPerformance.DeviatedNote deviatedNote) {
        this.dn2pdn.get(deviatedNote).updateScale();
        this.repaint();
    }

    public void paint(Graphics graphics) {
        int n;
        super.paint(graphics);
        graphics.setColor(Color.BLACK);
        if (!MainFrame.getInstance().getShowAsTickTime()) {
            int n2 = 2 * this.getPreferredSize().width / (int)(this.deviatedPerformance.getSequence().getMicrosecondLength() / 1000000L);
            for (n = 0; n < this.getPreferredSize().width; n += n2) {
                graphics.drawLine(n, 0, n, this.getHeight());
            }
        } else {
            MusicXMLWrapper musicXMLWrapper = this.deviatedPerformance.getMusicXML();
            for (n = 1; n < musicXMLWrapper.getPartList()[0].getMeasureList().length; ++n) {
                int n3 = musicXMLWrapper.getCumulativeTicks(n, DeviatedPerformance.TICKS_PER_BEAT);
                n3 = n3 * WIDTH_PER_BEAT / DeviatedPerformance.TICKS_PER_BEAT;
                graphics.drawLine(n3, 0, n3, this.getHeight());
            }
        }
        for (PrintableNote printableNote : this.allNotes) {
            printableNote.paint(graphics);
        }
        if (this.hoverNote != null) {
            this.hoverNote.paintAsHover(graphics);
        }
        if (this.selectedNote != null) {
            this.selectedNote.paintAsSelected(graphics);
        }
        graphics.setColor(Color.BLUE);
        graphics.fillRect(this.playingLine - 1, 0, 3, this.getHeight());
    }

    public DeviatedPerformance getDeviatedPerformance() {
        return this.deviatedPerformance;
    }

    public ColumnHeaderPanel getColumnHeader() {
        return this.columnHeader;
    }

    public int getPlayPointX(double d, long l) {
        this.playingLine = MainFrame.getInstance().getShowAsTickTime() ? (int)((long)this.getPreferredSize().width * l / this.deviatedPerformance.getSequence().getTickLength()) : (int)((double)this.getPreferredSize().width * d * 1000000.0 / (double)this.deviatedPerformance.getSequence().getMicrosecondLength());
        return this.playingLine;
    }

    public void updateScale() {
        int n = (int)this.deviatedPerformance.getSequence().getTickLength();
        int n2 = WIDTH_PER_BEAT * n / DeviatedPerformance.TICKS_PER_BEAT;
        this.setPreferredSize(new Dimension(n2, HEIGHT_PER_NOTE * 128));
        for (PrintableNote printableNote : this.allNotes) {
            printableNote.updateScale();
        }
        this.columnHeader.setPreferredSize(new Dimension(n2, COLUMN_HEADER_HEIGHT));
        this.columnHeader.widthPerMeasure = PianoRollPanel.WIDTH_PER_BEAT * 4;
        int n3 = (int)(this.deviatedPerformance.getSequence().getMicrosecondLength() / 1000000L);
        this.columnHeader.widthPerSecond = n2 / n3;
    }

    public boolean isShowing(DeviatedPerformance.DeviatedNote deviatedNote) {
        return (this.dn2pdn.get(deviatedNote).voice & showVoice) > 0;
    }

    public Color getNoteColor(DeviatedPerformance.DeviatedNote deviatedNote) {
        return this.dn2pdn.get(deviatedNote).roundColor;
    }

    public static void toggleExtra(boolean bl) {
        showVoice = bl ? (short)(showVoice | 1) : (short)(showVoice & 0x3E);
    }

    public static void toggleVoice1(boolean bl) {
        showVoice = bl ? (short)(showVoice | 2) : (short)(showVoice & 0x3D);
    }

    public static void toggleVoice2(boolean bl) {
        showVoice = bl ? (short)(showVoice | 4) : (short)(showVoice & 0x3B);
    }

    public static void toggleVoice3(boolean bl) {
        showVoice = bl ? (short)(showVoice | 8) : (short)(showVoice & 0x37);
    }

    public static void toggleVoice4(boolean bl) {
        showVoice = bl ? (short)(showVoice | 0x10) : (short)(showVoice & 0x2F);
    }

    public static void toggleVoiceOther(boolean bl) {
        showVoice = bl ? (short)(showVoice | 0x20) : (short)(showVoice & 0x1F);
    }

    private class ColumnHeaderPanel
    extends JPanel {
        private int measureNum;
        private int widthPerMeasure;
        private int seconds;
        private int widthPerSecond;

        public ColumnHeaderPanel(int n, int n2, int n3, int n4, int n5, int n6) {
            this.measureNum = n;
            this.widthPerMeasure = n2;
            this.seconds = n3;
            this.widthPerSecond = n4;
            this.setPreferredSize(new Dimension(n5, n6));
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            graphics.setColor(Color.BLACK);
            if (MainFrame.getInstance().getShowAsTickTime()) {
                for (int i = 0; i < this.measureNum; ++i) {
                    graphics.drawString(i + 1 + "", i * this.widthPerMeasure, COLUMN_HEADER_HEIGHT);
                }
            } else {
                for (int i = 0; i < this.seconds; i += 2) {
                    graphics.drawString(i / 60 + ":" + i % 60, i * this.widthPerSecond, COLUMN_HEADER_HEIGHT);
                }
            }
        }
    }

    private class PrintableDeviatedNote
    extends PrintableNote {
        private DeviatedPerformance.DeviatedNote deviatedNote;
        private Color fillColor;
        private Color roundColor;
        private short voice;

        public PrintableDeviatedNote(DeviatedPerformance.DeviatedNote deviatedNote) {
            this.deviatedNote = deviatedNote;
            this.updateScale();
            this.y = HEIGHT_PER_NOTE * (127 - deviatedNote.notenum());
            this.height = HEIGHT_PER_NOTE;
        }

        public void paint(Graphics graphics) {
            if ((showVoice & this.voice) > 0) {
                graphics.setColor(this.fillColor);
                graphics.fillRect(this.x, this.y, this.width, this.height);
                graphics.setColor(this.roundColor);
                graphics.drawRect(this.x + 1, this.y + 1, this.width - 3, this.height - 3);
            }
        }

        public void paintAsHover(Graphics graphics) {
            graphics.setColor(this.roundColor);
            graphics.fillRect(this.x - 5, this.y - 5, this.width + 10, this.height + 10);
        }

        public void paintAsSelected(Graphics graphics) {
            graphics.setColor(Color.BLACK);
            for (int i = 0; i < 3; ++i) {
                graphics.drawRect(this.x - i, this.y - i, this.width + i * 2, this.height + i * 2);
            }
        }

        void updateScale() {
            if (MainFrame.getInstance().getShowAsTickTime()) {
                int n = DeviatedPerformance.TICKS_PER_BEAT;
                this.x = this.deviatedNote.onset() * WIDTH_PER_BEAT / n;
                this.width = (this.deviatedNote.offset() - this.deviatedNote.onset()) * WIDTH_PER_BEAT / n;
            } else {
                int n = PianoRollPanel.this.getPreferredSize().width;
                int n2 = (int)(PianoRollPanel.this.getDeviatedPerformance().getSequence().getMicrosecondLength() / 1000L);
                this.x = n * this.deviatedNote.onsetInMSec() / n2;
                this.width = n * (this.deviatedNote.offsetInMSec() - this.deviatedNote.onsetInMSec()) / n2;
            }
            if (this.deviatedNote.isExtraNote()) {
                this.voice = 1;
                this.fillColor = new Color(255, 255, 0, this.deviatedNote.velocity() * 2);
                this.roundColor = Color.YELLOW;
            } else if (this.deviatedNote.getNote().voice() == 1) {
                this.voice = (short)2;
                this.fillColor = new Color(255, 0, 0, this.deviatedNote.velocity() * 2);
                this.roundColor = Color.RED;
            } else if (this.deviatedNote.getNote().voice() == 2) {
                this.voice = (short)4;
                this.fillColor = new Color(255, 127, 0, this.deviatedNote.velocity() * 2);
                this.roundColor = Color.ORANGE;
            } else if (this.deviatedNote.getNote().voice() == 3) {
                this.voice = (short)8;
                this.fillColor = new Color(255, 175, 175, this.deviatedNote.velocity() * 2);
                this.roundColor = Color.PINK;
            } else if (this.deviatedNote.getNote().voice() == 4) {
                this.voice = (short)16;
                this.fillColor = new Color(255, 0, 255, this.deviatedNote.velocity() * 2);
                this.roundColor = Color.MAGENTA;
            } else {
                this.voice = (short)32;
                this.fillColor = new Color(255, 0, 127, this.deviatedNote.velocity() * 2);
                this.roundColor = new Color(255, 0, 127);
            }
        }

        public boolean isMouseOver(int n, int n2) {
            return n > this.x && n < this.x + this.width && n2 > this.y && n2 < this.y + this.height;
        }

        public boolean isMouseOnRight(int n, int n2) {
            return this.isMouseOver(n, n2) && n > this.x + this.width / 2;
        }

        public NoteMoveHandle getHandle(int n, int n2) {
            if (this.isMouseOver(n, n2)) {
                if (n > this.x + this.width / 2) {
                    return new NoteMoveHandle(false, this.x, this.x, this.width);
                }
                return new NoteMoveHandle(true, this.x + this.width, this.x, this.width);
            }
            return null;
        }

        class NoteMoveHandle {
            private boolean noteon;
            private int limit;
            private int prevX;
            private int prevWidth;

            private NoteMoveHandle(boolean bl, int n, int n2, int n3) {
                this.noteon = bl;
                this.limit = n;
                this.prevX = n2;
                this.prevWidth = n3;
            }

            public int press(int n) {
                if (this.noteon) {
                    return this.prevX - n;
                }
                return this.prevX + this.prevWidth - n;
            }

            public void drag(int n) {
                if (this.noteon) {
                    PrintableDeviatedNote.this.x = Math.min(n, this.limit - 1);
                    PrintableDeviatedNote.this.width = this.limit - PrintableDeviatedNote.this.x;
                } else {
                    PrintableDeviatedNote.this.width = Math.max(n - PrintableDeviatedNote.this.x, 1);
                }
            }

            public void release() {
                if (MainFrame.getInstance().getShowAsTickTime()) {
                    if (this.noteon) {
                        ChangeDeviation changeDeviation = new ChangeDeviation(PrintableDeviatedNote.this.deviatedNote, (double)(PrintableDeviatedNote.this.x - this.prevX) / (double)WIDTH_PER_BEAT, 0.0);
                        PianoRollPanel.this.deviatedNoteControler.update(changeDeviation);
                    } else {
                        ChangeDeviation changeDeviation = new ChangeDeviation(PrintableDeviatedNote.this.deviatedNote, 0.0, (double)(PrintableDeviatedNote.this.width - this.prevWidth) / (double)WIDTH_PER_BEAT);
                        PianoRollPanel.this.deviatedNoteControler.update(changeDeviation);
                    }
                } else {
                    int n = (int)(PianoRollPanel.this.getDeviatedPerformance().getSequence().getMicrosecondLength() / 1000L);
                    int n2 = PianoRollPanel.this.getPreferredSize().width;
                    if (this.noteon) {
                        PianoRollPanel.this.deviatedNoteControler.update(new ChangeAttackInMSec(PrintableDeviatedNote.this.deviatedNote, PrintableDeviatedNote.this.x * n / n2));
                    } else {
                        PianoRollPanel.this.deviatedNoteControler.update(new ChangeReleaseInMSec(PrintableDeviatedNote.this.deviatedNote, (PrintableDeviatedNote.this.x + PrintableDeviatedNote.this.width) * n / n2));
                    }
                }
            }
        }
    }

    private class PrintableOriginalNote
    extends PrintableNote {
        private int onset;
        private int offset;
        private int onsetInMSec;
        private int offsetInMSec;

        public PrintableOriginalNote(DeviatedPerformance.DeviatedNote deviatedNote) {
            this.onset = deviatedNote.onsetOriginal();
            this.offset = deviatedNote.offsetOriginal();
            this.onsetInMSec = deviatedNote.onsetOriginalInMSec();
            this.offsetInMSec = deviatedNote.offsetOriginalInMSec();
            this.y = HEIGHT_PER_NOTE * (127 - deviatedNote.notenum());
            this.height = HEIGHT_PER_NOTE;
            this.updateScale();
        }

        public void paint(Graphics graphics) {
            graphics.setColor(Color.BLACK);
            graphics.drawRect(this.x, this.y, this.width - 1, this.height - 1);
        }

        void updateScale() {
            if (MainFrame.getInstance().getShowAsTickTime()) {
                int n = DeviatedPerformance.TICKS_PER_BEAT;
                this.x = this.onset * WIDTH_PER_BEAT / n;
                this.width = (this.offset - this.onset) * WIDTH_PER_BEAT / n;
            } else {
                int n = PianoRollPanel.this.getPreferredSize().width;
                int n2 = (int)(PianoRollPanel.this.getDeviatedPerformance().getSequence().getMicrosecondLength() / 1000L);
                this.x = n * this.onsetInMSec / n2;
                this.width = n * (this.offsetInMSec - this.onsetInMSec) / n2;
            }
        }
    }

    private abstract class PrintableNote {
        int x;
        int y;
        int width;
        int height;

        private PrintableNote() {
        }

        abstract void updateScale();

        abstract void paint(Graphics var1);
    }
}

