/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jp.crestmuse.cmx.amusaj.filewrappers.MutableTimeSeries;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.sp.ProducerConsumerCompatible;
import jp.crestmuse.cmx.amusaj.sp.SPIllegalConnectionException;
import jp.crestmuse.cmx.amusaj.sp.SPTerminator;
import jp.crestmuse.cmx.misc.QueueReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPExecutor {
    private List<SPExecutorModule> modules = new LinkedList<SPExecutorModule>();
    private Map<ProducerConsumerCompatible, SPExecutorModule> map = new HashMap<ProducerConsumerCompatible, SPExecutorModule>();
    private long sleepTime = 0L;
    private volatile int nFinished = 0;
    private Thread intReceiver = null;

    public void addSPModule(ProducerConsumerCompatible producerConsumerCompatible) {
        SPExecutorModule sPExecutorModule = new SPExecutorModule(producerConsumerCompatible);
        this.modules.add(sPExecutorModule);
        this.map.put(producerConsumerCompatible, sPExecutorModule);
    }

    public void connect(ProducerConsumerCompatible producerConsumerCompatible, int n, ProducerConsumerCompatible producerConsumerCompatible2, int n2) {
        try {
            producerConsumerCompatible.getOutputClasses()[n].asSubclass(producerConsumerCompatible2.getInputClasses()[n2]);
        }
        catch (ClassCastException classCastException) {
            try {
                producerConsumerCompatible2.getInputClasses()[n2].asSubclass(producerConsumerCompatible.getOutputClasses()[n]);
            }
            catch (ClassCastException classCastException2) {
                throw new SPIllegalConnectionException("can't connect " + producerConsumerCompatible.getOutputClasses()[n].getName() + " and " + producerConsumerCompatible2.getInputClasses()[n2].getName());
            }
        }
        SPExecutorModule sPExecutorModule = this.map.get(producerConsumerCompatible);
        SPExecutorModule sPExecutorModule2 = this.map.get(producerConsumerCompatible2);
        sPExecutorModule2.src[n2] = sPExecutorModule.dest[n].getQueueReader();
    }

    public void start() {
        for (SPExecutorModule sPExecutorModule : this.modules) {
            sPExecutorModule.start();
        }
    }

    public void stop() {
        for (SPExecutorModule sPExecutorModule : this.modules) {
            sPExecutorModule.interrupt();
        }
    }

    public boolean finished() {
        for (SPExecutorModule sPExecutorModule : this.modules) {
            if (!sPExecutorModule.isAlive()) continue;
            return false;
        }
        return true;
    }

    public boolean finished(ProducerConsumerCompatible producerConsumerCompatible) {
        return !this.map.get(producerConsumerCompatible).isAlive();
    }

    private synchronized void checkFinished() {
        if (this.intReceiver != null && this.nFinished >= this.modules.size()) {
            this.intReceiver.interrupt();
        }
    }

    public void setInterruptionReceiver(Thread thread) {
        this.intReceiver = thread;
    }

    public List<TimeSeriesCompatible> getResult(ProducerConsumerCompatible producerConsumerCompatible) {
        return Arrays.asList(this.map.get((Object)producerConsumerCompatible).dest);
    }

    public void setSleepTime(long l) {
        this.sleepTime = l;
    }

    private class SPExecutorModule
    extends Thread {
        ProducerConsumerCompatible module;
        QueueReader[] src;
        TimeSeriesCompatible[] dest;
        Object[] inputElements;
        int inputChannelNum;
        int outputChannelNum;

        SPExecutorModule(ProducerConsumerCompatible producerConsumerCompatible) {
            this.inputChannelNum = producerConsumerCompatible.getInputClasses().length;
            this.outputChannelNum = producerConsumerCompatible.getOutputClasses().length;
            this.module = producerConsumerCompatible;
            this.src = new QueueReader[this.inputChannelNum];
            this.dest = new TimeSeriesCompatible[this.outputChannelNum];
            this.inputElements = new Object[this.inputChannelNum];
            for (int i = 0; i < this.outputChannelNum; ++i) {
                this.dest[i] = new MutableTimeSeries();
            }
        }

        public void run() {
            while (!Thread.interrupted()) {
                try {
                    for (int i = 0; i < this.inputChannelNum; ++i) {
                        this.inputElements[i] = this.src[i].take();
                    }
                    if (this.inputChannelNum > 0 && this.inputElements[0] instanceof SPTerminator) {
                        this.module.terminated(this.dest);
                        for (TimeSeriesCompatible timeSeriesCompatible : this.dest) {
                            timeSeriesCompatible.add(SPTerminator.getInstance());
                        }
                        break;
                    }
                    this.module.execute(this.inputElements, this.dest);
                    if (this.outputChannelNum > 0 && this.dest[0].isComplete()) break;
                    Thread.sleep(SPExecutor.this.sleepTime);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    break;
                }
            }
            this.module.stop();
            SPExecutor.this.nFinished++;
            SPExecutor.this.checkFinished();
        }
    }
}

