/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.commands;

import jp.crestmuse.cmx.amusaj.commands.ModuleConnection;
import jp.crestmuse.cmx.amusaj.commands.NotewiseWAVAnalyzer;
import jp.crestmuse.cmx.amusaj.commands.OutputData;
import jp.crestmuse.cmx.amusaj.sp.AmusaParameterSet;
import jp.crestmuse.cmx.amusaj.sp.FeatureExtractionModule2;
import jp.crestmuse.cmx.amusaj.sp.HarmonicsExtractor2;
import jp.crestmuse.cmx.amusaj.sp.HarmonicsTimeSeriesGenerator;
import jp.crestmuse.cmx.amusaj.sp.KitaharaFeatureExtractor;
import jp.crestmuse.cmx.amusaj.sp.PeakExtractor;
import jp.crestmuse.cmx.amusaj.sp.ProducerConsumerCompatible;
import jp.crestmuse.cmx.amusaj.sp.STFT;
import jp.crestmuse.cmx.filewrappers.SCCXMLWrapper;
import jp.crestmuse.cmx.math.Operations;

public class WAV2TBDnotewise
extends NotewiseWAVAnalyzer {
    private boolean paramSet = false;
    private ProducerConsumerCompatible stft;
    private ProducerConsumerCompatible peakext;
    private ProducerConsumerCompatible he;
    private ProducerConsumerCompatible htsg;
    private ProducerConsumerCompatible fe;

    protected boolean setOptionsLocal(String string, String string2) {
        AmusaParameterSet amusaParameterSet = AmusaParameterSet.getInstance();
        if (super.setOptionsLocal(string, string2)) {
            return true;
        }
        if (string.equals("-from") || string.equals("-f")) {
            amusaParameterSet.setParam("feature", "NOTENUMBER_FROM", String.valueOf(string2));
            return true;
        }
        if (string.equals("-thru") || string.equals("-t")) {
            amusaParameterSet.setParam("feature", "NOTENUMBER_THRU", String.valueOf(string2));
            return true;
        }
        if (string.equals("-step")) {
            amusaParameterSet.setParam("feature", "STEP", String.valueOf(string2));
            return true;
        }
        return false;
    }

    protected ProducerConsumerCompatible[] getUsedModules(SCCXMLWrapper.Note note) {
        this.stft = new STFT(this.usesStereo());
        return new ProducerConsumerCompatible[]{this.stft, this.peakext = new PeakExtractor(), this.he = new HarmonicsExtractor2(Operations.nn2Hz(note.notenum())), this.htsg = new HarmonicsTimeSeriesGenerator(), this.fe = new FeatureExtractionModule2(new KitaharaFeatureExtractor(3, 10))};
    }

    protected ModuleConnection[] getModuleConnections() {
        return new ModuleConnection[]{new ModuleConnection(this.getWindowSlider(), 0, this.stft, 0), new ModuleConnection(this.stft, 0, this.peakext, 0), new ModuleConnection(this.stft, 1, this.peakext, 1), new ModuleConnection(this.stft, 2, this.peakext, 2), new ModuleConnection(this.peakext, 0, this.he, 0), new ModuleConnection(this.he, 0, this.htsg, 0), new ModuleConnection(this.htsg, 0, this.fe, 0)};
    }

    protected String getAmusaXMLFormat() {
        return "array";
    }

    protected OutputData[] getOutputData() {
        return new OutputData[]{new OutputData(this.fe, 0)};
    }

    public static void main(String[] stringArray) {
        WAV2TBDnotewise wAV2TBDnotewise = new WAV2TBDnotewise();
        try {
            wAV2TBDnotewise.start(stringArray);
        }
        catch (Exception exception) {
            wAV2TBDnotewise.showErrorMessage(exception);
            System.exit(1);
        }
    }

    static {
        WAV2TBDnotewise.addOptionHelpMessage("-f <nn>", "lower bound note number for analysis");
        WAV2TBDnotewise.addOptionHelpMessage("-t <nn>", "uppper bound note number for analysis");
        WAV2TBDnotewise.addOptionHelpMessage("-step <nn>", "");
    }
}

