/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.filewrappers;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import jp.crestmuse.cmx.amusaj.filewrappers.AmusaDataSetCompatible;
import jp.crestmuse.cmx.amusaj.filewrappers.AmusaXMLWrapper;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.sp.AmusaParameterSet;
import jp.crestmuse.cmx.amusaj.sp.SPTerminator;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.misc.Encodable;
import jp.crestmuse.cmx.misc.PrintStreamWrapper;
import jp.crestmuse.cmx.misc.PrintWriterWrapper;
import jp.crestmuse.cmx.misc.Printable;
import jp.crestmuse.cmx.misc.QueueReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmusaDataSet<D extends TimeSeriesCompatible>
implements AmusaDataSetCompatible<D> {
    private AmusaParameterSet params;
    private List<D> data;
    String fmt;

    AmusaDataSet() {
        this.params = AmusaParameterSet.getInstance();
        this.data = new ArrayList<D>();
    }

    public AmusaDataSet(String string) {
        this.fmt = string;
        this.params = AmusaParameterSet.getInstance();
        this.data = new ArrayList<D>();
    }

    @Override
    public String getHeader(String string, String string2) {
        return this.params.getParam(string, string2);
    }

    @Override
    public int getHeaderInt(String string, String string2) {
        return Integer.parseInt(this.getHeader(string, string2));
    }

    @Override
    public double getHeaderDouble(String string, String string2) {
        return Double.parseDouble(this.getHeader(string, string2));
    }

    @Override
    public boolean containsHeaderKey(String string, String string2) {
        return this.params.containsParam(string, string2);
    }

    void setHeader(String string, String string2) {
        this.params.setParam(string, string2);
    }

    @Override
    public void setHeader(String string, String string2, String string3) {
        this.params.setParam(string, string2, string3);
    }

    @Override
    public void setHeader(String string, String string2, int n) {
        this.setHeader(string, string2, String.valueOf(n));
    }

    @Override
    public void setHeader(String string, String string2, double d) {
        this.setHeader(string, string2, String.valueOf(d));
    }

    @Override
    public void add(D d) {
        this.data.add(d);
    }

    @Override
    public List<D> getDataList() {
        return this.data;
    }

    public AmusaXMLWrapper toWrapper() throws IOException, InterruptedException {
        AmusaXMLWrapper amusaXMLWrapper = (AmusaXMLWrapper)CMXFileWrapper.createDocument("amusaxml");
        amusaXMLWrapper.setAttribute("format", this.fmt);
        amusaXMLWrapper.addChild("header");
        Set<String> set = this.params.keySet();
        for (String object : set) {
            amusaXMLWrapper.addChild("meta");
            amusaXMLWrapper.setAttribute("name", object);
            amusaXMLWrapper.setAttribute("content", this.params.getParam(object));
            amusaXMLWrapper.returnToParent();
        }
        amusaXMLWrapper.returnToParent();
        for (TimeSeriesCompatible timeSeriesCompatible : this.data) {
            Object object;
            int n = 0;
            QueueReader queueReader = timeSeriesCompatible.getQueueReader();
            StringBuilder stringBuilder = new StringBuilder();
            while (!((object = queueReader.take()) instanceof SPTerminator)) {
                if (object instanceof Encodable) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("\n");
                    }
                    stringBuilder.append(((Encodable)object).encode());
                    ++n;
                    continue;
                }
                throw new UnsupportedOperationException("The objects should be Encodable to be written in an XML format.");
            }
            amusaXMLWrapper.addChild("data");
            object = timeSeriesCompatible.getAttributeIterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                amusaXMLWrapper.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
            amusaXMLWrapper.setAttribute("frames", n);
            if (timeSeriesCompatible.dim() > 0) {
                amusaXMLWrapper.setAttribute("dim", timeSeriesCompatible.dim());
            }
            amusaXMLWrapper.addText(stringBuilder.toString());
            amusaXMLWrapper.returnToParent();
        }
        amusaXMLWrapper.finalizeDocument();
        return amusaXMLWrapper;
    }

    @Override
    public String getFileName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        this.write(new PrintStreamWrapper(new PrintStream(outputStream)));
    }

    @Override
    public void write(Writer writer) throws IOException {
        this.write(new PrintWriterWrapper(new PrintWriter(writer)));
    }

    @Override
    public void writefile(File file) throws IOException {
        this.write(new PrintStreamWrapper(new PrintStream(file)));
    }

    @Override
    public void writeGZippedFile(File file) throws IOException {
        this.write(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(file))));
    }

    private void write(Printable printable) throws IOException {
        try {
            printable.println("<amusaxml format=\"" + this.fmt + "\">");
            printable.println("  <header>");
            Set<String> set = this.params.keySet();
            for (String object : set) {
                printable.println("    <meta name=\"" + object + "\" content=\"" + this.params.getParam(object) + "\" />");
            }
            printable.println("  </header>");
            for (TimeSeriesCompatible timeSeriesCompatible : this.data) {
                Object d;
                QueueReader queueReader = timeSeriesCompatible.getQueueReader();
                LinkedList linkedList = new LinkedList();
                do {
                    d = queueReader.take();
                    linkedList.add(d);
                } while (!(d instanceof SPTerminator));
                StringBuilder stringBuilder = new StringBuilder();
                timeSeriesCompatible.setAttribute("frames", linkedList.size() - 1);
                if (timeSeriesCompatible.dim() > 0) {
                    timeSeriesCompatible.setAttribute("dim", timeSeriesCompatible.dim());
                }
                Iterator<Map.Entry<String, String>> iterator = timeSeriesCompatible.getAttributeIterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> entry = iterator.next();
                    stringBuilder.append(" ").append(entry.getKey()).append("=\"").append(entry.getValue()).append("\"");
                }
                printable.println("  <data" + stringBuilder.toString() + ">");
                for (Object e : linkedList) {
                    if (e instanceof SPTerminator) break;
                    if (e instanceof Encodable) {
                        printable.println(((Encodable)e).encode());
                        continue;
                    }
                    throw new UnsupportedOperationException("The objects should be Encodable to be written in an XML format.");
                }
                printable.println("  </data>");
            }
            printable.println("</amusaxml>");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

