/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.filewrappers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import jp.crestmuse.cmx.amusaj.filewrappers.AmusaDataSet;
import jp.crestmuse.cmx.amusaj.filewrappers.AmusaDecoder;
import jp.crestmuse.cmx.amusaj.filewrappers.MutableTimeSeries;
import jp.crestmuse.cmx.amusaj.sp.SPTerminator;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SimpleAmusaXMLReader {
    private static final String PARSER_CLASS = "org.apache.xerces.parsers.SAXParser";

    public static AmusaDataSet readfile(String string) throws SAXException, IOException {
        return SimpleAmusaXMLReader.readfile(string, AmusaDecoder.getInstance());
    }

    public static AmusaDataSet readfile(String string, AmusaDecoder amusaDecoder) throws SAXException, IOException {
        XMLReader xMLReader = XMLReaderFactory.createXMLReader(PARSER_CLASS);
        AmusaDataSet amusaDataSet = new AmusaDataSet();
        AmusaXMLContentHandler amusaXMLContentHandler = new AmusaXMLContentHandler(amusaDataSet, amusaDecoder);
        xMLReader.setContentHandler(amusaXMLContentHandler);
        InputSource inputSource = new InputSource(new FileInputStream(new File(string)));
        xMLReader.parse(inputSource);
        return amusaDataSet;
    }

    public static void main(String[] stringArray) {
        try {
            AmusaDataSet amusaDataSet = SimpleAmusaXMLReader.readfile(stringArray[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    private static class AmusaXMLContentHandler
    implements ContentHandler {
        private AmusaDecoder decoder;
        private String format = null;
        private String currentTagName = null;
        private AmusaDataSet dataset;
        private MutableTimeSeries ts;
        private StringBuilder sb;
        private int nFrames;
        private int dim;

        private AmusaXMLContentHandler(AmusaDataSet amusaDataSet, AmusaDecoder amusaDecoder) {
            this.dataset = amusaDataSet;
            this.decoder = amusaDecoder;
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() {
        }

        public void endDocument() {
        }

        public void startPrefixMapping(String string, String string2) {
        }

        public void endPrefixMapping(String string) {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string2.equals("amusaxml")) {
                this.dataset.fmt = this.format = attributes.getValue("format");
            } else if (string2.equals("header")) {
                this.currentTagName = "header";
            } else if (string2.equals("meta")) {
                if (!"header".equals(this.currentTagName)) {
                    throw new SAXException("'meta' should be in 'header'.");
                }
                this.dataset.setHeader(attributes.getValue("name"), attributes.getValue("content"));
            } else if (string2.equals("data")) {
                this.currentTagName = "data";
                this.nFrames = Integer.parseInt(attributes.getValue("frames"));
                String string4 = attributes.getValue(this.dim);
                this.dim = string4 == null ? -1 : Integer.parseInt(string4);
                String string5 = attributes.getValue("timeunit");
                int n = string5 == null ? -1 : Integer.parseInt(string5);
                this.ts = new MutableTimeSeries();
                int n2 = attributes.getLength();
                for (int i = 0; i < n2; ++i) {
                    this.ts.setAttribute(attributes.getLocalName(i), attributes.getValue(i));
                }
                this.sb = new StringBuilder();
            }
        }

        public void endElement(String string, String string2, String string3) {
            if ("data".equals(this.currentTagName)) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.sb.toString());
                try {
                    for (int i = 0; i < this.nFrames; ++i) {
                        this.ts.add(this.decoder.decode(stringTokenizer, this.format, this.dim));
                    }
                    this.ts.add(SPTerminator.getInstance());
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                this.dataset.add(this.ts);
                this.currentTagName = null;
            }
        }

        public void characters(char[] cArray, int n, int n2) {
            if ("data".equals(this.currentTagName)) {
                this.sb.append(cArray, n, n2);
            }
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) {
        }

        public void processingInstruction(String string, String string2) {
        }

        public void skippedEntity(String string) {
        }
    }
}

