/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import jp.crestmuse.cmx.amusaj.filewrappers.PeakSet;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.sp.AmusaParameterSet;
import jp.crestmuse.cmx.amusaj.sp.SPModule;
import jp.crestmuse.cmx.math.DoubleArray;
import jp.crestmuse.cmx.math.DoubleArrayFactory;
import jp.crestmuse.cmx.math.Operations;

public class ChromaExtractor
extends SPModule {
    private static final DoubleArrayFactory factory = DoubleArrayFactory.getFactory();
    private static final double Q = 60.0;
    private double fL = 20.0;
    private double fH = Double.POSITIVE_INFINITY;
    private boolean paramSet = false;

    public void execute(Object[] objectArray, TimeSeriesCompatible[] timeSeriesCompatibleArray) throws InterruptedException {
        PeakSet peakSet = (PeakSet)objectArray[0];
        timeSeriesCompatibleArray[0].add(this.calcChroma(peakSet));
    }

    private void setParams() {
        AmusaParameterSet amusaParameterSet = AmusaParameterSet.getInstance();
        if (amusaParameterSet.containsParam("chroma", "CHROMA_LOW_LIMIT_FREQ")) {
            this.fL = amusaParameterSet.getParamDouble("chroma", "CHROMA_LOW_LIMIT_FREQ");
        }
        if (amusaParameterSet.containsParam("chroma", "CHROMA_HIGH_LIMIT_FREQ")) {
            this.fH = amusaParameterSet.getParamDouble("chroma", "CHROMA_HIGH_LIMIT_FREQ");
        }
        this.paramSet = true;
    }

    private DoubleArray calcChroma(PeakSet peakSet) {
        if (!this.paramSet) {
            this.setParams();
        }
        DoubleArray doubleArray = factory.createArray(12);
        int n = peakSet.nPeaks();
        for (int i = 0; i < n; ++i) {
            double d = peakSet.freq(i);
            if (d < this.fL || d > this.fH) continue;
            int n2 = ChromaExtractor.Hz2nn(d);
            double d2 = ChromaExtractor.nn2Hz(n2);
            double d3 = d2 - d;
            double d4 = d2 / 60.0;
            double d5 = Math.exp(-d3 * d3 / (2.0 * d4 * d4));
            doubleArray.set(n2 % 12, d5 * peakSet.power(i));
            d2 = ChromaExtractor.nn2Hz(n2 + 1);
            d3 = d2 - d;
            d4 = d2 / 60.0;
            d5 = Math.exp(-d3 * d3 / (2.0 * d4 * d4));
            doubleArray.set((n2 + 1) % 12, d5 * peakSet.power(i));
        }
        double d = Operations.sum(doubleArray);
        if (d > 0.0) {
            Operations.divX(doubleArray, d);
        }
        return doubleArray;
    }

    public Class[] getInputClasses() {
        return new Class[]{PeakSet.class};
    }

    public Class[] getOutputClasses() {
        return new Class[]{DoubleArray.class};
    }

    private static int Hz2nn(double d) {
        return 57 + (int)(12.0 * Math.log(d / 220.0) / Math.log(2.0));
    }

    private static double nn2Hz(int n) {
        return 220.0 * Math.pow(2.0, (double)(n - 57) / 12.0);
    }
}

