/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import java.io.File;
import java.io.IOException;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Track;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.sp.MidiEventWithTicktime;
import jp.crestmuse.cmx.amusaj.sp.SPModule;

public class MidiRecorder
extends SPModule {
    private int ticksPerBeat;
    private String filename;
    private Sequence seq;
    private Track track;

    public MidiRecorder(String string, int n) {
        try {
            this.seq = new Sequence(0.0f, n);
            this.track = this.seq.createTrack();
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
        }
        this.filename = string;
        this.ticksPerBeat = n;
    }

    public void execute(Object[] objectArray, TimeSeriesCompatible[] timeSeriesCompatibleArray) throws InterruptedException {
        MidiEventWithTicktime midiEventWithTicktime = (MidiEventWithTicktime)objectArray[0];
        this.track.add(new MidiEvent(midiEventWithTicktime.getMessage(), midiEventWithTicktime.music_position));
    }

    public void stop() {
        try {
            MidiSystem.write(this.seq, 1, new File(this.filename));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public Class[] getInputClasses() {
        return new Class[]{MidiEventWithTicktime.class};
    }

    public Class[] getOutputClasses() {
        return new Class[0];
    }
}

