/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.commands;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.commands.CMXCommand;
import jp.crestmuse.cmx.filewrappers.DeviationDataSet;
import jp.crestmuse.cmx.filewrappers.DeviationInstanceWrapper;
import jp.crestmuse.cmx.filewrappers.InvalidFileTypeException;
import jp.crestmuse.cmx.filewrappers.MusicXMLWrapper;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformanceRenderingTest1
extends CMXCommand<MusicXMLWrapper, DeviationInstanceWrapper> {
    public static void main(String[] stringArray) {
        PerformanceRenderingTest1 performanceRenderingTest1 = new PerformanceRenderingTest1();
        try {
            performanceRenderingTest1.start(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    protected DeviationInstanceWrapper run(MusicXMLWrapper musicXMLWrapper) throws IOException, ParserConfigurationException, SAXException, TransformerException, InvalidFileTypeException {
        MusicXMLWrapper.Part[] partArray;
        DeviationDataSet deviationDataSet = new DeviationDataSet(musicXMLWrapper);
        deviationDataSet.addNonPartwiseControl(1, 1.0, "tempo", 120.0);
        for (MusicXMLWrapper.Part part : partArray = musicXMLWrapper.getPartList()) {
            MusicXMLWrapper.Measure[] measureArray;
            System.out.println("Part " + part.id());
            for (MusicXMLWrapper.Measure measure : measureArray = part.getMeasureList()) {
                System.out.println("Measure " + measure.number());
                for (MusicXMLWrapper.MusicData musicData : measure.getMusicDataList()) {
                    this.makeExpressionOfNote(musicData, deviationDataSet);
                }
            }
        }
        return deviationDataSet.toWrapper();
    }

    private void makeExpressionOfNote(MusicXMLWrapper.MusicData musicData, DeviationDataSet deviationDataSet) {
        if (!(musicData instanceof MusicXMLWrapper.Note)) {
            return;
        }
        MusicXMLWrapper.Note note = (MusicXMLWrapper.Note)musicData;
        String string = "Note[" + note.noteName();
        if (!note.rest()) {
            string = string + ", " + note.notenum();
        }
        string = string + "] ";
        System.out.print(string);
        MusicXMLWrapper.Notations notations = note.getFirstNotations();
        if (notations != null) {
            if (notations.hasArticulation("staccato")) {
                System.out.print(" staccato");
                if (note.chordNotes() == null) {
                    deviationDataSet.addNoteDeviation(note, 0.0, -0.5 * (double)note.duration() / 4.0, 1.0, 1.0);
                } else {
                    System.out.print(" w/chord ");
                    deviationDataSet.addChordDeviation(note, 0.0, -0.5 * (double)note.duration() / 4.0, 1.0, 1.0);
                }
            }
            if (notations.fermataType() != null) {
                System.out.print(" fermata");
                deviationDataSet.addNonPartwiseControl(note.measure().number(), note.beat(), "tempo-deviation", 0.5);
            }
        }
        if (note.grace()) {
            deviationDataSet.addNoteDeviation(note, -0.125, 0.0, 1.2, 1.0);
        }
        System.out.println();
    }
}

