/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jp.crestmuse.cmx.commands.NoteEvent;
import jp.crestmuse.cmx.commands.TimeInSecForSMF2;
import jp.crestmuse.cmx.filewrappers.MIDIXMLWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeInSecForSMF {
    MIDIXMLWrapper.MIDIEvent[] tempolist;
    int currentTick0 = 0;
    MIDIXMLWrapper.MIDIEvent[] notelist;
    int currentTick1 = 0;
    double currentTempo = 120.0;
    int currentTempoTick;
    double currentTempoTimeInSec;
    int ticksPerBeat;
    static boolean isOn1 = false;
    static boolean isOn2 = false;
    static NoteEvent lastE1 = null;
    static NoteEvent lastE2 = null;

    TimeInSecForSMF(MIDIXMLWrapper mIDIXMLWrapper) {
        this.tempolist = mIDIXMLWrapper.getTrackList()[0].getMIDIEventList();
        this.notelist = mIDIXMLWrapper.getTrackList()[1].getMIDIEventList();
        this.ticksPerBeat = mIDIXMLWrapper.ticksPerBeat();
    }

    List<NoteEvent> calcTimeInSec() {
        ArrayList<NoteEvent> arrayList = new ArrayList<NoteEvent>();
        int n = 0;
        int n2 = 0;
        while (n < this.notelist.length) {
            double d;
            int n3;
            int n4 = n2 < this.tempolist.length ? this.tempolist[n2].deltaTime() + this.currentTick0 : Integer.MAX_VALUE;
            if (n4 <= (n3 = this.notelist[n].deltaTime() + this.currentTick1)) {
                if (this.tempolist[n2].messageType().equals("SetTempo")) {
                    d = (double)(n4 - this.currentTempoTick) * 60.0 / ((double)this.ticksPerBeat * this.currentTempo) + this.currentTempoTimeInSec;
                    this.currentTempo = 6.0E7 / (double)this.tempolist[n2].value(0);
                    this.currentTempoTick = n4;
                    this.currentTempoTimeInSec = d;
                }
                this.currentTick0 = n4;
                ++n2;
                continue;
            }
            if (this.notelist[n].messageType().startsWith("Note")) {
                d = (double)(n3 - this.currentTempoTick) * 60.0 / ((double)this.ticksPerBeat * this.currentTempo) + this.currentTempoTimeInSec;
                arrayList.add(new NoteEvent(d, this.notelist[n]));
            }
            this.currentTick1 = n3;
            ++n;
        }
        return arrayList;
    }

    static void compare(List<NoteEvent> list, List<NoteEvent> list2) {
        int n = list.size();
        int n2 = list2.size();
        int n3 = 0;
        int n4 = 0;
        block0: while (n3 < n || n4 < n2) {
            int n5;
            int n6;
            NoteEvent noteEvent;
            NoteEvent noteEvent2 = n3 < n ? list.get(n3) : null;
            NoteEvent noteEvent3 = noteEvent = n4 < n2 ? list2.get(n4) : null;
            if (noteEvent == null) {
                System.out.println(TimeInSecForSMF.makeString(noteEvent2, null));
                ++n3;
                ++n4;
                continue;
            }
            if (noteEvent2 == null) {
                System.out.println(TimeInSecForSMF.makeString(null, noteEvent));
                ++n3;
                ++n4;
                continue;
            }
            if (noteEvent.approxEquals(noteEvent2)) {
                System.out.println(TimeInSecForSMF.makeString(noteEvent2, noteEvent));
                ++n3;
                ++n4;
                continue;
            }
            for (n6 = 1; n6 < 10; ++n6) {
                if (!noteEvent2.approxEquals(n4 + n6 < n2 ? list2.get(n4 + n6) : null)) continue;
                for (n5 = 1; n5 <= n6; ++n5) {
                    System.out.println(TimeInSecForSMF.makeString(null, list2.get(n4++)));
                }
                continue block0;
            }
            for (n6 = 1; n6 < 10; ++n6) {
                if (!noteEvent.approxEquals(n3 + n6 < n ? list.get(n3 + n6) : null)) continue;
                for (n5 = 0; n5 < n6; ++n5) {
                    System.out.println(TimeInSecForSMF.makeString(list.get(n3++), null));
                }
                continue block0;
            }
            System.out.println(TimeInSecForSMF.makeString(noteEvent2, noteEvent));
            ++n3;
            ++n4;
        }
    }

    private static String makeString(NoteEvent noteEvent, NoteEvent noteEvent2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (noteEvent != null) {
            stringBuffer.append("[").append(noteEvent.toString()).append("]  ");
        } else {
            stringBuffer.append("[null]                    ");
        }
        if (noteEvent2 != null) {
            stringBuffer.append("[").append(noteEvent2.toString()).append("]");
        } else {
            stringBuffer.append("[null]                  ");
        }
        if (noteEvent != null && noteEvent2 != null && noteEvent.approxEquals(noteEvent2)) {
            stringBuffer.append("  ==> ok");
        } else if (!(noteEvent == null && !isOn2 && noteEvent2.msg.equals("NoteOff") || noteEvent2 == null && !isOn1 && noteEvent.msg.equals("NoteOff") || noteEvent == null && isOn1 && noteEvent2.msg.equals("NoteOff") || noteEvent2 == null && noteEvent.equals(lastE1))) {
            stringBuffer.append(" ==> diff");
        }
        if (noteEvent != null && noteEvent.msg.equals("NoteOn")) {
            isOn1 = true;
        } else if (noteEvent != null && noteEvent.msg.equals("NoteOff")) {
            isOn1 = false;
        }
        if (noteEvent2 != null && noteEvent2.msg.equals("NoteOn")) {
            isOn2 = true;
        } else if (noteEvent2 != null && noteEvent2.msg.equals("NoteOff")) {
            isOn2 = false;
        }
        lastE1 = noteEvent;
        lastE2 = noteEvent2;
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            TimeInSecForSMF2 timeInSecForSMF2 = new TimeInSecForSMF2(MIDIXMLWrapper.readSMF(stringArray[0]));
            List<NoteEvent> list = timeInSecForSMF2.calcTimeInSec();
            Collections.sort(list);
            TimeInSecForSMF timeInSecForSMF = new TimeInSecForSMF(MIDIXMLWrapper.readSMF(stringArray[1]));
            List<NoteEvent> list2 = timeInSecForSMF.calcTimeInSec();
            Collections.sort(list2);
            TimeInSecForSMF.compare(list, list2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

