/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.filewrappers;

import jp.crestmuse.cmx.filewrappers.UnsupportedNodeException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class NodeInterface {
    private Element node;
    private String nodename;

    protected NodeInterface(Node node) {
        this.nodename = node.getNodeName();
        if (this.nodename.equals(this.getSupportedNodeName())) {
            this.node = (Element)node;
        } else if (this.getSupportedNodeName().indexOf(this.nodename) >= 0) {
            this.node = (Element)node;
        } else {
            throw new UnsupportedNodeException("Unsupported node: " + node.getNodeName());
        }
    }

    protected final Node node() {
        return this.node;
    }

    protected abstract String getSupportedNodeName();

    public final String getNodeName() {
        return this.nodename;
    }

    public final String getChildText(String string) {
        return NodeInterface.getText(this.getChildByTagName(string));
    }

    public final int getChildTextInt(String string) {
        return NodeInterface.getTextInt(this.getChildByTagName(string));
    }

    public final double getChildTextDouble(String string) {
        return NodeInterface.getTextDouble(this.getChildByTagName(string));
    }

    public final String getText() {
        return NodeInterface.getText(this.node);
    }

    public boolean hasAttribute(String string) {
        return NodeInterface.hasAttribute(this.node, string);
    }

    public String getAttributeNS(String string, String string2) {
        return this.node.getAttributeNS(string2, string);
    }

    public String getAttribute(String string) {
        return this.node.getAttribute(string);
    }

    public int getAttributeInt(String string) {
        return Integer.parseInt(this.getAttribute(string));
    }

    public double getAttributeDouble(String string) {
        return Double.parseDouble(this.getAttribute(string));
    }

    protected final NodeList getChildNodes() {
        return this.node.getChildNodes();
    }

    protected final Node getFirstChild() {
        return this.node.getFirstChild();
    }

    protected final Node getLastChild() {
        return this.node.getLastChild();
    }

    protected final Node getChildByTagName(String string) {
        NodeList nodeList = this.node.getElementsByTagName(string);
        if (nodeList.getLength() >= 1) {
            return nodeList.item(0);
        }
        return null;
    }

    protected final Node getChildByTagNameNS(String string, String string2) {
        NodeList nodeList = this.node.getElementsByTagNameNS(string2, string);
        if (nodeList.getLength() >= 1) {
            return nodeList.item(0);
        }
        return null;
    }

    static Node getChildByTagName(String string, Node node) {
        if (node == null) {
            return null;
        }
        NodeList nodeList = ((Element)node).getElementsByTagName(string);
        if (nodeList.getLength() >= 1) {
            return nodeList.item(0);
        }
        return null;
    }

    protected static boolean hasChild(String string, Node node) {
        return NodeInterface.getChildByTagName(string, node) != null;
    }

    protected static String getText(Node node) {
        if (node == null) {
            return null;
        }
        NodeList nodeList = node.getChildNodes();
        String string = "";
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 3) continue;
            string = string + node2.getNodeValue();
        }
        return string.trim();
    }

    protected static final int getTextInt(Node node) throws NullPointerException {
        return Integer.parseInt(NodeInterface.getText(node));
    }

    protected static final double getTextDouble(Node node) throws NullPointerException {
        return Double.parseDouble(NodeInterface.getText(node));
    }

    protected static final boolean hasAttribute(Node node, String string) {
        return ((Element)node).hasAttribute(string);
    }

    protected static final String getAttribute(Node node, String string) {
        try {
            return node.getAttributes().getNamedItem(string).getNodeValue();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    protected static final int getAttributeInt(Node node, String string) {
        return Integer.parseInt(NodeInterface.getAttribute(node, string));
    }

    protected static final double getAttributeDouble(Node node, String string) {
        return Double.parseDouble(NodeInterface.getAttribute(node, string));
    }
}

