/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.sound;

import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import jp.crestmuse.cmx.math.DoubleArray;
import jp.crestmuse.cmx.math.DoubleArrayFactory;
import jp.crestmuse.cmx.sound.AudioDataCompatible;

public class AudioInputStreamWrapper
implements AudioDataCompatible {
    private TargetDataLine line;
    private AudioInputStream audioin;
    private AudioFormat fmt;
    private int channels;
    private int sampleRate;
    private byte[] buff = null;
    private double[] cache = null;
    private int next = 0;
    private static final int CACHE_SIZE = 65536;
    private static final DoubleArrayFactory factory = DoubleArrayFactory.getFactory();

    AudioInputStreamWrapper(TargetDataLine targetDataLine) {
        this.line = targetDataLine;
        this.audioin = new AudioInputStream(targetDataLine);
        this.fmt = this.audioin.getFormat();
        this.channels = this.fmt.getChannels();
        this.sampleRate = (int)this.fmt.getSampleRate();
    }

    public AudioInputStream getAudioInputStream() {
        return this.audioin;
    }

    public TargetDataLine getLine() {
        return this.line;
    }

    public int channels() {
        return this.channels;
    }

    public int sampleRate() {
        return this.sampleRate;
    }

    public AudioFormat getAudioFormat() {
        return this.fmt;
    }

    public DoubleArray[] getDoubleArrayWaveform() {
        throw new UnsupportedOperationException();
    }

    public byte[] getByteArrayWaveform() {
        throw new UnsupportedOperationException();
    }

    public boolean supportsWholeWaveformGetter() {
        return false;
    }

    public DoubleArray[] readNext(int n, int n2) throws IOException {
        int n3;
        int n4;
        int n5;
        DoubleArray[] doubleArrayArray = new DoubleArray[this.channels];
        for (n5 = 0; n5 < doubleArrayArray.length; ++n5) {
            doubleArrayArray[n5] = factory.createArray(n);
        }
        if (this.cache == null) {
            if (this.buff == null || this.buff.length < n * this.channels) {
                this.buff = new byte[n * this.channels];
            }
            this.cache = new double[65536];
            this.audioin.read(this.buff, 0, n * this.channels);
            for (n5 = 0; n5 < n; ++n5) {
                for (int i = 0; i < this.channels; ++i) {
                    int n6 = this.buff[n5 * this.channels + i] + 128;
                    if (n6 >= 128) {
                        n6 -= 256;
                    }
                    this.cache[this.next + n5 * this.channels + i] = (double)n6 / 256.0;
                    doubleArrayArray[i].set(n5, this.cache[this.next + n5 * this.channels + i]);
                }
            }
            this.next += n * this.channels;
            return doubleArrayArray;
        }
        n5 = n - n2;
        if (this.buff == null || this.buff.length < n5 * this.channels) {
            this.buff = new byte[n5 * this.channels];
        }
        for (n4 = 0; n4 < n2; ++n4) {
            for (n3 = 0; n3 < this.channels; ++n3) {
                doubleArrayArray[n3].set(n4, this.cache[this.next + (n4 - n2) * this.channels + n3]);
            }
        }
        this.audioin.read(this.buff, 0, n5 * this.channels);
        for (n4 = 0; n4 < n5; ++n4) {
            for (n3 = 0; n3 < this.channels; ++n3) {
                int n7 = this.buff[n4 * this.channels + n3] + 128;
                if (n7 >= 128) {
                    n7 -= 256;
                }
                this.cache[this.next + n4 * this.channels + n3] = (double)n7 / 256.0;
                doubleArrayArray[n3].set(n2 + n4, this.cache[this.next + n4 * this.channels + n3]);
            }
        }
        this.next += n5 * this.channels;
        if (this.next >= 65536 - n) {
            System.arraycopy(this.cache, this.next - n, this.cache, 0, n);
            this.next = n;
        }
        return doubleArrayArray;
    }

    public boolean hasNext(int n) {
        return this.line.isOpen();
    }

    public static AudioInputStreamWrapper createWrapper8(int n) throws LineUnavailableException {
        AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, n, 8, 1, 1, n, true);
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, audioFormat);
        TargetDataLine targetDataLine = (TargetDataLine)AudioSystem.getLine(info);
        targetDataLine.open(audioFormat);
        AudioInputStreamWrapper audioInputStreamWrapper = new AudioInputStreamWrapper(targetDataLine);
        return audioInputStreamWrapper;
    }
}

