/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.kyoto_u.jfftw3;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;

abstract class Plan {
    private static final int planSize;
    final ByteBuffer srcBbuff;
    final ByteBuffer dstBbuff;
    private final DoubleBuffer srcDbuff;
    private final DoubleBuffer dstDbuff;
    final byte[] planHandler;

    Plan(int n, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException(String.format("srcSize must be positive: %d", n));
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException(String.format("dstSize must be positive: %d", n2));
        }
        this.srcBbuff = Plan.fftwMalloc(n).order(ByteOrder.nativeOrder());
        this.dstBbuff = Plan.fftwMalloc(n2).order(ByteOrder.nativeOrder());
        this.srcDbuff = this.srcBbuff.asDoubleBuffer();
        this.dstDbuff = this.dstBbuff.asDoubleBuffer();
        this.planHandler = new byte[planSize];
    }

    public DoubleBuffer src() {
        return this.srcDbuff;
    }

    public DoubleBuffer dst() {
        return this.dstDbuff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            this.destroyPlan();
        }
    }

    private static final native ByteBuffer fftwMalloc(int var0);

    private static final native int sizeofPlan();

    public final native void execute();

    private final native void destroyPlan();

    static {
        System.loadLibrary("jfftw3");
        planSize = Plan.sizeofPlan();
    }
}

