/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.kyoto_u.jfftw3;

import java.util.Set;
import jp.ac.kyoto_u.jfftw3.Flag;
import jp.ac.kyoto_u.jfftw3.Misc;
import jp.ac.kyoto_u.jfftw3.NonPositiveTransformSizeException;
import jp.ac.kyoto_u.jfftw3.Plan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlanR2c
extends Plan {
    private PlanR2c(int n, int n2) {
        super(n, n2);
    }

    public static final PlanR2c newPlan(int n, Set<Flag> set) {
        if (n <= 0) {
            throw new NonPositiveTransformSizeException(n);
        }
        if (set == null) {
            throw new NullPointerException("flagSet");
        }
        int n2 = n;
        int n3 = (n / 2 + 1) * 2;
        PlanR2c planR2c = new PlanR2c(n2, n3);
        planR2c.fftwPlanDftR2c1d(n, set);
        return planR2c;
    }

    public static final PlanR2c newPlan(int n, int n2, Set<Flag> set) {
        if (n <= 0) {
            throw new NonPositiveTransformSizeException(n, "n0");
        }
        if (n2 <= 0) {
            throw new NonPositiveTransformSizeException(n2, "n1");
        }
        if (set == null) {
            throw new NullPointerException("flagSet");
        }
        int n3 = n * n2;
        int n4 = n * (n2 / 2 + 1) * 2;
        PlanR2c planR2c = new PlanR2c(n3, n4);
        planR2c.fftwPlanDftR2c2d(n, n2, set);
        return planR2c;
    }

    public static final PlanR2c newPlan(int n, int n2, int n3, Set<Flag> set) {
        if (n <= 0) {
            throw new NonPositiveTransformSizeException(n, "n0");
        }
        if (n2 <= 0) {
            throw new NonPositiveTransformSizeException(n2, "n1");
        }
        if (n3 <= 0) {
            throw new NonPositiveTransformSizeException(n3, "n2");
        }
        if (set == null) {
            throw new NullPointerException("flagSet");
        }
        int n4 = n * n2 * n3;
        int n5 = n * n2 * (n3 / 2 + 1) * 2;
        PlanR2c planR2c = new PlanR2c(n4, n5);
        planR2c.fftwPlanDftR2c3d(n, n2, n3, set);
        return planR2c;
    }

    public static final PlanR2c newPlan(int[] nArray, Set<Flag> set) {
        int n;
        if (nArray == null) {
            throw new NullPointerException("n");
        }
        if (nArray.length == 0) {
            throw new IllegalArgumentException("n.length must be positive");
        }
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] > 0) continue;
            throw new NonPositiveTransformSizeException(nArray[n], String.format("n[%d]", n));
        }
        if (set == null) {
            throw new NullPointerException("flagSet");
        }
        n = Misc.prod(nArray);
        int n2 = Misc.prod2(nArray);
        PlanR2c planR2c = new PlanR2c(n, n2);
        planR2c.fftwPlanDftR2c(nArray, set);
        return planR2c;
    }

    private final native void fftwPlanDftR2c1d(int var1, Set<Flag> var2);

    private final native void fftwPlanDftR2c2d(int var1, int var2, Set<Flag> var3);

    private final native void fftwPlanDftR2c3d(int var1, int var2, int var3, Set<Flag> var4);

    private final native void fftwPlanDftR2c(int[] var1, Set<Flag> var2);

    static {
        System.loadLibrary("jfftw3");
    }
}

